/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.info;

import com.google.common.base.Preconditions;
import com.vaadin.ui.Component;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.InfoPanelItem;
import org.opennms.features.topology.api.topo.Ref;

public abstract class SingleSelectedInfoPanelItem<T extends Ref>
implements InfoPanelItem {
    private static final String NOTHING_SELECTED = "Neither a vertex nor a edge is selected.";

    @Override
    public Component getComponent(GraphContainer container) {
        T ref = this.findSingleSelectedItem(container);
        Preconditions.checkState((ref != null ? 1 : 0) != 0, (Object)NOTHING_SELECTED);
        return this.getComponent(ref, container);
    }

    @Override
    public boolean contributesTo(GraphContainer container) {
        T ref = this.findSingleSelectedItem(container);
        if (ref != null) {
            return this.contributesTo(ref, container);
        }
        return false;
    }

    @Override
    public String getTitle(GraphContainer container) {
        T ref = this.findSingleSelectedItem(container);
        Preconditions.checkState((ref != null ? 1 : 0) != 0, (Object)NOTHING_SELECTED);
        return this.getTitle(ref);
    }

    protected abstract boolean contributesTo(T var1, GraphContainer var2);

    protected abstract Component getComponent(T var1, GraphContainer var2);

    protected abstract T findSingleSelectedItem(GraphContainer var1);

    protected abstract String getTitle(T var1);
}

