/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.features.topology.api.IViewContribution;
import org.opennms.features.topology.api.WidgetUpdateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetManager {
    private static final Logger LOG = LoggerFactory.getLogger(WidgetManager.class);
    private List<IViewContribution> m_viewContributors = new CopyOnWriteArrayList<IViewContribution>();
    private List<WidgetUpdateListener> m_listeners = new CopyOnWriteArrayList<WidgetUpdateListener>();
    private Comparator<IViewContribution> TITLE_COMPARATOR = new Comparator<IViewContribution>(){

        @Override
        public int compare(IViewContribution o1, IViewContribution o2) {
            return o1.getTitle().compareTo(o2.getTitle());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(WidgetUpdateListener listener) {
        LOG.info("Adding WidgetUpdateListener {} to WidgetManager {}", (Object)listener, (Object)this);
        List<WidgetUpdateListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
            this.updateWidgetListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(WidgetUpdateListener listener) {
        LOG.info("Removing WidgetUpdateListener {} from WidgetManager {}", (Object)listener, (Object)this);
        List<WidgetUpdateListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    public int widgetCount() {
        return this.m_viewContributors.size();
    }

    public List<IViewContribution> getWidgets() {
        ArrayList<IViewContribution> widgets = new ArrayList<IViewContribution>();
        widgets.addAll(this.m_viewContributors);
        Collections.sort(widgets, this.TITLE_COMPARATOR);
        return Collections.unmodifiableList(widgets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onBind(IViewContribution viewContribution) {
        LOG.info("Binding IViewContribution {} to WidgetManager {}", (Object)viewContribution, (Object)this);
        List<IViewContribution> list = this.m_viewContributors;
        synchronized (list) {
            try {
                this.m_viewContributors.add(viewContribution);
                this.updateWidgetListeners();
            }
            catch (Throwable e) {
                LOG.warn("Exception during onBind()", e);
            }
        }
    }

    private void updateWidgetListeners() {
        for (WidgetUpdateListener listener : this.m_listeners) {
            listener.widgetListUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onUnbind(IViewContribution viewContribution) {
        LOG.info("Unbinding IViewContribution {} from WidgetManager {}", (Object)viewContribution, (Object)this);
        List<IViewContribution> list = this.m_viewContributors;
        synchronized (list) {
            try {
                this.m_viewContributors.remove(viewContribution);
                this.updateWidgetListeners();
            }
            catch (Throwable e) {
                LOG.warn("Exception during onUnbind()", e);
            }
        }
    }
}

