/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.operations;

import com.vaadin.ui.Window;
import java.net.URL;
import java.util.List;
import org.opennms.features.topology.api.AbstractOperation;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.netutils.internal.Node;
import org.opennms.features.topology.netutils.internal.ResourceGraphsWindow;

public class ResourceGraphsOperation
extends AbstractOperation {
    private String m_resourceGraphListURL;
    private String m_resourceGraphNodeURL;

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        try {
            Node node;
            String label = "";
            int nodeID = -1;
            if (targets != null) {
                for (VertexRef target : targets) {
                    String labelValue = ResourceGraphsOperation.getLabelValue((OperationContext)operationContext, (VertexRef)target);
                    Integer nodeValue = ResourceGraphsOperation.getNodeIdValue((OperationContext)operationContext, (VertexRef)target);
                    if (nodeValue == null || nodeValue <= 0) continue;
                    label = labelValue == null ? "" : labelValue;
                    nodeID = nodeValue;
                    break;
                }
            }
            String url = (node = new Node(nodeID, null, label)).getNodeID() >= 0 ? this.getResourceGraphNodeURL() + "[" + node.getNodeID() + "]" : this.getResourceGraphListURL();
            URL fullUrl = new URL(this.getFullUrl(url));
            operationContext.getMainWindow().addWindow((Window)new ResourceGraphsWindow(node, fullUrl));
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to create resource graph window.", e);
        }
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        if (operationContext.getDisplayLocation() == OperationContext.DisplayLocation.MENUBAR) {
            return true;
        }
        return targets != null && targets.size() > 0 && targets.get(0) != null;
    }

    public String getId() {
        return "contextResourceGraphs";
    }

    public String getResourceGraphListURL() {
        return this.m_resourceGraphListURL;
    }

    public void setResourceGraphListURL(String resourceGraphListURL) {
        this.m_resourceGraphListURL = resourceGraphListURL;
    }

    public String getResourceGraphNodeURL() {
        return this.m_resourceGraphNodeURL;
    }

    public void setResourceGraphNodeURL(String resourceGraphNodeURL) {
        this.m_resourceGraphNodeURL = resourceGraphNodeURL;
    }
}

