/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.operations;

import com.vaadin.ui.Window;
import java.net.URL;
import java.util.List;
import org.opennms.features.topology.api.AbstractOperation;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.netutils.internal.Node;
import org.opennms.features.topology.netutils.internal.NodeInfoWindow;

public class NodeInfoOperation
extends AbstractOperation {
    private String m_nodePageURL;
    private String m_nodeListURL;

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        try {
            Node node;
            String label = "";
            int nodeID = -1;
            if (targets != null) {
                for (VertexRef target : targets) {
                    String labelValue = NodeInfoOperation.getLabelValue((OperationContext)operationContext, (VertexRef)target);
                    Integer nodeValue = NodeInfoOperation.getNodeIdValue((OperationContext)operationContext, (VertexRef)target);
                    if (nodeValue == null || nodeValue <= 0) continue;
                    label = labelValue == null ? "" : labelValue;
                    nodeID = nodeValue;
                    break;
                }
            }
            String url = (node = new Node(nodeID, null, label)).getNodeID() >= 0 ? this.getNodePageURL() + node.getNodeID() : this.getNodeListURL();
            URL fullUrl = new URL(this.getFullUrl(url));
            operationContext.getMainWindow().addWindow((Window)new NodeInfoWindow(node, fullUrl));
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to create node window.", e);
        }
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        if (operationContext.getDisplayLocation() == OperationContext.DisplayLocation.MENUBAR) {
            return true;
        }
        return targets != null && targets.size() > 0 && targets.get(0) != null;
    }

    public String getId() {
        return "contextNodeInfo";
    }

    public String getNodePageURL() {
        return this.m_nodePageURL;
    }

    public void setNodePageURL(String nodePageURL) {
        this.m_nodePageURL = nodePageURL;
    }

    public String getNodeListURL() {
        return this.m_nodeListURL;
    }

    public void setNodeListURL(String nodeListURL) {
        this.m_nodeListURL = nodeListURL;
    }
}

