/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.operations;

import com.vaadin.ui.Window;
import java.net.URL;
import java.util.List;
import org.opennms.features.topology.api.AbstractOperation;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.netutils.internal.EventsAlarmsWindow;
import org.opennms.features.topology.netutils.internal.Node;

public class EventsAlarmsOperation
extends AbstractOperation
implements Operation {
    private String m_eventsURL;
    private String m_alarmsURL;

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        try {
            String alarmUrl;
            String eventUrl;
            Node node;
            String label = "";
            int nodeID = -1;
            if (targets != null) {
                for (VertexRef target : targets) {
                    String labelValue = EventsAlarmsOperation.getLabelValue((OperationContext)operationContext, (VertexRef)target);
                    Integer nodeValue = EventsAlarmsOperation.getNodeIdValue((OperationContext)operationContext, (VertexRef)target);
                    if (nodeValue == null || nodeValue <= 0) continue;
                    label = labelValue == null ? "" : labelValue;
                    nodeID = nodeValue;
                    break;
                }
            }
            if ((node = new Node(nodeID, null, label)).getNodeID() >= 0) {
                eventUrl = this.getEventsURL() + "?filter=node%3D" + node.getNodeID();
                alarmUrl = this.getAlarmsURL() + "?sortby=id&acktype=unacklimit=20&filter=node%3D" + node.getNodeID();
            } else {
                eventUrl = this.getEventsURL();
                alarmUrl = this.getAlarmsURL();
            }
            URL fullEventUrl = new URL(this.getFullUrl(eventUrl));
            URL fullAlarmUrl = new URL(this.getFullUrl(alarmUrl));
            operationContext.getMainWindow().addWindow((Window)new EventsAlarmsWindow(node, fullEventUrl, fullAlarmUrl));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to create event/alarm window.", e);
        }
        return null;
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        if (operationContext.getDisplayLocation() == OperationContext.DisplayLocation.MENUBAR) {
            return true;
        }
        return targets != null && targets.size() > 0 && targets.get(0) != null;
    }

    public String getId() {
        return "EventsAlarms";
    }

    public String getEventsURL() {
        return this.m_eventsURL;
    }

    public void setEventsURL(String eventsURL) {
        this.m_eventsURL = eventsURL;
    }

    public String getAlarmsURL() {
        return this.m_alarmsURL;
    }

    public void setAlarmsURL(String alarmsURL) {
        this.m_alarmsURL = alarmsURL;
    }
}

