/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsTopologyLogger
implements OnmsTopologyConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsTopologyLogger.class);
    private final OnmsTopologyProtocol m_protocol;
    private List<OnmsTopologyMessage> m_queue = new ArrayList<OnmsTopologyMessage>();

    public OnmsTopologyLogger(String protocol) throws OnmsTopologyException {
        this.m_protocol = OnmsTopologyProtocol.create((String)protocol);
    }

    public String getName() {
        return this.m_protocol.getId() + ":Consumer:Logger";
    }

    public Set<OnmsTopologyProtocol> getProtocols() {
        HashSet<OnmsTopologyProtocol> protocols = new HashSet<OnmsTopologyProtocol>();
        protocols.add(this.m_protocol);
        return protocols;
    }

    public void consume(OnmsTopologyMessage message) {
        this.m_queue.add(message);
        StringBuffer txt = new StringBuffer();
        txt.append(this.getName());
        txt.append("-");
        txt.append(message.getMessagestatus());
        txt.append("-");
        txt.append(message.getMessagebody().getId());
        if (message.getMessagebody() instanceof OnmsTopologyVertex) {
            txt.append(":");
            txt.append(((OnmsTopologyVertex)message.getMessagebody()).getLabel());
        } else if (message.getMessagebody() instanceof OnmsTopologyEdge) {
            txt.append(":");
            OnmsTopologyEdge edge = (OnmsTopologyEdge)message.getMessagebody();
            OnmsTopologyPort source = edge.getSource();
            txt.append(source.getVertex().getId());
            txt.append(":");
            txt.append(source.getIfname());
            txt.append("|");
            OnmsTopologyPort target = edge.getTarget();
            txt.append(target.getVertex().getId());
            txt.append(":");
            txt.append(target.getIfname());
        }
        LOG.debug(txt.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OnmsTopologyMessage> getQueue() {
        List<OnmsTopologyMessage> list = this.m_queue;
        synchronized (list) {
            return new ArrayList<OnmsTopologyMessage>(this.m_queue);
        }
    }

    public OnmsTopologyProtocol getProtocol() {
        return this.m_protocol;
    }
}

