/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsTopologyDaoInMemoryImpl
implements OnmsTopologyDao {
    Logger LOG = LoggerFactory.getLogger(OnmsTopologyDaoInMemoryImpl.class);
    private Map<OnmsTopologyProtocol, OnmsTopologyUpdater> m_updatersMap = new HashMap<OnmsTopologyProtocol, OnmsTopologyUpdater>();
    Set<OnmsTopologyConsumer> m_consumers = new HashSet<OnmsTopologyConsumer>();

    public OnmsTopology getTopology(String protocolSupported) throws OnmsTopologyException {
        OnmsTopologyProtocol protocol = OnmsTopologyProtocol.create((String)protocolSupported);
        if (this.m_updatersMap.containsKey(protocol)) {
            return this.m_updatersMap.get(protocol).getTopology();
        }
        throw new OnmsTopologyException(String.format("%s protocol not supported", protocolSupported));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(OnmsTopologyConsumer consumer) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(OnmsTopologyConsumer consumer) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(OnmsTopologyUpdater updater) throws OnmsTopologyException {
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            if (this.m_updatersMap.containsKey(updater.getProtocol())) {
                throw new OnmsTopologyException("Protocol already registered", updater.getProtocol());
            }
            this.m_updatersMap.put(updater.getProtocol(), updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(OnmsTopologyUpdater updater) throws OnmsTopologyException {
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            OnmsTopologyUpdater subscribed = this.m_updatersMap.get(updater.getProtocol());
            if (subscribed == null) {
                throw new OnmsTopologyException("updater is not registered", updater.getProtocol());
            }
            if (subscribed != updater) {
                throw new OnmsTopologyException("updater is not registered", updater.getProtocol());
            }
            this.m_updatersMap.remove(updater.getProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSupportedProtocols() {
        HashSet<String> protocols = new HashSet<String>();
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            this.m_updatersMap.keySet().stream().forEach(p -> protocols.add(p.getId()));
        }
        return protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OnmsTopologyUpdater updater, OnmsTopologyMessage message) throws OnmsTopologyException {
        OnmsTopologyProtocol protocol = updater.getProtocol();
        if (!this.m_updatersMap.containsKey(protocol)) {
            throw new OnmsTopologyException(String.format("cannot update message with id: %s. Protocol not supported", message.getMessagebody().getId()), protocol, message.getMessagestatus());
        }
        if (this.m_updatersMap.get(protocol) != updater) {
            throw new OnmsTopologyException(String.format("cannot update message with id: %s. Updater not registered", message.getMessagebody().getId()), protocol, message.getMessagestatus());
        }
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.stream().filter(consumer -> consumer.getProtocols().contains(protocol)).forEach(consumer -> consumer.consume(message));
        }
    }
}

