/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.topologies.service.api;

import org.mockito.Mockito;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class EdgeMockUtil {
    public static final String PROTOCOL = "CDP";
    public static final String EDGE_ID = "edge.id";
    public static final String EDGE_TOOLTIP = "edge.tooltip";
    public static final String SOURCE_TOOLTIP = "edge.source.tooltip";
    public static final String TARGET_TOOLTIP = "edge.target.tooltip";
    public static final String SOURCE_ID = "source.id";
    public static final String TARGET_ID = "target.id";
    public static final int SOURCE_NODE_ID = 1;
    public static final int TARGET_NODE_ID = 2;
    public static final int SOURCE_IFINDEX = 101;
    public static final int TARGET_IFINDEX = 102;
    public static final String SOURCE_VERTEX_ID = "source.vertex.id";
    public static final String TARGET_VERTEX_ID = "target.vertex.id";

    public static OnmsTopologyEdge createEdge() {
        OnmsTopologyEdge edgeMock = (OnmsTopologyEdge)Mockito.mock(OnmsTopologyEdge.class);
        Mockito.when((Object)edgeMock.getId()).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)edgeMock.getToolTipText()).thenReturn((Object)EDGE_TOOLTIP);
        return edgeMock;
    }

    public static void addPort(boolean isSource, OnmsTopologyEdge edge) {
        OnmsTopologyPort portMock = (OnmsTopologyPort)Mockito.mock(OnmsTopologyPort.class);
        OnmsTopologyVertex vertexPortMock = (OnmsTopologyVertex)Mockito.mock(OnmsTopologyVertex.class);
        Mockito.when((Object)portMock.getVertex()).thenReturn((Object)vertexPortMock);
        if (isSource) {
            Mockito.when((Object)edge.getSource()).thenReturn((Object)portMock);
            Mockito.when((Object)portMock.getIfindex()).thenReturn((Object)101);
            Mockito.when((Object)portMock.getId()).thenReturn((Object)SOURCE_ID);
            Mockito.when((Object)vertexPortMock.getNodeid()).thenReturn((Object)1);
            Mockito.when((Object)portMock.getToolTipText()).thenReturn((Object)SOURCE_TOOLTIP);
            Mockito.when((Object)vertexPortMock.getId()).thenReturn((Object)SOURCE_VERTEX_ID);
        } else {
            Mockito.when((Object)edge.getTarget()).thenReturn((Object)portMock);
            Mockito.when((Object)portMock.getId()).thenReturn((Object)TARGET_ID);
            Mockito.when((Object)vertexPortMock.getNodeid()).thenReturn((Object)2);
            Mockito.when((Object)portMock.getIfindex()).thenReturn((Object)102);
            Mockito.when((Object)portMock.getToolTipText()).thenReturn((Object)TARGET_TOOLTIP);
            Mockito.when((Object)vertexPortMock.getId()).thenReturn((Object)TARGET_VERTEX_ID);
        }
    }

    public static void addSegment(boolean isSource, OnmsTopologyEdge edge) {
        OnmsTopologyPort segmentMock = (OnmsTopologyPort)Mockito.mock(OnmsTopologyPort.class);
        OnmsTopologyVertex vertexSegmentMock = (OnmsTopologyVertex)Mockito.mock(OnmsTopologyVertex.class);
        Mockito.when((Object)segmentMock.getVertex()).thenReturn((Object)vertexSegmentMock);
        if (isSource) {
            Mockito.when((Object)edge.getSource()).thenReturn((Object)segmentMock);
            Mockito.when((Object)edge.getSource().getVertex().getNodeid()).thenReturn(null);
            Mockito.when((Object)segmentMock.getId()).thenReturn((Object)SOURCE_ID);
            Mockito.when((Object)segmentMock.getToolTipText()).thenReturn((Object)SOURCE_TOOLTIP);
        } else {
            Mockito.when((Object)edge.getTarget()).thenReturn((Object)segmentMock);
            Mockito.when((Object)edge.getTarget().getVertex().getNodeid()).thenReturn(null);
            Mockito.when((Object)segmentMock.getId()).thenReturn((Object)TARGET_ID);
            Mockito.when((Object)segmentMock.getToolTipText()).thenReturn((Object)TARGET_TOOLTIP);
        }
    }

    public static void addNode(boolean isSource, OnmsTopologyEdge edge) {
        OnmsTopologyPort nodeMock = (OnmsTopologyPort)Mockito.mock(OnmsTopologyPort.class);
        OnmsTopologyVertex vertexNodeMock = (OnmsTopologyVertex)Mockito.mock(OnmsTopologyVertex.class);
        Mockito.when((Object)nodeMock.getVertex()).thenReturn((Object)vertexNodeMock);
        if (isSource) {
            Mockito.when((Object)edge.getSource()).thenReturn((Object)nodeMock);
            Mockito.when((Object)edge.getSource().getIfindex()).thenReturn(null);
            Mockito.when((Object)nodeMock.getId()).thenReturn((Object)SOURCE_ID);
            Mockito.when((Object)vertexNodeMock.getNodeid()).thenReturn((Object)1);
        } else {
            Mockito.when((Object)edge.getTarget()).thenReturn((Object)nodeMock);
            Mockito.when((Object)edge.getTarget().getIfindex()).thenReturn(null);
            Mockito.when((Object)nodeMock.getId()).thenReturn((Object)TARGET_ID);
            Mockito.when((Object)vertexNodeMock.getNodeid()).thenReturn((Object)2);
        }
    }
}

