/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.api;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyAbstractRef;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyRef;

public class OnmsTopologyEdge
extends OnmsTopologyAbstractRef
implements OnmsTopologyRef {
    private final OnmsTopologyPort m_source;
    private final OnmsTopologyPort m_target;

    public static OnmsTopologyEdge create(String id, OnmsTopologyPort source, OnmsTopologyPort target) throws OnmsTopologyException {
        if (source == null && target == null) {
            throw new OnmsTopologyException("source and target port null, cannot create edge");
        }
        if (source == null) {
            throw new OnmsTopologyException("source port null, cannot create edge");
        }
        if (target == null) {
            throw new OnmsTopologyException("target port null, cannot create edge");
        }
        if (source.getId().equals(target.getId())) {
            throw new OnmsTopologyException("target equals source port, cannot create edge");
        }
        return new OnmsTopologyEdge(id, source, target);
    }

    private OnmsTopologyEdge(String id, OnmsTopologyPort source, OnmsTopologyPort target) {
        super(id);
        this.m_source = source;
        this.m_target = target;
    }

    public OnmsTopologyPort getSource() {
        return this.m_source;
    }

    public OnmsTopologyPort getTarget() {
        return this.m_target;
    }

    public OnmsTopologyPort getPort(String id) {
        return this.getPorts().stream().filter(p -> id.equals(p.getId())).findAny().orElse(null);
    }

    public boolean hasPort(String id) {
        return this.getPort(id) != null;
    }

    public List<OnmsTopologyPort> getPorts() {
        ArrayList<OnmsTopologyPort> ports = new ArrayList<OnmsTopologyPort>();
        ports.add(this.m_source);
        ports.add(this.m_target);
        return ports;
    }
}

