/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.File;
import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.ticketd.DefaultTicketerServiceLayer;
import org.opennms.netmgt.ticketd.DroolsTicketerConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsTicketerServiceLayer
extends DefaultTicketerServiceLayer {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsTicketerServiceLayer.class);
    DroolsTicketerConfigDao m_configDao;
    KnowledgeBase m_knowledgeBase;

    public DroolsTicketerServiceLayer() {
        this.m_configDao = new DroolsTicketerConfigDao();
        this.m_knowledgeBase = this.createKnowledgeBase();
    }

    public DroolsTicketerServiceLayer(DroolsTicketerConfigDao configDao) {
        this.m_configDao = configDao;
        this.m_knowledgeBase = this.createKnowledgeBase();
    }

    public DroolsTicketerConfigDao getConfigDao() {
        return this.m_configDao;
    }

    public void reloadTicketer() {
        LOG.debug("reloadTicketer: Reloading ticketer");
        this.m_knowledgeBase = this.createKnowledgeBase();
    }

    private KnowledgeBase createKnowledgeBase() {
        LOG.debug("createKnowledgeBase: Creating Drools KnowledgeBase");
        Properties props = new Properties();
        props.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration(props);
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        builder.add(ResourceFactory.newFileResource((File)this.m_configDao.getRulesFile()), ResourceType.DRL);
        if (builder.hasErrors()) {
            LOG.error("Failed to create Drools KnowledgeBase: {}", (Object)builder.getErrors().toString());
            return null;
        }
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addKnowledgePackages(builder.getKnowledgePackages());
        return knowledgeBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ticket createTicketFromAlarm(OnmsAlarm alarm) {
        LOG.debug("createTicketFromAlarm: Processing ticket.");
        if (this.m_knowledgeBase == null) {
            LOG.error("KnowledgeBase is NULL, creating basic ticket form alarm.");
            return super.createTicketFromAlarm(alarm);
        }
        Ticket ticket = new Ticket();
        StatefulKnowledgeSession session = this.m_knowledgeBase.newStatefulKnowledgeSession();
        try {
            session.setGlobal("ticket", (Object)ticket);
            session.insert((Object)alarm);
            session.insert((Object)alarm.getNode());
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
        LOG.debug("createTicketFromAlarm: Succesfully processed ticket.");
        return ticket;
    }
}

