/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterData;

public class VlanCounters
implements CounterData {
    public final long vlan_id;
    public final UnsignedLong octets;
    public final long ucastPkts;
    public final long multicastPkts;
    public final long broadcastPkts;
    public final long discards;

    public VlanCounters(ByteBuffer buffer) throws InvalidPacketException {
        this.vlan_id = BufferUtils.uint32((ByteBuffer)buffer);
        this.octets = BufferUtils.uint64((ByteBuffer)buffer);
        this.ucastPkts = BufferUtils.uint32((ByteBuffer)buffer);
        this.multicastPkts = BufferUtils.uint32((ByteBuffer)buffer);
        this.broadcastPkts = BufferUtils.uint32((ByteBuffer)buffer);
        this.discards = BufferUtils.uint32((ByteBuffer)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("vlan_id", this.vlan_id).add("octets", (Object)this.octets).add("ucastPkts", this.ucastPkts).add("multicastPkts", this.multicastPkts).add("broadcastPkts", this.broadcastPkts).add("discards", this.discards).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("vlan_id", this.vlan_id);
        bsonWriter.writeInt64("octets", this.octets.longValue());
        bsonWriter.writeInt64("ucastPkts", this.ucastPkts);
        bsonWriter.writeInt64("multicastPkts", this.multicastPkts);
        bsonWriter.writeInt64("broadcastPkts", this.broadcastPkts);
        bsonWriter.writeInt64("discards", this.discards);
        bsonWriter.writeEndDocument();
    }
}

