/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.bson.BsonBinary;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Opaque;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Charset;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;

public class ExtendedUser
implements FlowData {
    public final Charset src_charset;
    public final Opaque<byte[]> src_user;
    public final Charset dst_charset;
    public final Opaque<byte[]> dst_user;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src_charset", (Object)this.src_charset).add("src_user", this.src_user).add("dst_charset", (Object)this.dst_charset).add("dst_user", this.dst_user).toString();
    }

    public ExtendedUser(ByteBuf buffer) throws InvalidPacketException {
        this.src_charset = new Charset(buffer);
        this.src_user = new Opaque<Object>(buffer, Optional.empty(), Opaque::parseBytes);
        this.dst_charset = new Charset(buffer);
        this.dst_user = new Opaque<Object>(buffer, Optional.empty(), Opaque::parseBytes);
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("src_charset");
        this.src_charset.writeBson(bsonWriter, enr);
        bsonWriter.writeName("src_user");
        bsonWriter.writeBinaryData(new BsonBinary((byte[])this.src_user.value));
        bsonWriter.writeName("dst_charset");
        this.dst_charset.writeBson(bsonWriter, enr);
        bsonWriter.writeName("dst_user");
        bsonWriter.writeBinaryData(new BsonBinary((byte[])this.dst_user.value));
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

