/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Address;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleRecord;

public class SampleDatagramV5 {
    public final Address agent_address;
    public final long sub_agent_id;
    public final long sequence_number;
    public final long uptime;
    public final Array<SampleRecord> samples;

    public SampleDatagramV5(ByteBuffer buffer) throws InvalidPacketException {
        this.agent_address = new Address(buffer);
        this.sub_agent_id = BufferUtils.uint32((ByteBuffer)buffer);
        this.sequence_number = BufferUtils.uint32((ByteBuffer)buffer);
        this.uptime = BufferUtils.uint32((ByteBuffer)buffer);
        this.samples = new Array<Object>(buffer, Optional.empty(), SampleRecord::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("agent_address", (Object)this.agent_address).add("sub_agent_id", this.sub_agent_id).add("sequence_number", this.sequence_number).add("uptime", this.uptime).add("samples", this.samples).toString();
    }

    public SampleDatagramV5(Address agent_address, long sub_agent_id, long sequence_number, long uptime, Array<SampleRecord> samples) {
        this.agent_address = agent_address;
        this.sub_agent_id = sub_agent_id;
        this.sequence_number = sequence_number;
        this.uptime = uptime;
        this.samples = samples;
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment helper) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("agent_address");
        this.agent_address.writeBson(bsonWriter, helper);
        bsonWriter.writeInt64("sub_agent_id", this.sub_agent_id);
        bsonWriter.writeInt64("sequence_number", this.sequence_number);
        bsonWriter.writeInt64("uptime", this.uptime);
        bsonWriter.writeStartArray("samples");
        for (SampleRecord sampleRecord : this.samples) {
            sampleRecord.writeBson(bsonWriter, helper);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeEndDocument();
    }

    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
        this.agent_address.visit(visitor);
        for (SampleRecord sampleRecord : this.samples) {
            sampleRecord.visit(visitor);
        }
    }
}

