/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.AsPathSegmentType;

public class AsPathType {
    public final AsPathSegmentType type;
    public final Array<Long> asSet;
    public final Array<Long> asSequence;

    public AsPathType(ByteBuffer buffer) throws InvalidPacketException {
        this.type = AsPathSegmentType.from(buffer);
        switch (this.type) {
            case AS_SET: {
                this.asSet = new Array<Long>(buffer, Optional.empty(), BufferUtils::uint32);
                this.asSequence = null;
                break;
            }
            case AS_SEQUENCE: {
                this.asSet = null;
                this.asSequence = new Array<Long>(buffer, Optional.empty(), BufferUtils::uint32);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("asSet", this.asSet).add("asSequence", this.asSequence).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("type");
        this.type.writeBson(bsonWriter, enr);
        switch (this.type) {
            case AS_SET: {
                bsonWriter.writeStartArray("asSet");
                for (Long longValue : this.asSet) {
                    bsonWriter.writeInt64(longValue.longValue());
                }
                bsonWriter.writeEndArray();
                break;
            }
            case AS_SEQUENCE: {
                bsonWriter.writeStartArray("asSequence");
                for (Long longValue : this.asSequence) {
                    bsonWriter.writeInt64(longValue.longValue());
                }
                bsonWriter.writeEndArray();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        bsonWriter.writeEndDocument();
    }
}

