/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonBinary;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.AsciiString;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Opaque;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.MachineType;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.OsName;

public class HostDescr
implements CounterData {
    public final AsciiString hostname;
    public final Opaque<byte[]> uuid;
    public final MachineType machine_type;
    public final OsName os_name;
    public final AsciiString os_release;

    public HostDescr(ByteBuffer buffer) throws InvalidPacketException {
        this.hostname = new AsciiString(buffer);
        this.uuid = new Opaque<Object>(buffer, Optional.of(16), Opaque::parseBytes);
        this.machine_type = MachineType.from(buffer);
        this.os_name = OsName.from(buffer);
        this.os_release = new AsciiString(buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostname", (Object)this.hostname).add("uuid", this.uuid).add("machine_type", (Object)this.machine_type).add("os_name", (Object)this.os_name).add("os_release", (Object)this.os_release).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("hostname", this.hostname.value);
        bsonWriter.writeBinaryData("uuid", new BsonBinary((byte[])this.uuid.value));
        bsonWriter.writeName("machine_type");
        this.machine_type.writeBson(bsonWriter);
        bsonWriter.writeName("os_name");
        this.os_name.writeBson(bsonWriter, enr);
        bsonWriter.writeString("os_release", this.os_release.value);
        bsonWriter.writeEndDocument();
    }
}

