/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers;

import com.google.common.base.Throwables;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;

public class Inet6Header {
    public final int tos;
    public final int totalLength;
    public final int protocol;
    public final String srcAddress;
    public final String dstAddress;
    public final Integer srcPort;
    public final Integer dstPort;
    public final Integer tcpFlags;

    public Inet6Header(ByteBuffer buffer) throws InvalidPacketException {
        long version_tc_fl = BufferUtils.uint32((ByteBuffer)buffer);
        if (version_tc_fl >> 28 != 6L) {
            throw new InvalidPacketException(buffer, "Expected IPv6 Header", new Object[0]);
        }
        this.tos = (int)(version_tc_fl >> 20 & 0xFFL);
        this.totalLength = BufferUtils.uint16((ByteBuffer)buffer) + 40;
        this.protocol = BufferUtils.uint8((ByteBuffer)buffer);
        BufferUtils.skip((ByteBuffer)buffer, (int)1);
        try {
            this.srcAddress = Inet6Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)16)).getHostAddress();
            this.dstAddress = Inet6Address.getByAddress(BufferUtils.bytes((ByteBuffer)buffer, (int)16)).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
        switch (this.protocol) {
            case 6: {
                this.srcPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                BufferUtils.skip((ByteBuffer)buffer, (int)8);
                this.tcpFlags = BufferUtils.uint16((ByteBuffer)buffer) & 0x1FF;
                break;
            }
            case 17: 
            case 132: {
                this.srcPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.tcpFlags = null;
                break;
            }
            case 1: 
            case 58: {
                this.srcPort = 0;
                this.dstPort = BufferUtils.uint16((ByteBuffer)buffer);
                this.tcpFlags = null;
                break;
            }
            default: {
                this.srcPort = null;
                this.dstPort = null;
                this.tcpFlags = null;
            }
        }
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt32("tos", this.tos);
        bsonWriter.writeInt32("length", this.totalLength);
        bsonWriter.writeInt32("protocol", this.protocol);
        bsonWriter.writeString("src_ip", this.srcAddress);
        bsonWriter.writeString("dst_ip", this.dstAddress);
        if (this.srcPort != null) {
            bsonWriter.writeInt32("src_port", this.srcPort.intValue());
        }
        if (this.dstPort != null) {
            bsonWriter.writeInt32("dst_port", this.dstPort.intValue());
        }
        if (this.tcpFlags != null) {
            bsonWriter.writeInt32("tcp_flags", this.tcpFlags.intValue());
        }
        bsonWriter.writeEndDocument();
    }
}

