/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonBinary;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Opaque;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.HeaderProtocol;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.EthernetHeader;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.Inet4Header;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers.Inet6Header;

public class SampledHeader
implements FlowData {
    public final HeaderProtocol protocol;
    public final long frame_length;
    public final long stripped;
    public final EthernetHeader ethernetHeader;
    public final Inet4Header inet4Header;
    public final Inet6Header inet6Header;
    public final byte[] rawHeader;

    public SampledHeader(ByteBuffer buffer) throws InvalidPacketException {
        this.protocol = HeaderProtocol.from(buffer);
        this.frame_length = BufferUtils.uint32((ByteBuffer)buffer);
        this.stripped = BufferUtils.uint32((ByteBuffer)buffer);
        switch (this.protocol) {
            case ETHERNET_ISO88023: {
                this.ethernetHeader = (EthernetHeader)new Opaque<EthernetHeader>((ByteBuffer)buffer, Optional.empty(), (Opaque.Parser<EthernetHeader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/nio/ByteBuffer;)Ljava/lang/Object;, <init>(java.nio.ByteBuffer ), (Ljava/nio/ByteBuffer;)Lorg/opennms/netmgt/telemetry/protocols/sflow/parser/proto/headers/EthernetHeader;)()).value;
                this.inet4Header = this.ethernetHeader.inet4Header;
                this.inet6Header = this.ethernetHeader.inet6Header;
                this.rawHeader = this.ethernetHeader.rawHeader;
                break;
            }
            case IPv4: {
                this.ethernetHeader = null;
                this.inet4Header = (Inet4Header)new Opaque<Inet4Header>((ByteBuffer)buffer, Optional.empty(), (Opaque.Parser<Inet4Header>)LambdaMetafactory.metafactory(null, null, null, (Ljava/nio/ByteBuffer;)Ljava/lang/Object;, <init>(java.nio.ByteBuffer ), (Ljava/nio/ByteBuffer;)Lorg/opennms/netmgt/telemetry/protocols/sflow/parser/proto/headers/Inet4Header;)()).value;
                this.inet6Header = null;
                this.rawHeader = null;
                break;
            }
            case IPv6: {
                this.ethernetHeader = null;
                this.inet4Header = null;
                this.inet6Header = (Inet6Header)new Opaque<Inet6Header>((ByteBuffer)buffer, Optional.empty(), (Opaque.Parser<Inet6Header>)LambdaMetafactory.metafactory(null, null, null, (Ljava/nio/ByteBuffer;)Ljava/lang/Object;, <init>(java.nio.ByteBuffer ), (Ljava/nio/ByteBuffer;)Lorg/opennms/netmgt/telemetry/protocols/sflow/parser/proto/headers/Inet6Header;)()).value;
                this.rawHeader = null;
                break;
            }
            default: {
                this.ethernetHeader = null;
                this.inet4Header = null;
                this.inet6Header = null;
                this.rawHeader = (byte[])new Opaque<byte[]>((ByteBuffer)buffer, Optional.empty(), (Opaque.Parser<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/nio/ByteBuffer;)Ljava/lang/Object;, parseBytes(java.nio.ByteBuffer ), (Ljava/nio/ByteBuffer;)[B)()).value;
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", (Object)this.protocol).add("frame_length", this.frame_length).add("stripped", this.stripped).add("header", (Object)this.rawHeader).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("protocol");
        this.protocol.writeBson(bsonWriter);
        bsonWriter.writeInt64("frame_length", this.frame_length);
        bsonWriter.writeInt64("stripped", this.stripped);
        if (this.ethernetHeader != null) {
            bsonWriter.writeName("ethernet");
            this.ethernetHeader.writeBson(bsonWriter);
        }
        if (this.inet4Header != null) {
            bsonWriter.writeName("ipv4");
            this.inet4Header.writeBson(bsonWriter);
        }
        if (this.inet6Header != null) {
            bsonWriter.writeName("ipv6");
            this.inet6Header.writeBson(bsonWriter);
        }
        if (this.rawHeader != null) {
            bsonWriter.writeBinaryData("raw", new BsonBinary(this.rawHeader));
        }
        bsonWriter.writeEndDocument();
    }
}

