/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.adapter;

import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.protocols.common.utils.BsonUtils;

public class SFlow
implements Flow {
    private final Header header;
    private final BsonDocument document;

    public SFlow(Header header, BsonDocument document) {
        this.header = header;
        this.document = Objects.requireNonNull(document);
    }

    public long getTimestamp() {
        return this.header.getTimestamp();
    }

    public Long getBytes() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "length"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "length"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "length"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "length"})}).map(v -> v.asInt32().getValue()).orElse(null);
    }

    public Flow.Direction getDirection() {
        return Flow.Direction.INGRESS;
    }

    public String getDstAddr() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "dst_ip", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "dst_ip", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "dst_ip", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "dst_ip", "address"})}).map(v -> v.asString().getValue()).orElse(null);
    }

    public Optional<String> getDstAddrHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "dst_ip", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "dst_ip", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "dst_ip", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "dst_ip", "hostname"})}).map(v -> v.asString().getValue());
    }

    public Integer getDstAs() {
        return null;
    }

    public Integer getDstMaskLen() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1002", "dst_mask_len"}).map(v -> (int)v.asInt64().getValue()).orElse(null);
    }

    public Integer getDstPort() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "dst_port"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "dst_port"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "dst_port"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "dst_port"})}).map(v -> v.asInt32().getValue()).orElse(null);
    }

    public Integer getEngineId() {
        return this.header.getSubAgentId();
    }

    public Integer getEngineType() {
        return null;
    }

    public Long getFirstSwitched() {
        return this.header.getTimestamp();
    }

    public Long getLastSwitched() {
        return this.header.getTimestamp();
    }

    public int getFlowRecords() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows"}).map(v -> v.asDocument().size()).orElse(0);
    }

    public long getFlowSeqNum() {
        return this.header.getSequenceNumber();
    }

    public Integer getInputSnmp() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"input"}).map(v -> v.asInt64().getValue() == 0x3FFFFFFFL ? null : Integer.valueOf((int)v.asInt64().getValue())).orElse(null);
    }

    public Integer getOutputSnmp() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"output"}).map(v -> v.asInt64().getValue() == 0x3FFFFFFFL ? null : Integer.valueOf((int)v.asInt64().getValue())).orElse(null);
    }

    public Integer getIpProtocolVersion() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "protocol"}).flatMap(v -> {
            switch (v.asInt32().getValue()) {
                case 11: {
                    return Optional.of(4);
                }
                case 12: {
                    return Optional.of(6);
                }
            }
            return Optional.empty();
        }), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3"}).map(v -> 4), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4"}).map(v -> 6)}).orElse(null);
    }

    public String getNextHop() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1002", "nexthop", "ipv6", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1002", "nexthop", "ipv4", "address"})}).map(v -> v.asString().getValue()).orElse(null);
    }

    public Optional<String> getNextHopHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1002", "nexthop", "ipv6", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1002", "nexthop", "ipv4", "hostname"})}).map(v -> v.asString().getValue());
    }

    public Long getPackets() {
        return 1L;
    }

    public Integer getProtocol() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "protocol"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "protocol"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "protocol"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "protocol"})}).map(v -> v.asInt32().getValue()).orElse(null);
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"sampling_rate"}).map(v -> v.asInt64().getValue()).orElse(null);
    }

    public String getSrcAddr() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "src_ip", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "src_ip", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "src_ip", "address"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "src_ip", "address"})}).map(v -> v.asString().getValue()).orElse(null);
    }

    public Optional<String> getSrcAddrHostname() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "src_ip", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "src_ip", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "src_ip", "hostname"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "src_ip", "hostname"})}).map(v -> v.asString().getValue());
    }

    public Integer getSrcAs() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1003", "src_as"}).map(v -> (int)v.asInt64().getValue()).orElse(null);
    }

    public Integer getSrcMaskLen() {
        return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1002", "src_mask_len"}).map(v -> (int)v.asInt64().getValue()).orElse(null);
    }

    public Integer getSrcPort() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "src_port"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "src_port"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "src_port"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "src_port"})}).map(v -> v.asInt32().getValue()).orElse(null);
    }

    public Integer getTcpFlags() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "tcp_flags"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "tcp_flags"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "tcp_flags"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "tcp_flags"})}).map(v -> v.asInt32().getValue()).orElse(null);
    }

    public Integer getTos() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:3", "tos"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:4", "tos"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv4", "tos"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ipv6", "tos"})}).map(v -> v.asInt32().getValue()).orElse(null);
    }

    public Flow.NetflowVersion getNetflowVersion() {
        return Flow.NetflowVersion.SFLOW;
    }

    public Integer getVlan() {
        return BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1001", "src_vlan"}), BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"flows", "0:1", "ethernet", "vlan"})}).map(v -> (int)v.asInt64().getValue()).orElse(null);
    }

    public static class Header {
        private final BsonDocument document;

        public Header(BsonDocument document) {
            this.document = document;
        }

        public Long getTimestamp() {
            return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"time"}).map(v -> v.asInt64().getValue()).orElse(null);
        }

        public Integer getSubAgentId() {
            return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"sub_agent_id"}).map(v -> (int)v.asInt64().getValue()).orElse(null);
        }

        public Long getSequenceNumber() {
            return BsonUtils.get((BsonDocument)this.document, (String[])new String[]{"sequence_number"}).map(v -> v.asInt64().getValue()).orElse(0L);
        }
    }
}

