/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.flows;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.Objects;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.netmgt.flows.api.Converter;
import org.opennms.netmgt.flows.api.DetailedFlowException;
import org.opennms.netmgt.flows.api.FlowException;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.api.UnrecoverableFlowException;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowAdapter<P>
implements Adapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFlowAdapter.class);
    private final FlowRepository flowRepository;
    private final Converter<P> converter;
    private String metaDataNodeLookup;
    private ContextKey contextKey;
    private final Timer logParsingTimer;
    private final Histogram packetsPerLogHistogram;

    public AbstractFlowAdapter(String name, MetricRegistry metricRegistry, FlowRepository flowRepository, Converter<P> converter) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(metricRegistry);
        this.flowRepository = Objects.requireNonNull(flowRepository);
        this.converter = Objects.requireNonNull(converter);
        this.logParsingTimer = metricRegistry.timer(MetricRegistry.name((String)"adapters", (String[])new String[]{name, "logParsing"}));
        this.packetsPerLogHistogram = metricRegistry.histogram(MetricRegistry.name((String)"adapters", (String[])new String[]{name, "packetsPerLog"}));
    }

    public void setConfig(AdapterDefinition protocol) {
    }

    public void handleMessageLog(TelemetryMessageLog messageLog) {
        LOG.debug("Received {} telemetry messages", (Object)messageLog.getMessageList().size());
        LinkedList<P> flowPackets = new LinkedList<P>();
        LinkedList flows = new LinkedList();
        Timer.Context ctx = this.logParsingTimer.time();
        Object object = null;
        try {
            for (TelemetryMessageLogEntry eachMessage : messageLog.getMessageList()) {
                LOG.trace("Parsing packet: {}", (Object)eachMessage);
                P flowPacket = this.parse(eachMessage);
                if (flowPacket == null) continue;
                flowPackets.add(flowPacket);
                flows.addAll(this.converter.convert(flowPacket));
            }
            this.packetsPerLogHistogram.update(flowPackets.size());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        try {
            LOG.debug("Persisting {} packets, {} flows.", (Object)flowPackets.size(), (Object)flows.size());
            FlowSource source = new FlowSource(messageLog.getLocation(), messageLog.getSourceAddress(), this.contextKey);
            this.flowRepository.persist(flows, source);
        }
        catch (DetailedFlowException ex) {
            LOG.error("Error while persisting flows: {}", (Object)ex.getMessage(), (Object)ex);
            for (String logMessage : ex.getDetailedLogMessages()) {
                LOG.error(logMessage);
            }
        }
        catch (UnrecoverableFlowException ex) {
            LOG.error("Error while persisting flows. Cannot recover: {}. {} messages are lost.", new Object[]{ex.getMessage(), messageLog.getMessageList().size(), ex});
            return;
        }
        catch (FlowException ex) {
            LOG.error("Error while persisting flows: {}", (Object)ex.getMessage(), (Object)ex);
        }
        LOG.debug("Completed processing {} telemetry messages.", (Object)messageLog.getMessageList().size());
    }

    protected abstract P parse(TelemetryMessageLogEntry var1);

    public void destroy() {
    }

    public String getMetaDataNodeLookup() {
        return this.metaDataNodeLookup;
    }

    public void setMetaDataNodeLookup(String metaDataNodeLookup) {
        this.metaDataNodeLookup = metaDataNodeLookup;
        this.contextKey = !Strings.isNullOrEmpty((String)this.metaDataNodeLookup) ? new ContextKey(metaDataNodeLookup) : null;
    }
}

