/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.collection;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.opennms.core.fileutils.FileUpdateCallback;
import org.opennms.core.fileutils.FileUpdateWatcher;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPersistingAdapter
implements Adapter {
    private final Logger LOG = LoggerFactory.getLogger(AbstractPersistingAdapter.class);
    private static final ServiceParameters EMPTY_SERVICE_PARAMETERS = new ServiceParameters(Collections.emptyMap());
    @Autowired
    private FilterDao filterDao;
    @Autowired
    private PersisterFactory persisterFactory;
    @Autowired
    private ThresholdingService thresholdingService;
    private AtomicBoolean isThresholdingEnabled = new AtomicBoolean(true);
    private Integer thresholdingSessionTtlMinutes = SystemProperties.getInteger((String)"org.opennms.netmgt.telemetry.protocols.collection.thresholdingSessionTtlMinutes", (int)1440);
    private Cache<String, ThresholdingSession> agentThresholdingSessions = CacheBuilder.newBuilder().expireAfterAccess((long)this.thresholdingSessionTtlMinutes.intValue(), TimeUnit.MINUTES).build();
    private AdapterDefinition adapterConfig;
    private FileUpdateWatcher scriptUpdateWatcher;
    private BundleContext bundleContext;
    private String script;
    private final ThreadLocal<ScriptedCollectionSetBuilder> scriptedCollectionSetBuilders = new ThreadLocal<ScriptedCollectionSetBuilder>(){

        @Override
        protected ScriptedCollectionSetBuilder initialValue() {
            try {
                return AbstractPersistingAdapter.this.loadCollectionBuilder(AbstractPersistingAdapter.this.bundleContext, AbstractPersistingAdapter.this.script);
            }
            catch (Exception e) {
                AbstractPersistingAdapter.this.LOG.error("Failed to create builder for script '{}'.", (Object)AbstractPersistingAdapter.this.script, (Object)e);
                return null;
            }
        }
    };
    private ThreadLocal<Boolean> scriptCompiled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private Map<ScriptedCollectionSetBuilder, Boolean> scriptUpdateMap = new ConcurrentHashMap<ScriptedCollectionSetBuilder, Boolean>();
    private final LoadingCache<CacheKey, Optional<PackageDefinition>> cache = CacheBuilder.newBuilder().maximumSize(SystemProperties.getLong((String)"org.opennms.features.telemetry.cache.ipAddressFilter.maximumSize", (int)1000).longValue()).expireAfterWrite(SystemProperties.getLong((String)"org.opennms.features.telemetry.cache.ipAddressFilter.expireAfterWrite", (int)120).longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<CacheKey, Optional<PackageDefinition>>(){

        public Optional<PackageDefinition> load(CacheKey key) {
            for (PackageDefinition pkg : AbstractPersistingAdapter.this.adapterConfig.getPackages()) {
                String filterRule = pkg.getFilterRule();
                if (filterRule == null) {
                    return Optional.of(pkg);
                }
                if (!AbstractPersistingAdapter.this.filterDao.isValid(key.getHostAddress(), pkg.getFilterRule())) continue;
                return Optional.of(pkg);
            }
            return Optional.empty();
        }
    });
    private final Timer logParsingTimer;
    private final Histogram packetsPerLogHistogram;

    public AbstractPersistingAdapter(String name, MetricRegistry metricRegistry) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(metricRegistry);
        this.logParsingTimer = metricRegistry.timer(MetricRegistry.name((String)"adapters", (String[])new String[]{name, "logParsing"}));
        this.packetsPerLogHistogram = metricRegistry.histogram(MetricRegistry.name((String)"adapters", (String[])new String[]{name, "packetsPerLog"}));
    }

    public abstract Stream<CollectionSetWithAgent> handleMessage(TelemetryMessageLogEntry var1, TelemetryMessageLog var2);

    public void handleMessageLog(TelemetryMessageLog messageLog) {
        try (Timer.Context ctx = this.logParsingTimer.time();){
            for (TelemetryMessageLogEntry message : messageLog.getMessageList()) {
                this.handleMessage(message, messageLog).forEach(result -> {
                    PackageDefinition pkg = this.getPackageFor(this.adapterConfig, result.getAgent());
                    if (pkg == null) {
                        this.LOG.warn("No matching package found for message: {}. Dropping.", (Object)message);
                        return;
                    }
                    RrdRepository repository = new RrdRepository();
                    repository.setStep(pkg.getRrd().getStep().intValue());
                    repository.setHeartBeat(repository.getStep() * 2);
                    repository.setRraList(pkg.getRrd().getRras());
                    repository.setRrdBaseDir(new File(pkg.getRrd().getBaseDir()));
                    CollectionSet collectionSet = result.getCollectionSet();
                    this.LOG.trace("Persisting collection set: {} for message: {}", (Object)collectionSet, (Object)message);
                    Persister persister = this.persisterFactory.createPersister(EMPTY_SERVICE_PARAMETERS, repository);
                    collectionSet.visit((CollectionSetVisitor)persister);
                    try {
                        if (this.isThresholdingEnabled.get()) {
                            ThresholdingSession session = this.getSessionForAgent(result.getAgent(), repository);
                            session.accept(collectionSet);
                        }
                    }
                    catch (ThresholdInitializationException e) {
                        this.LOG.warn("Failed Thresholding of CollectionSet : {} for agent: {}", (Object)e.getMessage(), (Object)result.getAgent());
                    }
                });
            }
            this.packetsPerLogHistogram.update(messageLog.getMessageList().size());
        }
    }

    private ThresholdingSession getSessionForAgent(CollectionAgent agent, RrdRepository repository) throws ThresholdInitializationException {
        String serviceName;
        String hostAddress;
        if (this.thresholdingService == null) {
            this.isThresholdingEnabled.set(false);
            throw new ThresholdInitializationException("No ThresholdingService available. No future Threshholding will be done");
        }
        int nodeId = agent.getNodeId();
        String sessionKey = this.getSessionKey(nodeId, hostAddress = agent.getHostAddress(), serviceName = this.adapterConfig.getName());
        ThresholdingSession session = (ThresholdingSession)this.agentThresholdingSessions.getIfPresent((Object)sessionKey);
        if (session == null) {
            session = this.thresholdingService.createSession(nodeId, hostAddress, serviceName, repository, EMPTY_SERVICE_PARAMETERS);
            this.agentThresholdingSessions.put((Object)sessionKey, (Object)session);
        }
        return session;
    }

    private String getSessionKey(int nodeId, String hostAddress, String serviceName) {
        return String.valueOf(nodeId) + hostAddress + serviceName;
    }

    public void setConfig(AdapterDefinition adapterConfig) {
        this.adapterConfig = adapterConfig;
    }

    private PackageDefinition getPackageFor(AdapterDefinition protocol, CollectionAgent agent) {
        try {
            Optional value = (Optional)this.cache.get((Object)new CacheKey(protocol.getName(), agent.getHostAddress()));
            return value.orElse(null);
        }
        catch (ExecutionException e) {
            this.LOG.error("Error while retrieving package from Cache: {}.", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public void setPersisterFactory(PersisterFactory persisterFactory) {
        this.persisterFactory = persisterFactory;
    }

    public ThresholdingService getThresholdingService() {
        return this.thresholdingService;
    }

    public void setThresholdingService(ThresholdingService thresholdingService) {
        this.thresholdingService = thresholdingService;
    }

    protected ScriptedCollectionSetBuilder getCollectionBuilder() {
        ScriptedCollectionSetBuilder builder = this.scriptedCollectionSetBuilders.get();
        if (builder != null && this.scriptUpdateMap.get(builder).booleanValue() || !this.scriptCompiled.get().booleanValue()) {
            this.scriptedCollectionSetBuilders.remove();
            builder = this.scriptedCollectionSetBuilders.get();
        }
        if (builder == null) {
            this.scriptCompiled.set(false);
            return null;
        }
        if (!this.scriptCompiled.get().booleanValue()) {
            this.scriptCompiled.set(true);
        }
        return builder;
    }

    private ScriptedCollectionSetBuilder loadCollectionBuilder(BundleContext bundleContext, String script) throws IOException, ScriptException {
        if (bundleContext != null) {
            ScriptedCollectionSetBuilder builder = new ScriptedCollectionSetBuilder(new File(script), bundleContext);
            this.scriptUpdateMap.put(builder, false);
            return builder;
        }
        ScriptedCollectionSetBuilder builder = new ScriptedCollectionSetBuilder(new File(script));
        this.scriptUpdateMap.put(builder, false);
        return builder;
    }

    private ScriptedCollectionSetBuilder checkScript(BundleContext bundleContext, String script) throws IOException, ScriptException {
        if (bundleContext != null) {
            return new ScriptedCollectionSetBuilder(new File(script), bundleContext);
        }
        return new ScriptedCollectionSetBuilder(new File(script));
    }

    private void setFileUpdateCallback(String script) {
        if (!Strings.isNullOrEmpty((String)script)) {
            try {
                this.scriptUpdateWatcher = new FileUpdateWatcher(script, this.reloadScript());
            }
            catch (Exception e) {
                this.LOG.info("Script reload Utils is not registered", (Throwable)e);
            }
        }
    }

    private FileUpdateCallback reloadScript() {
        return new FileUpdateCallback(){

            public void reload() {
                try {
                    AbstractPersistingAdapter.this.checkScript(AbstractPersistingAdapter.this.bundleContext, AbstractPersistingAdapter.this.script);
                    AbstractPersistingAdapter.this.LOG.debug("Updated script compiled");
                    AbstractPersistingAdapter.this.scriptUpdateMap.replaceAll((builder, Boolean2) -> true);
                }
                catch (Exception e) {
                    AbstractPersistingAdapter.this.LOG.error("Updated script failed to build, using existing script'{}'.", (Object)AbstractPersistingAdapter.this.script, (Object)e);
                }
            }
        };
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
        this.setFileUpdateCallback(script);
    }

    public void destroy() {
        if (this.scriptUpdateWatcher != null) {
            this.scriptUpdateWatcher.destroy();
        }
    }

    private static class CacheKey {
        private String protocol;
        private String hostAddress;

        public CacheKey(String protocol, String hostAddress) {
            this.protocol = Objects.requireNonNull(protocol);
            this.hostAddress = Objects.requireNonNull(hostAddress);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public int hashCode() {
            return Objects.hash(this.hostAddress, this.protocol);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            boolean equals = Objects.equals(this.hostAddress, cacheKey.hostAddress) && Objects.equals(this.protocol, cacheKey.protocol);
            return equals;
        }
    }
}

