/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.nxos.adapter;

import com.google.common.collect.Iterables;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractPersistingAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.opennms.netmgt.telemetry.protocols.nxos.adapter.proto.TelemetryBis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class NxosGpbAdapter
extends AbstractPersistingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NxosGpbAdapter.class);
    private static final ExtensionRegistry s_registry = ExtensionRegistry.newInstance();
    @Autowired
    private CollectionAgentFactory collectionAgentFactory;
    @Autowired
    private InterfaceToNodeCache interfaceToNodeCache;
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private TransactionOperations transactionTemplate;

    public Stream<CollectionSetWithAgent> handleMessage(TelemetryMessageLogEntry message, final TelemetryMessageLog messageLog) {
        TelemetryBis.Telemetry msg;
        try {
            msg = this.tryParsingTelemetryMessage(message.getByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Invalid packet: {}", (Throwable)e);
            return Stream.empty();
        }
        CollectionAgent agent = null;
        try {
            LOG.debug(" Telemetry message content : {} ", (Object)msg);
            InetAddress inetAddress = InetAddress.getByName(msg.getNodeIdStr());
            Optional nodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), inetAddress);
            if (nodeId.isPresent()) {
                agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString((Integer)nodeId.get()), inetAddress);
            }
        }
        catch (UnknownHostException e) {
            LOG.debug("Could not convert system id to address: {}", (Object)msg.getNodeIdStr());
        }
        if (agent == null) {
            agent = (CollectionAgent)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<CollectionAgent>(){

                public CollectionAgent doInTransaction(TransactionStatus status) {
                    OnmsNode node = (OnmsNode)Iterables.getFirst((Iterable)NxosGpbAdapter.this.nodeDao.findByLabelForLocation(msg.getNodeIdStr(), messageLog.getLocation()), null);
                    if (node == null) {
                        node = (OnmsNode)Iterables.getFirst((Iterable)NxosGpbAdapter.this.nodeDao.findByForeignIdForLocation(msg.getNodeIdStr(), messageLog.getLocation()), null);
                    }
                    if (node != null) {
                        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
                        return NxosGpbAdapter.this.collectionAgentFactory.createCollectionAgent(primaryInterface);
                    }
                    return null;
                }
            });
        }
        if (agent == null) {
            LOG.warn("Unable to find node and interface for system id: {}", (Object)msg.getNodeIdStr());
            return Stream.empty();
        }
        ScriptedCollectionSetBuilder builder = this.getCollectionBuilder();
        if (builder == null) {
            LOG.error("Error compiling script '{}'. See logs for details.", (Object)this.getScript());
            return Stream.empty();
        }
        try {
            CollectionSet collectionSet = builder.build(agent, (Object)msg);
            return Stream.of(new CollectionSetWithAgent(agent, collectionSet));
        }
        catch (ScriptException e) {
            LOG.warn("Error while running script: {}: {}", (Object)this.getScript(), (Object)e);
            return Stream.empty();
        }
    }

    private TelemetryBis.Telemetry tryParsingTelemetryMessage(byte[] bs) throws InvalidProtocolBufferException {
        try {
            return TelemetryBis.Telemetry.parseFrom(bs, (ExtensionRegistryLite)s_registry);
        }
        catch (InvalidProtocolBufferException e) {
            ByteBuffer buf = ByteBuffer.wrap(bs, 6, bs.length - 6);
            return TelemetryBis.Telemetry.parseFrom(buf, (ExtensionRegistryLite)s_registry);
        }
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public void setTransactionTemplate(TransactionOperations transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    static {
        TelemetryBis.registerAllExtensions(s_registry);
    }
}

