/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;

public final class FlowSetHeader {
    public static final int TEMPLATE_SET_ID = 0;
    public static final int OPTIONS_TEMPLATE_SET_ID = 1;
    public static final int SIZE = 4;
    public final int setId;
    public final int length;

    public FlowSetHeader(ByteBuf buffer) throws InvalidPacketException {
        this.setId = BufferUtils.uint16((ByteBuf)buffer);
        if (this.setId < 256 && this.setId != 0 && this.setId != 1) {
            throw new InvalidPacketException(buffer, "Invalid set ID: %d", this.setId);
        }
        this.length = BufferUtils.uint16((ByteBuf)buffer);
    }

    public Type getType() {
        if (this.setId == 0) {
            return Type.TEMPLATE_FLOWSET;
        }
        if (this.setId == 1) {
            return Type.OPTIONS_TEMPLATE_FLOWSET;
        }
        if (this.setId >= 256) {
            return Type.DATA_FLOWSET;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowSetId", this.setId).add("length", this.length).toString();
    }

    public static enum Type {
        TEMPLATE_FLOWSET,
        OPTIONS_TEMPLATE_FLOWSET,
        DATA_FLOWSET;

    }
}

