/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import java.net.InetAddress;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.Timeout;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.Direction;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.NetflowVersion;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.SamplingAlgorithm;

public class Netflow9MessageBuilder {
    private final FlowMessage.Builder builder;
    private final Iterable<Value<?>> values;
    private final RecordEnrichment enrichment;
    private InetAddress ipv4DstAddress;
    private InetAddress ipv6DstAddress;
    private Long dstMask;
    private Long ipv6DstMask;
    private InetAddress ipv4NextHop;
    private InetAddress ipv6NextHop;
    private InetAddress bgpIpv4NextHop;
    private InetAddress bgpIpv6NextHop;
    private InetAddress ipv4SrcAddress;
    private InetAddress ipv6SrcAddress;
    private Long srcMask;
    private Long ipv6SrcMask;
    private Long srcVlan;
    private Long dstVlan;
    private Long flowActiveTimeout;
    private Long flowInActiveTimeout;
    private Long sysUpTime;
    private Long unixSecs;
    private Long numBytes;
    private Long numPackets;
    private Long firstSwitched;
    private Long lastSwitched;

    public Netflow9MessageBuilder(Iterable<Value<?>> values, RecordEnrichment enrichment) {
        this.values = values;
        this.enrichment = enrichment;
        this.builder = FlowMessage.newBuilder();
    }

    public byte[] buildData() {
        this.values.forEach(this::addField);
        long timeStampInMsecs = this.unixSecs != null ? this.unixSecs * 1000L : 0L;
        this.builder.setTimestamp(timeStampInMsecs);
        long bootTime = timeStampInMsecs - this.sysUpTime;
        if (this.firstSwitched != null) {
            this.builder.setFirstSwitched(MessageUtils.setLongValue(this.firstSwitched + bootTime));
        }
        if (this.lastSwitched != null) {
            this.builder.setLastSwitched(MessageUtils.setLongValue(this.lastSwitched + bootTime));
        }
        MessageUtils.first(this.ipv6DstAddress, this.ipv4DstAddress).ifPresent(inetAddress -> {
            this.enrichment.getHostnameFor((InetAddress)inetAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstHostname(arg_0));
            this.builder.setDstAddress(inetAddress.getHostAddress());
        });
        MessageUtils.first(this.ipv6DstMask, this.dstMask).ifPresent(dstMaskLen -> this.builder.setDstMaskLen(MessageUtils.setIntValue(dstMaskLen.intValue())));
        MessageUtils.first(this.ipv6SrcAddress, this.ipv4SrcAddress).ifPresent(inetAddress -> {
            this.enrichment.getHostnameFor((InetAddress)inetAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcHostname(arg_0));
            this.builder.setSrcAddress(inetAddress.getHostAddress());
        });
        MessageUtils.first(this.ipv6SrcMask, this.srcMask).ifPresent(srcMaskLen -> this.builder.setSrcMaskLen(MessageUtils.setIntValue(srcMaskLen.intValue())));
        MessageUtils.first(this.ipv6NextHop, this.ipv4NextHop, this.bgpIpv6NextHop, this.bgpIpv4NextHop).ifPresent(inetAddress -> {
            this.enrichment.getHostnameFor((InetAddress)inetAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNextHopHostname(arg_0));
            this.builder.setNextHopAddress(inetAddress.getHostAddress());
        });
        MessageUtils.first(this.srcVlan, this.dstVlan).ifPresent(vlan -> this.builder.setVlan(MessageUtils.setIntValue(vlan.intValue())));
        Long firstSwitched = this.builder.hasFirstSwitched() ? Long.valueOf(this.builder.getFirstSwitched().getValue()) : null;
        Long lastSwitched = this.builder.hasLastSwitched() ? Long.valueOf(this.builder.getLastSwitched().getValue()) : null;
        Timeout timeout = new Timeout(this.flowActiveTimeout, this.flowInActiveTimeout);
        timeout.setFirstSwitched(firstSwitched);
        timeout.setLastSwitched(lastSwitched);
        timeout.setNumBytes(this.numBytes);
        timeout.setNumPackets(this.numPackets);
        Long deltaSwitched = timeout.getDeltaSwitched();
        MessageUtils.getUInt64Value(deltaSwitched).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDeltaSwitched(arg_0));
        this.builder.setNetflowVersion(NetflowVersion.V9);
        return this.builder.build().toByteArray();
    }

    private void addField(Value<?> value) {
        switch (value.getName()) {
            case "@recordCount": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNumFlowRecords(arg_0));
                break;
            }
            case "@sequenceNumber": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setFlowSeqNum(arg_0));
                break;
            }
            case "@sourceId": {
                MessageUtils.getUInt64Value(value).ifPresent(srcId -> this.builder.setNodeIdentifier(String.valueOf(srcId.getValue())));
                break;
            }
            case "@sysUpTime": {
                this.sysUpTime = MessageUtils.getLongValue(value);
                break;
            }
            case "@unixSecs": {
                this.unixSecs = MessageUtils.getLongValue(value);
                break;
            }
            case "IN_BYTES": {
                MessageUtils.getUInt64Value(value).ifPresent(bytes -> {
                    this.numBytes = bytes.getValue();
                    this.builder.setNumBytes(bytes);
                });
                break;
            }
            case "DIRECTION": {
                Long directionValue = MessageUtils.getLongValue(value);
                Direction direction = Direction.UNRECOGNIZED;
                if (directionValue != null) {
                    switch (directionValue.intValue()) {
                        case 0: {
                            direction = Direction.INGRESS;
                            break;
                        }
                        case 1: {
                            direction = Direction.EGRESS;
                        }
                    }
                }
                if (direction.equals((Object)Direction.UNRECOGNIZED)) break;
                this.builder.setDirection(direction);
                break;
            }
            case "IPV4_DST_ADDR": {
                this.ipv4DstAddress = MessageUtils.getInetAddress(value);
                break;
            }
            case "IPV6_DST_ADDR": {
                this.ipv6DstAddress = MessageUtils.getInetAddress(value);
                break;
            }
            case "DST_AS": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstAs(arg_0));
                break;
            }
            case "IPV6_DST_MASK": {
                this.ipv6DstMask = MessageUtils.getLongValue(value);
                break;
            }
            case "DST_MASK": {
                this.dstMask = MessageUtils.getLongValue(value);
                break;
            }
            case "L4_DST_PORT": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstPort(arg_0));
                break;
            }
            case "ENGINE_ID": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setEngineId(arg_0));
                break;
            }
            case "ENGINE_TYPE": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setEngineType(arg_0));
                break;
            }
            case "FIRST_SWITCHED": {
                this.firstSwitched = MessageUtils.getLongValue(value);
                break;
            }
            case "LAST_SWITCHED": {
                this.lastSwitched = MessageUtils.getLongValue(value);
                break;
            }
            case "INPUT_SNMP": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setInputSnmpIfindex(arg_0));
                break;
            }
            case "IP_PROTOCOL_VERSION": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setIpProtocolVersion(arg_0));
                break;
            }
            case "OUTPUT_SNMP": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setOutputSnmpIfindex(arg_0));
                break;
            }
            case "IPV6_NEXT_HOP": {
                this.ipv6NextHop = MessageUtils.getInetAddress(value);
                break;
            }
            case "IPV4_NEXT_HOP": {
                this.ipv4NextHop = MessageUtils.getInetAddress(value);
                break;
            }
            case "BPG_IPV6_NEXT_HOP": {
                this.bgpIpv6NextHop = MessageUtils.getInetAddress(value);
                break;
            }
            case "BPG_IPV4_NEXT_HOP": {
                this.bgpIpv4NextHop = MessageUtils.getInetAddress(value);
                break;
            }
            case "IN_PKTS": {
                MessageUtils.getUInt64Value(value).ifPresent(numPackets -> {
                    this.numPackets = numPackets.getValue();
                    this.builder.setNumPackets(numPackets);
                });
                break;
            }
            case "PROTOCOL": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setProtocol(arg_0));
                break;
            }
            case "SAMPLING_ALGORITHM": {
                Long saValue = MessageUtils.getLongValue(value);
                SamplingAlgorithm samplingAlgorithm = SamplingAlgorithm.UNASSIGNED;
                if (saValue != null) {
                    if (saValue.intValue() == 1) {
                        samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
                    }
                    if (saValue.intValue() == 2) {
                        samplingAlgorithm = SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
                    }
                }
                this.builder.setSamplingAlgorithm(samplingAlgorithm);
                break;
            }
            case "SAMPLING_INTERVAL": {
                MessageUtils.getDoubleValue(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSamplingInterval(arg_0));
                break;
            }
            case "IPV6_SRC_ADDR": {
                this.ipv6SrcAddress = MessageUtils.getInetAddress(value);
                break;
            }
            case "IPV4_SRC_ADDR": {
                this.ipv4SrcAddress = MessageUtils.getInetAddress(value);
                break;
            }
            case "IPV6_SRC_MASK": {
                this.ipv6SrcMask = MessageUtils.getLongValue(value);
                break;
            }
            case "SRC_MASK": {
                this.srcMask = MessageUtils.getLongValue(value);
                break;
            }
            case "SRC_AS": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcAs(arg_0));
                break;
            }
            case "L4_SRC_PORT": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcPort(arg_0));
                break;
            }
            case "TCP_FLAGS": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setTcpFlags(arg_0));
                break;
            }
            case "TOS": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setTos(arg_0));
                break;
            }
            case "SRC_VLAN": {
                this.srcVlan = MessageUtils.getLongValue(value);
                break;
            }
            case "DST_VLAN": {
                this.dstVlan = MessageUtils.getLongValue(value);
                break;
            }
            case "FLOW_ACTIVE_TIMEOUT": {
                this.flowActiveTimeout = MessageUtils.getLongValue(value);
                break;
            }
            case "FLOW_INACTIVE_TIMEOUT": {
                this.flowInActiveTimeout = MessageUtils.getLongValue(value);
            }
        }
    }
}

