/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto.Record;

public final class Packet
implements Iterable<Record>,
RecordProvider {
    public final Header header;
    public final List<Record> records;

    public Packet(Header header, ByteBuf buffer) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        LinkedList<Record> records = new LinkedList<Record>();
        while (buffer.isReadable(48) && records.size() < this.header.count) {
            Record record = new Record(this, BufferUtils.slice((ByteBuf)buffer, (int)48));
            records.add(record);
        }
        if (records.size() != this.header.count) {
            throw new InvalidPacketException(buffer, "Incomplete packet", new Object[0]);
        }
        this.records = records;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.records.iterator();
    }

    @Override
    public Stream<Iterable<Value<?>>> getRecords() {
        Iterable<Value<?>> header = this.header.asValues();
        return this.records.stream().map(Record::asValues).map(record -> Iterables.concat((Iterable)header, (Iterable)record));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("records", this.records).toString();
    }
}

