/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.DataRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public class DataSet
extends FlowSet<DataRecord> {
    private final Session.Resolver resolver;
    public final Template template;
    public final List<DataRecord> records;

    public DataSet(Packet packet, FlowSetHeader header, Session.Resolver resolver, ByteBuffer buffer) throws InvalidPacketException, MissingTemplateException {
        super(packet, header);
        this.resolver = Objects.requireNonNull(resolver);
        this.template = this.resolver.lookupTemplate(this.header.setId);
        int minimumRecordLength = this.template.stream().mapToInt(f -> f.length() != 65535 ? f.length() : 1).sum();
        LinkedList<DataRecord> records = new LinkedList<DataRecord>();
        while (buffer.remaining() >= minimumRecordLength) {
            records.add(new DataRecord(this, this.resolver, this.template, buffer));
        }
        if (records.size() == 0) {
            throw new InvalidPacketException(buffer, "Empty set", new Object[0]);
        }
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.records.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("records", this.records).toString();
    }
}

