/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.Dispatchable;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.UdpParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.UdpSessionManager;

public class IpfixUdpParser
extends UdpParserBase
implements UdpParser,
Dispatchable {
    public IpfixUdpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        super(Protocol.IPFIX, name, dispatcher, eventForwarder, identity, dnsResolver, metricRegistry);
    }

    @Override
    protected RecordProvider parse(Session session, ByteBuf buffer) throws Exception {
        Header header = new Header(BufferUtils.slice((ByteBuf)buffer, (int)16));
        Packet packet = new Packet(session, header, BufferUtils.slice((ByteBuf)buffer, (int)header.payloadLength()));
        this.detectClockSkew(header.exportTime * 1000L, session.getRemoteAddress());
        return packet;
    }

    public boolean handles(ByteBuf buffer) {
        return BufferUtils.uint16((ByteBuf)buffer) == 10;
    }

    @Override
    protected UdpSessionManager.SessionKey buildSessionKey(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        return new SessionKey(remoteAddress, localAddress);
    }

    public static class SessionKey
    implements UdpSessionManager.SessionKey {
        private final InetSocketAddress remoteAddress;
        private final InetSocketAddress localAddress;

        public SessionKey(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionKey that = (SessionKey)o;
            return Objects.equal((Object)this.localAddress, (Object)that.localAddress) && Objects.equal((Object)this.remoteAddress, (Object)that.remoteAddress);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.localAddress, this.remoteAddress});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("remoteAddress", (Object)this.remoteAddress).add("localAddress", (Object)this.localAddress).toString();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.remoteAddress.getAddress();
        }
    }
}

