/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public class UndeclaredValue
extends Value<byte[]> {
    public final byte[] value;

    public UndeclaredValue(Optional<Long> enterpriseNumber, int informationElementId, byte[] value) {
        super(UndeclaredValue.nameFor(enterpriseNumber, informationElementId), Optional.empty());
        this.value = Objects.requireNonNull(value);
    }

    public UndeclaredValue(int informationElementId, byte[] value) {
        this(Optional.empty(), informationElementId, value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("data", (Object)this.value).toString();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }

    public static InformationElement parser(int informationElementId) {
        return UndeclaredValue.parser(Optional.empty(), informationElementId);
    }

    public static InformationElement parser(final Optional<Long> enterpriseNumber, final int informationElementId) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) {
                return new UndeclaredValue(enterpriseNumber, informationElementId, BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()));
            }

            @Override
            public String getName() {
                return UndeclaredValue.nameFor(enterpriseNumber, informationElementId);
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    public static String nameFor(Optional<Long> enterpriseNumber, int informationElementId) {
        return enterpriseNumber.map(en -> Long.toString(en) + ':').orElse("") + Integer.toString(informationElementId);
    }
}

