/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public class IPv6AddressValue
extends Value<Inet6Address> {
    public final Inet6Address value;

    public IPv6AddressValue(String name, Optional<Semantics> semantics, Inet6Address value) {
        super(name, semantics);
        this.value = Objects.requireNonNull(value);
    }

    public IPv6AddressValue(String name, Inet6Address value) {
        this(name, Optional.empty(), value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("inet6Address", (Object)this.value).toString();
    }

    public static InformationElement parser(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException {
                try {
                    return new IPv6AddressValue(name, semantics, (Inet6Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)16)));
                }
                catch (UnknownHostException e) {
                    throw new InvalidPacketException(buffer, "Error parsing IPv6 value", e);
                }
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 16;
            }

            @Override
            public int getMaximumFieldLength() {
                return 16;
            }
        };
    }

    @Override
    public Inet6Address getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

