/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.TcpParser;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.TcpSession;

public class IpfixTcpParser
extends ParserBase
implements TcpParser {
    public IpfixTcpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        super(Protocol.IPFIX, name, dispatcher, eventForwarder, identity, dnsResolver, metricRegistry);
    }

    public TcpParser.Handler accept(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        TcpSession session = new TcpSession(remoteAddress.getAddress());
        return buffer -> {
            buffer.markReaderIndex();
            if (!buffer.isReadable(16)) {
                buffer.resetReaderIndex();
                return Optional.empty();
            }
            Header header = new Header(BufferUtils.slice((ByteBuf)buffer, (int)16));
            if (!buffer.isReadable(header.payloadLength())) {
                buffer.resetReaderIndex();
                return Optional.empty();
            }
            Packet packet = new Packet(session, header, BufferUtils.slice((ByteBuf)buffer, (int)header.payloadLength()));
            this.detectClockSkew(header.exportTime * 1000L, session.getRemoteAddress());
            return Optional.of(this.transmit(packet, remoteAddress));
        };
    }
}

