/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie;

import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.BooleanValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.DateTimeValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.FloatValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv4AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv6AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.ListValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.MacAddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.NullValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.OctetArrayValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.SignedValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.StringValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UndeclaredValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;

public abstract class Value<T> {
    private final String name;
    private final Optional<Semantics> semantics;

    protected Value(String name, Optional<Semantics> semantics) {
        this.name = Objects.requireNonNull(name);
        this.semantics = Objects.requireNonNull(semantics);
    }

    public String getName() {
        return this.name;
    }

    public Optional<Semantics> getSemantics() {
        return this.semantics;
    }

    public abstract T getValue();

    public abstract void visit(Visitor var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value value = (Value)o;
        return Objects.equals(this.name, value.name) && Objects.equals(this.getValue(), value.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getValue());
    }

    public static interface Visitor {
        public void accept(NullValue var1);

        public void accept(BooleanValue var1);

        public void accept(DateTimeValue var1);

        public void accept(FloatValue var1);

        public void accept(IPv4AddressValue var1);

        public void accept(IPv6AddressValue var1);

        public void accept(MacAddressValue var1);

        public void accept(OctetArrayValue var1);

        public void accept(SignedValue var1);

        public void accept(StringValue var1);

        public void accept(UnsignedValue var1);

        public void accept(ListValue var1);

        public void accept(UndeclaredValue var1);
    }
}

