/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.UdpSessionManager;

public abstract class UdpParserBase
extends ParserBase
implements UdpParser {
    public static final long HOUSEKEEPING_INTERVAL = 60000L;
    private UdpSessionManager sessionManager;
    private ScheduledFuture<?> housekeepingFuture;
    private Duration templateTimeout = Duration.ofMinutes(30L);

    public UdpParserBase(Protocol protocol, String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        super(protocol, name, dispatcher, eventForwarder, identity, dnsResolver, metricRegistry);
    }

    protected abstract RecordProvider parse(Session var1, ByteBuf var2) throws Exception;

    protected abstract UdpSessionManager.SessionKey buildSessionKey(InetSocketAddress var1, InetSocketAddress var2);

    public final CompletableFuture<?> parse(ByteBuf buffer, InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
        UdpSessionManager.SessionKey sessionKey = this.buildSessionKey(remoteAddress, localAddress);
        Session session = this.sessionManager.getSession(sessionKey);
        try {
            return this.transmit(this.parse(session, buffer), remoteAddress);
        }
        catch (Exception e) {
            this.sessionManager.drop(sessionKey);
            throw e;
        }
    }

    @Override
    public void start(ScheduledExecutorService executorService) {
        super.start(executorService);
        this.sessionManager = new UdpSessionManager(this.templateTimeout);
        this.housekeepingFuture = executorService.scheduleAtFixedRate(this.sessionManager::doHousekeeping, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.housekeepingFuture.cancel(false);
        super.stop();
    }

    public Duration getTemplateTimeout() {
        return this.templateTimeout;
    }

    public void setTemplateTimeout(Duration templateTimeout) {
        this.templateTimeout = templateTimeout;
    }
}

