/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.MetricRegistry;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.TcpParser;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.TcpSession;

public class IpfixTcpParser
extends ParserBase
implements TcpParser {
    public IpfixTcpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        super(Protocol.IPFIX, name, dispatcher, eventForwarder, identity, dnsResolver, metricRegistry);
    }

    public TcpParser.Handler accept(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        TcpSession session = new TcpSession(remoteAddress.getAddress());
        return buffer -> {
            Header header = new Header(BufferUtils.slice((ByteBuffer)buffer, (int)20));
            Packet packet = new Packet(session, header, buffer);
            this.detectClockSkew(header.unixSecs * 1000L, session.getRemoteAddress());
            return this.transmit(packet, remoteAddress);
        };
    }
}

