/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.factory;

import java.util.Objects;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.api.receiver.ParserFactory;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.ParserDefinition;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Netflow5UdpParser;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class Netflow5UdpParserFactory
implements ParserFactory {
    private final TelemetryRegistry telemetryRegistry;
    private final EventForwarder eventForwarder;
    private final Identity identity;

    public Netflow5UdpParserFactory(TelemetryRegistry telemetryRegistry, EventForwarder eventForwarder, Identity identity) {
        this.telemetryRegistry = Objects.requireNonNull(telemetryRegistry);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.identity = Objects.requireNonNull(identity);
    }

    public Class<? extends Parser> getBeanClass() {
        return Netflow5UdpParser.class;
    }

    public Parser createBean(ParserDefinition parserDefinition) {
        AsyncDispatcher dispatcher = this.telemetryRegistry.getDispatcher(parserDefinition.getQueueName());
        Netflow5UdpParser parser = new Netflow5UdpParser(parserDefinition.getName(), (AsyncDispatcher<TelemetryMessage>)dispatcher, this.eventForwarder, this.identity);
        if (!parserDefinition.getParameterMap().isEmpty()) {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)parser);
            wrapper.setPropertyValues(parserDefinition.getParameterMap());
        }
        return parser;
    }
}

