/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bson.BsonBinary;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.common.utils.DnsUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.BooleanValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.DateTimeValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.FloatValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv4AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv6AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.ListValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.MacAddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.NullValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.OctetArrayValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.SignedValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.StringValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UndeclaredValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserBase {
    private static final Logger LOG = LoggerFactory.getLogger(ParserBase.class);
    private final Protocol protocol;
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;

    public ParserBase(Protocol protocol, String name, AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.protocol = Objects.requireNonNull(protocol);
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    public String getName() {
        return this.name;
    }

    protected CompletableFuture<?> transmit(RecordProvider packet, InetSocketAddress remoteAddress) throws Exception {
        LOG.trace("Got packet: {}", (Object)packet);
        return CompletableFuture.allOf((CompletableFuture[])packet.getRecords().map(record -> {
            ByteBuffer buffer = ParserBase.serialize(this.protocol, record);
            TelemetryMessage msg = new TelemetryMessage(remoteAddress, buffer);
            return this.dispatcher.send((Message)msg);
        }).toArray(CompletableFuture[]::new));
    }

    public static ByteBuffer serialize(Protocol protocol, Iterable<Value<?>> record) {
        BasicOutputBuffer output = new BasicOutputBuffer();
        try (BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)output);){
            writer.writeStartDocument();
            writer.writeInt32("@version", protocol.version);
            FlowBuilderVisitor visitor = new FlowBuilderVisitor((BsonWriter)writer);
            for (Value<?> value : record) {
                value.visit(visitor);
            }
            writer.writeEndDocument();
        }
        return ((ByteBuf)output.getByteBuffers().get(0)).asNIO();
    }

    private static class FlowBuilderVisitor
    implements Value.Visitor {
        private final BsonWriter writer;

        public FlowBuilderVisitor(BsonWriter writer) {
            this.writer = writer;
        }

        @Override
        public void accept(NullValue value) {
            this.writer.writeNull(value.getName());
        }

        @Override
        public void accept(BooleanValue value) {
            this.writer.writeBoolean(value.getName(), value.getValue().booleanValue());
        }

        @Override
        public void accept(DateTimeValue value) {
            this.writer.writeStartDocument(value.getName());
            this.writer.writeInt64("epoch", value.getValue().getEpochSecond());
            if (value.getValue().getNano() != 0) {
                this.writer.writeInt64("nanos", (long)value.getValue().getNano());
            }
            this.writer.writeEndDocument();
        }

        @Override
        public void accept(FloatValue value) {
            this.writer.writeDouble(value.getName(), value.getValue().doubleValue());
        }

        @Override
        public void accept(IPv4AddressValue value) {
            this.writer.writeStartDocument(value.getName());
            this.writer.writeString("address", value.getValue().getHostAddress());
            DnsUtils.reverseLookup((InetAddress)value.getValue()).ifPresent(hostname -> this.writer.writeString("hostname", hostname));
            this.writer.writeEndDocument();
        }

        @Override
        public void accept(IPv6AddressValue value) {
            this.writer.writeStartDocument(value.getName());
            this.writer.writeString("address", value.getValue().getHostAddress());
            DnsUtils.reverseLookup((InetAddress)value.getValue()).ifPresent(hostname -> this.writer.writeString("hostname", hostname));
            this.writer.writeEndDocument();
        }

        @Override
        public void accept(MacAddressValue value) {
            this.writer.writeStartDocument(value.getName());
            value.getSemantics().ifPresent(semantics -> this.writer.writeInt32("s", semantics.ordinal()));
            this.writer.writeBinaryData("v", new BsonBinary(value.getValue()));
            this.writer.writeEndDocument();
        }

        @Override
        public void accept(OctetArrayValue value) {
            this.writer.writeBinaryData(value.getName(), new BsonBinary(value.getValue()));
        }

        @Override
        public void accept(SignedValue value) {
            this.writer.writeInt64(value.getName(), value.getValue().longValue());
        }

        @Override
        public void accept(StringValue value) {
            this.writer.writeString(value.getName(), value.getValue());
        }

        @Override
        public void accept(ListValue value) {
            this.writer.writeStartDocument(value.getName());
            this.writer.writeInt32("semantic", value.getSemantic().ordinal());
            this.writer.writeStartArray("values");
            for (int i = 0; i < value.getValue().size(); ++i) {
                this.writer.writeStartDocument();
                for (int j = 0; j < ((List)value.getValue().get(i)).size(); ++j) {
                    ((Value)((List)value.getValue().get(i)).get(j)).visit(this);
                }
                this.writer.writeEndDocument();
            }
            this.writer.writeEndArray();
            this.writer.writeEndDocument();
        }

        @Override
        public void accept(UnsignedValue value) {
            this.writer.writeInt64(value.getName(), value.getValue().longValue());
        }

        @Override
        public void accept(UndeclaredValue value) {
            this.writer.writeBinaryData(value.getName(), new BsonBinary(value.getValue()));
        }
    }
}

