/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.session;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Scope;

public final class Template
implements Iterable<Field> {
    public final int id;
    public final Type type;
    public final List<Scope> scopes;
    public final List<Field> fields;

    private Template(int id, Type type, List<Scope> scopes, List<Field> fields) {
        this.id = id;
        this.type = Objects.requireNonNull(type);
        this.scopes = Objects.requireNonNull(scopes);
        this.fields = Objects.requireNonNull(fields);
    }

    public int count() {
        return this.scopes.size() + this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    public Stream<Field> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static Builder builder(int id, Type type) {
        return new Builder(id, type);
    }

    public static class Builder {
        private final int id;
        private final Type type;
        private List<Scope> scopes = new LinkedList<Scope>();
        private List<Field> fields = new LinkedList<Field>();

        private Builder(int id, Type type) {
            this.id = id;
            this.type = Objects.requireNonNull(type);
        }

        public Builder withScopes(List<? extends Scope> scopes) {
            assert (this.type == Type.OPTIONS_TEMPLATE);
            this.scopes.addAll(scopes);
            return this;
        }

        public Builder withFields(List<? extends Field> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Template build() {
            Preconditions.checkNotNull(this.scopes);
            Preconditions.checkNotNull(this.fields);
            return new Template(this.id, this.type, this.scopes, this.fields);
        }
    }

    public static enum Type {
        TEMPLATE,
        OPTIONS_TEMPLATE;

    }
}

