/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Scope;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public class UdpSessionManager {
    private final Map<Key, TemplateWrapper> templates = Maps.newHashMap();
    private final Map<Key, Map<Set<Value<?>>, List<Value<?>>>> options = Maps.newHashMap();
    private final Duration timeout;

    public UdpSessionManager(Duration timeout) {
        this.timeout = timeout;
    }

    public void doHousekeeping() {
        Instant timeout = Instant.now().minus(this.timeout);
        this.templates.entrySet().removeIf(e -> ((TemplateWrapper)e.getValue()).insertionTime.isBefore(timeout));
    }

    public Session getSession(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        return new UdpSession(remoteAddress, localAddress);
    }

    public void drop(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        this.templates.entrySet().removeIf(e -> Objects.equals(((Key)e.getKey()).remoteAddress, remoteAddress) && Objects.equals(((Key)e.getKey()).localAddress, localAddress));
    }

    private static final class TemplateWrapper {
        public final Instant insertionTime = Instant.now();
        public final Template template;

        private TemplateWrapper(Template template) {
            this.template = template;
        }
    }

    private static final class Key {
        public final InetSocketAddress remoteAddress;
        public final InetSocketAddress localAddress;
        public final long observationDomainId;
        public final int templateId;

        Key(InetSocketAddress remoteAddress, InetSocketAddress localAddress, long observationDomainId, int templateId) {
            this.remoteAddress = Objects.requireNonNull(remoteAddress);
            this.localAddress = Objects.requireNonNull(localAddress);
            this.observationDomainId = observationDomainId;
            this.templateId = templateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return this.observationDomainId == that.observationDomainId && this.templateId == that.templateId && Objects.equals(this.remoteAddress, that.remoteAddress) && Objects.equals(this.localAddress, that.localAddress);
        }

        public int hashCode() {
            return Objects.hash(this.remoteAddress, this.localAddress, this.observationDomainId, this.templateId);
        }
    }

    private final class UdpSession
    implements Session {
        private final InetSocketAddress remoteAddress;
        private final InetSocketAddress localAddress;

        public UdpSession(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
        }

        @Override
        public void addTemplate(long observationDomainId, Template template) {
            Key key = new Key(this.remoteAddress, this.localAddress, observationDomainId, template.id);
            UdpSessionManager.this.templates.put(key, new TemplateWrapper(template));
        }

        @Override
        public void removeTemplate(long observationDomainId, int templateId) {
            Key key = new Key(this.remoteAddress, this.localAddress, observationDomainId, templateId);
            UdpSessionManager.this.templates.remove(key);
        }

        @Override
        public void removeAllTemplate(long observationDomainId, Template.Type type) {
            UdpSessionManager.this.templates.entrySet().removeIf(e -> ((Key)e.getKey()).observationDomainId == observationDomainId && ((TemplateWrapper)e.getValue()).template.type == type);
        }

        @Override
        public void addOptions(long observationDomainId, int templateId, Collection<Value<?>> scopes, List<Value<?>> values) {
            if (scopes.isEmpty()) {
                return;
            }
            Key key = new Key(this.remoteAddress, this.localAddress, observationDomainId, templateId);
            UdpSessionManager.this.options.computeIfAbsent(key, k -> new HashMap()).put(new HashSet(scopes), values);
        }

        @Override
        public Session.Resolver getResolver(long observationDomainId) {
            return new Resolver(observationDomainId);
        }

        private final class Resolver
        implements Session.Resolver {
            private final long observationDomainId;

            private Resolver(long observationDomainId) {
                this.observationDomainId = observationDomainId;
            }

            private Key key(int templateId) {
                return new Key(UdpSession.this.remoteAddress, UdpSession.this.localAddress, this.observationDomainId, templateId);
            }

            @Override
            public Template lookupTemplate(int templateId) throws MissingTemplateException {
                TemplateWrapper templateWrapper = (TemplateWrapper)UdpSessionManager.this.templates.get(this.key(templateId));
                if (templateWrapper != null) {
                    return templateWrapper.template;
                }
                throw new MissingTemplateException(templateId);
            }

            @Override
            public List<Value<?>> lookupOptions(List<Value<?>> values) {
                LinkedHashMap<String, Value> options = new LinkedHashMap<String, Value>();
                Set scoped = values.stream().map(Value::getName).collect(Collectors.toSet());
                for (Map.Entry e2 : Iterables.filter(UdpSessionManager.this.options.entrySet(), e -> Objects.equals(((Key)e.getKey()).localAddress, UdpSession.this.localAddress) && Objects.equals(((Key)e.getKey()).remoteAddress, UdpSession.this.remoteAddress) && Objects.equals(((Key)e.getKey()).observationDomainId, this.observationDomainId))) {
                    Template template = ((TemplateWrapper)((UdpSessionManager)UdpSessionManager.this).templates.get(e2.getKey())).template;
                    Set scopes = template.scopes.stream().map(Scope::getName).collect(Collectors.toSet());
                    if (!scoped.containsAll(scopes)) continue;
                    Set scopeValues = values.stream().filter(s -> scopes.contains(s.getName())).collect(Collectors.toSet());
                    for (Value value : ((Map)e2.getValue()).getOrDefault(scopeValues, Collections.emptyList())) {
                        options.put(value.getName(), value);
                    }
                }
                return new ArrayList(options.values());
            }
        }
    }
}

