/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.UdpSessionManager;

public abstract class UdpParserBase
extends ParserBase {
    public static final long HOUSEKEEPING_INTERVAL = 60000L;
    private UdpSessionManager sessionManager;
    private ScheduledFuture<?> housekeepingFuture;
    private Duration templateTimeout = Duration.ofMinutes(30L);

    public UdpParserBase(Protocol protocol, String name, AsyncDispatcher<TelemetryMessage> dispatcher) {
        super(protocol, name, dispatcher);
    }

    protected abstract RecordProvider parse(Session var1, ByteBuffer var2) throws Exception;

    public final CompletableFuture<?> parse(ByteBuffer buffer, InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
        Session session = this.sessionManager.getSession(remoteAddress, localAddress);
        try {
            return this.transmit(this.parse(session, buffer), remoteAddress);
        }
        catch (Exception e) {
            this.sessionManager.drop(remoteAddress, localAddress);
            throw e;
        }
    }

    public void start(ScheduledExecutorService executorService) {
        this.sessionManager = new UdpSessionManager(this.templateTimeout);
        this.housekeepingFuture = executorService.scheduleAtFixedRate(this.sessionManager::doHousekeeping, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.housekeepingFuture.cancel(false);
    }

    public Duration getTemplateTimeout() {
        return this.templateTimeout;
    }

    public void setTemplateTimeout(Duration templateTimeout) {
        this.templateTimeout = templateTimeout;
    }
}

