/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.DataRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FieldSpecifier;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public class ListValue
extends Value<List<List<Value<?>>>> {
    private final Semantic semantic;
    private final List<List<Value<?>>> values;

    public ListValue(String name, Optional<Semantics> semantics, Semantic semantic, List<List<Value<?>>> values) {
        super(name, semantics);
        this.semantic = semantic;
        this.values = values;
    }

    public static InformationElement parserWithBasicList(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) throws InvalidPacketException {
                Semantic semantic = Semantic.parse(buffer, BufferUtils.uint8((ByteBuffer)buffer));
                FieldSpecifier field = new FieldSpecifier(buffer);
                LinkedList values = new LinkedList();
                while (buffer.hasRemaining()) {
                    values.add(Collections.singletonList(DataRecord.parseField(field, resolver, buffer)));
                }
                return new ListValue(name, semantics, semantic, values);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 5;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    public static InformationElement parserWithSubTemplateList(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) throws InvalidPacketException {
                Semantic semantic = Semantic.parse(buffer, BufferUtils.uint8((ByteBuffer)buffer));
                int templateId = BufferUtils.uint16((ByteBuffer)buffer);
                Template template = resolver.lookupTemplate(templateId).orElseThrow(() -> new InvalidPacketException(buffer, "Unknown Template ID: %d", templateId));
                LinkedList values = new LinkedList();
                while (buffer.hasRemaining()) {
                    ArrayList record = new ArrayList(template.count());
                    for (Field field : template) {
                        record.add(DataRecord.parseField(field, resolver, buffer));
                    }
                    values.add(record);
                }
                return new ListValue(name, semantics, semantic, values);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 3;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    public static InformationElement parserWithSubTemplateMultiList(final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(Session.Resolver resolver, ByteBuffer buffer) throws InvalidPacketException {
                Semantic semantic = Semantic.parse(buffer, BufferUtils.uint8((ByteBuffer)buffer));
                LinkedList values = new LinkedList();
                while (buffer.hasRemaining()) {
                    FlowSetHeader header = new FlowSetHeader(buffer);
                    if (header.setId <= 255) {
                        throw new InvalidPacketException(buffer, "Invalid template ID: %d", header.setId);
                    }
                    ByteBuffer payloadBuffer = BufferUtils.slice((ByteBuffer)buffer, (int)(header.length - 4));
                    Template template = resolver.lookupTemplate(header.setId).orElseThrow(() -> new InvalidPacketException(buffer, "Unknown Template ID: %d", header.setId));
                    while (payloadBuffer.hasRemaining()) {
                        ArrayList record = new ArrayList(template.count());
                        for (Field field : template) {
                            record.add(DataRecord.parseField(field, resolver, payloadBuffer));
                        }
                        values.add(record);
                    }
                }
                return new ListValue(name, semantics, semantic, values);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    @Override
    public List<List<Value<?>>> getValue() {
        return this.values;
    }

    public Semantic getSemantic() {
        return this.semantic;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }

    public static enum Semantic {
        UNDEFINED,
        NONE_OF,
        EXACTLY_ONE_OF,
        ONE_OR_MORE_OF,
        ALL_OF,
        ORDERED;


        public static Semantic parse(ByteBuffer buffer, int i) throws InvalidPacketException {
            switch (i) {
                case 255: {
                    return UNDEFINED;
                }
                case 0: {
                    return NONE_OF;
                }
                case 1: {
                    return EXACTLY_ONE_OF;
                }
                case 2: {
                    return ONE_OR_MORE_OF;
                }
                case 3: {
                    return ALL_OF;
                }
                case 4: {
                    return ORDERED;
                }
            }
            throw new InvalidPacketException(buffer, "Illegal semantic value: 0x%02x", i);
        }
    }
}

