/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.protocols.jti.adapter.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: cpu_memory_utilization.proto

public final class CpuMemoryUtilizationOuterClass {
  private CpuMemoryUtilizationOuterClass() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(CpuMemoryUtilizationOuterClass.cpuMemoryUtilExt);
  }
  public interface CpuMemoryUtilizationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CpuMemoryUtilization)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary> 
        getUtilizationList();
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary getUtilization(int index);
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    int getUtilizationCount();
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    java.util.List<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder> 
        getUtilizationOrBuilderList();
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder getUtilizationOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code CpuMemoryUtilization}
   *
   * <pre>
   * The top level message is CpuMemoryUtilization
   * </pre>
   */
  public static final class CpuMemoryUtilization extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CpuMemoryUtilization)
      CpuMemoryUtilizationOrBuilder {
    // Use CpuMemoryUtilization.newBuilder() to construct.
    private CpuMemoryUtilization(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CpuMemoryUtilization(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CpuMemoryUtilization defaultInstance;
    public static CpuMemoryUtilization getDefaultInstance() {
      return defaultInstance;
    }

    public CpuMemoryUtilization getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CpuMemoryUtilization(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                utilization_ = new java.util.ArrayList<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary>();
                mutable_bitField0_ |= 0x00000001;
              }
              utilization_.add(input.readMessage(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          utilization_ = java.util.Collections.unmodifiableList(utilization_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilization_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilization_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.class, CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.Builder.class);
    }

    public static com.google.protobuf.Parser<CpuMemoryUtilization> PARSER =
        new com.google.protobuf.AbstractParser<CpuMemoryUtilization>() {
      public CpuMemoryUtilization parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CpuMemoryUtilization(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CpuMemoryUtilization> getParserForType() {
      return PARSER;
    }

    public static final int UTILIZATION_FIELD_NUMBER = 1;
    private java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary> utilization_;
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    public java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary> getUtilizationList() {
      return utilization_;
    }
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    public java.util.List<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder> 
        getUtilizationOrBuilderList() {
      return utilization_;
    }
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    public int getUtilizationCount() {
      return utilization_.size();
    }
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary getUtilization(int index) {
      return utilization_.get(index);
    }
    /**
     * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
     */
    public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder getUtilizationOrBuilder(
        int index) {
      return utilization_.get(index);
    }

    private void initFields() {
      utilization_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < utilization_.size(); i++) {
        output.writeMessage(1, utilization_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < utilization_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, utilization_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(CpuMemoryUtilizationOuterClass.CpuMemoryUtilization prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CpuMemoryUtilization}
     *
     * <pre>
     * The top level message is CpuMemoryUtilization
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CpuMemoryUtilization)
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilization_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilization_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.class, CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.Builder.class);
      }

      // Construct using CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getUtilizationFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (utilizationBuilder_ == null) {
          utilization_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          utilizationBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilization_descriptor;
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilization getDefaultInstanceForType() {
        return CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.getDefaultInstance();
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilization build() {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilization result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilization buildPartial() {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilization result = new CpuMemoryUtilizationOuterClass.CpuMemoryUtilization(this);
        int from_bitField0_ = bitField0_;
        if (utilizationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            utilization_ = java.util.Collections.unmodifiableList(utilization_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.utilization_ = utilization_;
        } else {
          result.utilization_ = utilizationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof CpuMemoryUtilizationOuterClass.CpuMemoryUtilization) {
          return mergeFrom((CpuMemoryUtilizationOuterClass.CpuMemoryUtilization)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(CpuMemoryUtilizationOuterClass.CpuMemoryUtilization other) {
        if (other == CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.getDefaultInstance()) return this;
        if (utilizationBuilder_ == null) {
          if (!other.utilization_.isEmpty()) {
            if (utilization_.isEmpty()) {
              utilization_ = other.utilization_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureUtilizationIsMutable();
              utilization_.addAll(other.utilization_);
            }
            onChanged();
          }
        } else {
          if (!other.utilization_.isEmpty()) {
            if (utilizationBuilder_.isEmpty()) {
              utilizationBuilder_.dispose();
              utilizationBuilder_ = null;
              utilization_ = other.utilization_;
              bitField0_ = (bitField0_ & ~0x00000001);
              utilizationBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getUtilizationFieldBuilder() : null;
            } else {
              utilizationBuilder_.addAllMessages(other.utilization_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilization parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (CpuMemoryUtilizationOuterClass.CpuMemoryUtilization) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary> utilization_ =
        java.util.Collections.emptyList();
      private void ensureUtilizationIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          utilization_ = new java.util.ArrayList<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary>(utilization_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder> utilizationBuilder_;

      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary> getUtilizationList() {
        if (utilizationBuilder_ == null) {
          return java.util.Collections.unmodifiableList(utilization_);
        } else {
          return utilizationBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public int getUtilizationCount() {
        if (utilizationBuilder_ == null) {
          return utilization_.size();
        } else {
          return utilizationBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary getUtilization(int index) {
        if (utilizationBuilder_ == null) {
          return utilization_.get(index);
        } else {
          return utilizationBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder setUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary value) {
        if (utilizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUtilizationIsMutable();
          utilization_.set(index, value);
          onChanged();
        } else {
          utilizationBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder setUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder builderForValue) {
        if (utilizationBuilder_ == null) {
          ensureUtilizationIsMutable();
          utilization_.set(index, builderForValue.build());
          onChanged();
        } else {
          utilizationBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder addUtilization(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary value) {
        if (utilizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUtilizationIsMutable();
          utilization_.add(value);
          onChanged();
        } else {
          utilizationBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder addUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary value) {
        if (utilizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUtilizationIsMutable();
          utilization_.add(index, value);
          onChanged();
        } else {
          utilizationBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder addUtilization(
          CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder builderForValue) {
        if (utilizationBuilder_ == null) {
          ensureUtilizationIsMutable();
          utilization_.add(builderForValue.build());
          onChanged();
        } else {
          utilizationBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder addUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder builderForValue) {
        if (utilizationBuilder_ == null) {
          ensureUtilizationIsMutable();
          utilization_.add(index, builderForValue.build());
          onChanged();
        } else {
          utilizationBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder addAllUtilization(
          java.lang.Iterable<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary> values) {
        if (utilizationBuilder_ == null) {
          ensureUtilizationIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, utilization_);
          onChanged();
        } else {
          utilizationBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder clearUtilization() {
        if (utilizationBuilder_ == null) {
          utilization_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          utilizationBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public Builder removeUtilization(int index) {
        if (utilizationBuilder_ == null) {
          ensureUtilizationIsMutable();
          utilization_.remove(index);
          onChanged();
        } else {
          utilizationBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder getUtilizationBuilder(
          int index) {
        return getUtilizationFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder getUtilizationOrBuilder(
          int index) {
        if (utilizationBuilder_ == null) {
          return utilization_.get(index);  } else {
          return utilizationBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public java.util.List<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder> 
           getUtilizationOrBuilderList() {
        if (utilizationBuilder_ != null) {
          return utilizationBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(utilization_);
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder addUtilizationBuilder() {
        return getUtilizationFieldBuilder().addBuilder(
            CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.getDefaultInstance());
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder addUtilizationBuilder(
          int index) {
        return getUtilizationFieldBuilder().addBuilder(
            index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.getDefaultInstance());
      }
      /**
       * <code>repeated .CpuMemoryUtilizationSummary utilization = 1;</code>
       */
      public java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder> 
           getUtilizationBuilderList() {
        return getUtilizationFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder> 
          getUtilizationFieldBuilder() {
        if (utilizationBuilder_ == null) {
          utilizationBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder>(
                  utilization_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          utilization_ = null;
        }
        return utilizationBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:CpuMemoryUtilization)
    }

    static {
      defaultInstance = new CpuMemoryUtilization(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:CpuMemoryUtilization)
  }

  public interface CpuMemoryUtilizationSummaryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CpuMemoryUtilizationSummary)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Name of the partition.
     * </pre>
     */
    boolean hasName();
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Name of the partition.
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Name of the partition.
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional uint64 size = 2;</code>
     *
     * <pre>
     * The total size of the partition in bytes
     * </pre>
     */
    boolean hasSize();
    /**
     * <code>optional uint64 size = 2;</code>
     *
     * <pre>
     * The total size of the partition in bytes
     * </pre>
     */
    long getSize();

    /**
     * <code>optional uint64 bytes_allocated = 3;</code>
     *
     * <pre>
     * The amount of memory currently allocated from the partition in bytes
     * </pre>
     */
    boolean hasBytesAllocated();
    /**
     * <code>optional uint64 bytes_allocated = 3;</code>
     *
     * <pre>
     * The amount of memory currently allocated from the partition in bytes
     * </pre>
     */
    long getBytesAllocated();

    /**
     * <code>optional int32 utilization = 4;</code>
     *
     * <pre>
     * The amount of memory that is currently allocated, expressed
     * as percentage of the total (0--100).
     * </pre>
     */
    boolean hasUtilization();
    /**
     * <code>optional int32 utilization = 4;</code>
     *
     * <pre>
     * The amount of memory that is currently allocated, expressed
     * as percentage of the total (0--100).
     * </pre>
     */
    int getUtilization();

    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication> 
        getApplicationUtilizationList();
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication getApplicationUtilization(int index);
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    int getApplicationUtilizationCount();
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    java.util.List<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder> 
        getApplicationUtilizationOrBuilderList();
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder getApplicationUtilizationOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code CpuMemoryUtilizationSummary}
   *
   * <pre>
   * This array gives the CPU  memory utilization on per partition basis
   * and also the per application memory utilization for each partition
   * </pre>
   */
  public static final class CpuMemoryUtilizationSummary extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CpuMemoryUtilizationSummary)
      CpuMemoryUtilizationSummaryOrBuilder {
    // Use CpuMemoryUtilizationSummary.newBuilder() to construct.
    private CpuMemoryUtilizationSummary(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CpuMemoryUtilizationSummary(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CpuMemoryUtilizationSummary defaultInstance;
    public static CpuMemoryUtilizationSummary getDefaultInstance() {
      return defaultInstance;
    }

    public CpuMemoryUtilizationSummary getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CpuMemoryUtilizationSummary(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              size_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              bytesAllocated_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              utilization_ = input.readInt32();
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                applicationUtilization_ = new java.util.ArrayList<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication>();
                mutable_bitField0_ |= 0x00000010;
              }
              applicationUtilization_.add(input.readMessage(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          applicationUtilization_ = java.util.Collections.unmodifiableList(applicationUtilization_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationSummary_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.class, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder.class);
    }

    public static com.google.protobuf.Parser<CpuMemoryUtilizationSummary> PARSER =
        new com.google.protobuf.AbstractParser<CpuMemoryUtilizationSummary>() {
      public CpuMemoryUtilizationSummary parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CpuMemoryUtilizationSummary(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CpuMemoryUtilizationSummary> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Name of the partition.
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Name of the partition.
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Name of the partition.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIZE_FIELD_NUMBER = 2;
    private long size_;
    /**
     * <code>optional uint64 size = 2;</code>
     *
     * <pre>
     * The total size of the partition in bytes
     * </pre>
     */
    public boolean hasSize() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 size = 2;</code>
     *
     * <pre>
     * The total size of the partition in bytes
     * </pre>
     */
    public long getSize() {
      return size_;
    }

    public static final int BYTES_ALLOCATED_FIELD_NUMBER = 3;
    private long bytesAllocated_;
    /**
     * <code>optional uint64 bytes_allocated = 3;</code>
     *
     * <pre>
     * The amount of memory currently allocated from the partition in bytes
     * </pre>
     */
    public boolean hasBytesAllocated() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 bytes_allocated = 3;</code>
     *
     * <pre>
     * The amount of memory currently allocated from the partition in bytes
     * </pre>
     */
    public long getBytesAllocated() {
      return bytesAllocated_;
    }

    public static final int UTILIZATION_FIELD_NUMBER = 4;
    private int utilization_;
    /**
     * <code>optional int32 utilization = 4;</code>
     *
     * <pre>
     * The amount of memory that is currently allocated, expressed
     * as percentage of the total (0--100).
     * </pre>
     */
    public boolean hasUtilization() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional int32 utilization = 4;</code>
     *
     * <pre>
     * The amount of memory that is currently allocated, expressed
     * as percentage of the total (0--100).
     * </pre>
     */
    public int getUtilization() {
      return utilization_;
    }

    public static final int APPLICATION_UTILIZATION_FIELD_NUMBER = 5;
    private java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication> applicationUtilization_;
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    public java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication> getApplicationUtilizationList() {
      return applicationUtilization_;
    }
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    public java.util.List<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder> 
        getApplicationUtilizationOrBuilderList() {
      return applicationUtilization_;
    }
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    public int getApplicationUtilizationCount() {
      return applicationUtilization_.size();
    }
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication getApplicationUtilization(int index) {
      return applicationUtilization_.get(index);
    }
    /**
     * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
     *
     * <pre>
     * Per application based memory utilization for this memory partition
     * </pre>
     */
    public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder getApplicationUtilizationOrBuilder(
        int index) {
      return applicationUtilization_.get(index);
    }

    private void initFields() {
      name_ = "";
      size_ = 0L;
      bytesAllocated_ = 0L;
      utilization_ = 0;
      applicationUtilization_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, size_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, bytesAllocated_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(4, utilization_);
      }
      for (int i = 0; i < applicationUtilization_.size(); i++) {
        output.writeMessage(5, applicationUtilization_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, size_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, bytesAllocated_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(4, utilization_);
      }
      for (int i = 0; i < applicationUtilization_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, applicationUtilization_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CpuMemoryUtilizationSummary}
     *
     * <pre>
     * This array gives the CPU  memory utilization on per partition basis
     * and also the per application memory utilization for each partition
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CpuMemoryUtilizationSummary)
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummaryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationSummary_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationSummary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.class, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.Builder.class);
      }

      // Construct using CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getApplicationUtilizationFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        size_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        bytesAllocated_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        utilization_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        if (applicationUtilizationBuilder_ == null) {
          applicationUtilization_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          applicationUtilizationBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationSummary_descriptor;
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary getDefaultInstanceForType() {
        return CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.getDefaultInstance();
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary build() {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary buildPartial() {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary result = new CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.size_ = size_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.bytesAllocated_ = bytesAllocated_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.utilization_ = utilization_;
        if (applicationUtilizationBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            applicationUtilization_ = java.util.Collections.unmodifiableList(applicationUtilization_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.applicationUtilization_ = applicationUtilization_;
        } else {
          result.applicationUtilization_ = applicationUtilizationBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary) {
          return mergeFrom((CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary other) {
        if (other == CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasSize()) {
          setSize(other.getSize());
        }
        if (other.hasBytesAllocated()) {
          setBytesAllocated(other.getBytesAllocated());
        }
        if (other.hasUtilization()) {
          setUtilization(other.getUtilization());
        }
        if (applicationUtilizationBuilder_ == null) {
          if (!other.applicationUtilization_.isEmpty()) {
            if (applicationUtilization_.isEmpty()) {
              applicationUtilization_ = other.applicationUtilization_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureApplicationUtilizationIsMutable();
              applicationUtilization_.addAll(other.applicationUtilization_);
            }
            onChanged();
          }
        } else {
          if (!other.applicationUtilization_.isEmpty()) {
            if (applicationUtilizationBuilder_.isEmpty()) {
              applicationUtilizationBuilder_.dispose();
              applicationUtilizationBuilder_ = null;
              applicationUtilization_ = other.applicationUtilization_;
              bitField0_ = (bitField0_ & ~0x00000010);
              applicationUtilizationBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getApplicationUtilizationFieldBuilder() : null;
            } else {
              applicationUtilizationBuilder_.addAllMessages(other.applicationUtilization_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationSummary) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Name of the partition.
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Name of the partition.
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Name of the partition.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Name of the partition.
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Name of the partition.
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Name of the partition.
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private long size_ ;
      /**
       * <code>optional uint64 size = 2;</code>
       *
       * <pre>
       * The total size of the partition in bytes
       * </pre>
       */
      public boolean hasSize() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 size = 2;</code>
       *
       * <pre>
       * The total size of the partition in bytes
       * </pre>
       */
      public long getSize() {
        return size_;
      }
      /**
       * <code>optional uint64 size = 2;</code>
       *
       * <pre>
       * The total size of the partition in bytes
       * </pre>
       */
      public Builder setSize(long value) {
        bitField0_ |= 0x00000002;
        size_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 size = 2;</code>
       *
       * <pre>
       * The total size of the partition in bytes
       * </pre>
       */
      public Builder clearSize() {
        bitField0_ = (bitField0_ & ~0x00000002);
        size_ = 0L;
        onChanged();
        return this;
      }

      private long bytesAllocated_ ;
      /**
       * <code>optional uint64 bytes_allocated = 3;</code>
       *
       * <pre>
       * The amount of memory currently allocated from the partition in bytes
       * </pre>
       */
      public boolean hasBytesAllocated() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 bytes_allocated = 3;</code>
       *
       * <pre>
       * The amount of memory currently allocated from the partition in bytes
       * </pre>
       */
      public long getBytesAllocated() {
        return bytesAllocated_;
      }
      /**
       * <code>optional uint64 bytes_allocated = 3;</code>
       *
       * <pre>
       * The amount of memory currently allocated from the partition in bytes
       * </pre>
       */
      public Builder setBytesAllocated(long value) {
        bitField0_ |= 0x00000004;
        bytesAllocated_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 bytes_allocated = 3;</code>
       *
       * <pre>
       * The amount of memory currently allocated from the partition in bytes
       * </pre>
       */
      public Builder clearBytesAllocated() {
        bitField0_ = (bitField0_ & ~0x00000004);
        bytesAllocated_ = 0L;
        onChanged();
        return this;
      }

      private int utilization_ ;
      /**
       * <code>optional int32 utilization = 4;</code>
       *
       * <pre>
       * The amount of memory that is currently allocated, expressed
       * as percentage of the total (0--100).
       * </pre>
       */
      public boolean hasUtilization() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional int32 utilization = 4;</code>
       *
       * <pre>
       * The amount of memory that is currently allocated, expressed
       * as percentage of the total (0--100).
       * </pre>
       */
      public int getUtilization() {
        return utilization_;
      }
      /**
       * <code>optional int32 utilization = 4;</code>
       *
       * <pre>
       * The amount of memory that is currently allocated, expressed
       * as percentage of the total (0--100).
       * </pre>
       */
      public Builder setUtilization(int value) {
        bitField0_ |= 0x00000008;
        utilization_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 utilization = 4;</code>
       *
       * <pre>
       * The amount of memory that is currently allocated, expressed
       * as percentage of the total (0--100).
       * </pre>
       */
      public Builder clearUtilization() {
        bitField0_ = (bitField0_ & ~0x00000008);
        utilization_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication> applicationUtilization_ =
        java.util.Collections.emptyList();
      private void ensureApplicationUtilizationIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          applicationUtilization_ = new java.util.ArrayList<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication>(applicationUtilization_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder> applicationUtilizationBuilder_;

      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication> getApplicationUtilizationList() {
        if (applicationUtilizationBuilder_ == null) {
          return java.util.Collections.unmodifiableList(applicationUtilization_);
        } else {
          return applicationUtilizationBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public int getApplicationUtilizationCount() {
        if (applicationUtilizationBuilder_ == null) {
          return applicationUtilization_.size();
        } else {
          return applicationUtilizationBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication getApplicationUtilization(int index) {
        if (applicationUtilizationBuilder_ == null) {
          return applicationUtilization_.get(index);
        } else {
          return applicationUtilizationBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder setApplicationUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication value) {
        if (applicationUtilizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.set(index, value);
          onChanged();
        } else {
          applicationUtilizationBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder setApplicationUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder builderForValue) {
        if (applicationUtilizationBuilder_ == null) {
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.set(index, builderForValue.build());
          onChanged();
        } else {
          applicationUtilizationBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder addApplicationUtilization(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication value) {
        if (applicationUtilizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.add(value);
          onChanged();
        } else {
          applicationUtilizationBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder addApplicationUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication value) {
        if (applicationUtilizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.add(index, value);
          onChanged();
        } else {
          applicationUtilizationBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder addApplicationUtilization(
          CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder builderForValue) {
        if (applicationUtilizationBuilder_ == null) {
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.add(builderForValue.build());
          onChanged();
        } else {
          applicationUtilizationBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder addApplicationUtilization(
          int index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder builderForValue) {
        if (applicationUtilizationBuilder_ == null) {
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.add(index, builderForValue.build());
          onChanged();
        } else {
          applicationUtilizationBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder addAllApplicationUtilization(
          java.lang.Iterable<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication> values) {
        if (applicationUtilizationBuilder_ == null) {
          ensureApplicationUtilizationIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, applicationUtilization_);
          onChanged();
        } else {
          applicationUtilizationBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder clearApplicationUtilization() {
        if (applicationUtilizationBuilder_ == null) {
          applicationUtilization_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          applicationUtilizationBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public Builder removeApplicationUtilization(int index) {
        if (applicationUtilizationBuilder_ == null) {
          ensureApplicationUtilizationIsMutable();
          applicationUtilization_.remove(index);
          onChanged();
        } else {
          applicationUtilizationBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder getApplicationUtilizationBuilder(
          int index) {
        return getApplicationUtilizationFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder getApplicationUtilizationOrBuilder(
          int index) {
        if (applicationUtilizationBuilder_ == null) {
          return applicationUtilization_.get(index);  } else {
          return applicationUtilizationBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public java.util.List<? extends CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder> 
           getApplicationUtilizationOrBuilderList() {
        if (applicationUtilizationBuilder_ != null) {
          return applicationUtilizationBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(applicationUtilization_);
        }
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder addApplicationUtilizationBuilder() {
        return getApplicationUtilizationFieldBuilder().addBuilder(
            CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.getDefaultInstance());
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder addApplicationUtilizationBuilder(
          int index) {
        return getApplicationUtilizationFieldBuilder().addBuilder(
            index, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.getDefaultInstance());
      }
      /**
       * <code>repeated .CpuMemoryUtilizationPerApplication application_utilization = 5;</code>
       *
       * <pre>
       * Per application based memory utilization for this memory partition
       * </pre>
       */
      public java.util.List<CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder> 
           getApplicationUtilizationBuilderList() {
        return getApplicationUtilizationFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder> 
          getApplicationUtilizationFieldBuilder() {
        if (applicationUtilizationBuilder_ == null) {
          applicationUtilizationBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder>(
                  applicationUtilization_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          applicationUtilization_ = null;
        }
        return applicationUtilizationBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:CpuMemoryUtilizationSummary)
    }

    static {
      defaultInstance = new CpuMemoryUtilizationSummary(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:CpuMemoryUtilizationSummary)
  }

  public interface CpuMemoryUtilizationPerApplicationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CpuMemoryUtilizationPerApplication)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Application name
     * </pre>
     */
    boolean hasName();
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Application name
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Application name
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional uint64 bytes_allocated = 2;</code>
     *
     * <pre>
     * Number of bytes allocated
     * </pre>
     */
    boolean hasBytesAllocated();
    /**
     * <code>optional uint64 bytes_allocated = 2;</code>
     *
     * <pre>
     * Number of bytes allocated
     * </pre>
     */
    long getBytesAllocated();

    /**
     * <code>optional uint64 allocations = 3;</code>
     *
     * <pre>
     *  Number of allocations
     * </pre>
     */
    boolean hasAllocations();
    /**
     * <code>optional uint64 allocations = 3;</code>
     *
     * <pre>
     *  Number of allocations
     * </pre>
     */
    long getAllocations();

    /**
     * <code>optional uint64 frees = 4;</code>
     *
     * <pre>
     *  Number of frees
     * </pre>
     */
    boolean hasFrees();
    /**
     * <code>optional uint64 frees = 4;</code>
     *
     * <pre>
     *  Number of frees
     * </pre>
     */
    long getFrees();

    /**
     * <code>optional uint64 allocations_failed = 5;</code>
     *
     * <pre>
     * Number of allocations failed
     * </pre>
     */
    boolean hasAllocationsFailed();
    /**
     * <code>optional uint64 allocations_failed = 5;</code>
     *
     * <pre>
     * Number of allocations failed
     * </pre>
     */
    long getAllocationsFailed();
  }
  /**
   * Protobuf type {@code CpuMemoryUtilizationPerApplication}
   *
   * <pre>
   * This describes per Application specific CPU memory utilization
   * </pre>
   */
  public static final class CpuMemoryUtilizationPerApplication extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CpuMemoryUtilizationPerApplication)
      CpuMemoryUtilizationPerApplicationOrBuilder {
    // Use CpuMemoryUtilizationPerApplication.newBuilder() to construct.
    private CpuMemoryUtilizationPerApplication(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CpuMemoryUtilizationPerApplication(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CpuMemoryUtilizationPerApplication defaultInstance;
    public static CpuMemoryUtilizationPerApplication getDefaultInstance() {
      return defaultInstance;
    }

    public CpuMemoryUtilizationPerApplication getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CpuMemoryUtilizationPerApplication(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              bytesAllocated_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              allocations_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              frees_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              allocationsFailed_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationPerApplication_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationPerApplication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.class, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder.class);
    }

    public static com.google.protobuf.Parser<CpuMemoryUtilizationPerApplication> PARSER =
        new com.google.protobuf.AbstractParser<CpuMemoryUtilizationPerApplication>() {
      public CpuMemoryUtilizationPerApplication parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CpuMemoryUtilizationPerApplication(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CpuMemoryUtilizationPerApplication> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Application name
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Application name
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string name = 1;</code>
     *
     * <pre>
     * Application name
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BYTES_ALLOCATED_FIELD_NUMBER = 2;
    private long bytesAllocated_;
    /**
     * <code>optional uint64 bytes_allocated = 2;</code>
     *
     * <pre>
     * Number of bytes allocated
     * </pre>
     */
    public boolean hasBytesAllocated() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 bytes_allocated = 2;</code>
     *
     * <pre>
     * Number of bytes allocated
     * </pre>
     */
    public long getBytesAllocated() {
      return bytesAllocated_;
    }

    public static final int ALLOCATIONS_FIELD_NUMBER = 3;
    private long allocations_;
    /**
     * <code>optional uint64 allocations = 3;</code>
     *
     * <pre>
     *  Number of allocations
     * </pre>
     */
    public boolean hasAllocations() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 allocations = 3;</code>
     *
     * <pre>
     *  Number of allocations
     * </pre>
     */
    public long getAllocations() {
      return allocations_;
    }

    public static final int FREES_FIELD_NUMBER = 4;
    private long frees_;
    /**
     * <code>optional uint64 frees = 4;</code>
     *
     * <pre>
     *  Number of frees
     * </pre>
     */
    public boolean hasFrees() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 frees = 4;</code>
     *
     * <pre>
     *  Number of frees
     * </pre>
     */
    public long getFrees() {
      return frees_;
    }

    public static final int ALLOCATIONS_FAILED_FIELD_NUMBER = 5;
    private long allocationsFailed_;
    /**
     * <code>optional uint64 allocations_failed = 5;</code>
     *
     * <pre>
     * Number of allocations failed
     * </pre>
     */
    public boolean hasAllocationsFailed() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint64 allocations_failed = 5;</code>
     *
     * <pre>
     * Number of allocations failed
     * </pre>
     */
    public long getAllocationsFailed() {
      return allocationsFailed_;
    }

    private void initFields() {
      name_ = "";
      bytesAllocated_ = 0L;
      allocations_ = 0L;
      frees_ = 0L;
      allocationsFailed_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, bytesAllocated_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, allocations_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, frees_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(5, allocationsFailed_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, bytesAllocated_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, allocations_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, frees_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, allocationsFailed_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CpuMemoryUtilizationPerApplication}
     *
     * <pre>
     * This describes per Application specific CPU memory utilization
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CpuMemoryUtilizationPerApplication)
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplicationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationPerApplication_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationPerApplication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.class, CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.Builder.class);
      }

      // Construct using CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        bytesAllocated_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        allocations_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        frees_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        allocationsFailed_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return CpuMemoryUtilizationOuterClass.internal_static_CpuMemoryUtilizationPerApplication_descriptor;
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication getDefaultInstanceForType() {
        return CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.getDefaultInstance();
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication build() {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication buildPartial() {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication result = new CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.bytesAllocated_ = bytesAllocated_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.allocations_ = allocations_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.frees_ = frees_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.allocationsFailed_ = allocationsFailed_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication) {
          return mergeFrom((CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication other) {
        if (other == CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasBytesAllocated()) {
          setBytesAllocated(other.getBytesAllocated());
        }
        if (other.hasAllocations()) {
          setAllocations(other.getAllocations());
        }
        if (other.hasFrees()) {
          setFrees(other.getFrees());
        }
        if (other.hasAllocationsFailed()) {
          setAllocationsFailed(other.getAllocationsFailed());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (CpuMemoryUtilizationOuterClass.CpuMemoryUtilizationPerApplication) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Application name
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Application name
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Application name
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Application name
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Application name
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       *
       * <pre>
       * Application name
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private long bytesAllocated_ ;
      /**
       * <code>optional uint64 bytes_allocated = 2;</code>
       *
       * <pre>
       * Number of bytes allocated
       * </pre>
       */
      public boolean hasBytesAllocated() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 bytes_allocated = 2;</code>
       *
       * <pre>
       * Number of bytes allocated
       * </pre>
       */
      public long getBytesAllocated() {
        return bytesAllocated_;
      }
      /**
       * <code>optional uint64 bytes_allocated = 2;</code>
       *
       * <pre>
       * Number of bytes allocated
       * </pre>
       */
      public Builder setBytesAllocated(long value) {
        bitField0_ |= 0x00000002;
        bytesAllocated_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 bytes_allocated = 2;</code>
       *
       * <pre>
       * Number of bytes allocated
       * </pre>
       */
      public Builder clearBytesAllocated() {
        bitField0_ = (bitField0_ & ~0x00000002);
        bytesAllocated_ = 0L;
        onChanged();
        return this;
      }

      private long allocations_ ;
      /**
       * <code>optional uint64 allocations = 3;</code>
       *
       * <pre>
       *  Number of allocations
       * </pre>
       */
      public boolean hasAllocations() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 allocations = 3;</code>
       *
       * <pre>
       *  Number of allocations
       * </pre>
       */
      public long getAllocations() {
        return allocations_;
      }
      /**
       * <code>optional uint64 allocations = 3;</code>
       *
       * <pre>
       *  Number of allocations
       * </pre>
       */
      public Builder setAllocations(long value) {
        bitField0_ |= 0x00000004;
        allocations_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 allocations = 3;</code>
       *
       * <pre>
       *  Number of allocations
       * </pre>
       */
      public Builder clearAllocations() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allocations_ = 0L;
        onChanged();
        return this;
      }

      private long frees_ ;
      /**
       * <code>optional uint64 frees = 4;</code>
       *
       * <pre>
       *  Number of frees
       * </pre>
       */
      public boolean hasFrees() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 frees = 4;</code>
       *
       * <pre>
       *  Number of frees
       * </pre>
       */
      public long getFrees() {
        return frees_;
      }
      /**
       * <code>optional uint64 frees = 4;</code>
       *
       * <pre>
       *  Number of frees
       * </pre>
       */
      public Builder setFrees(long value) {
        bitField0_ |= 0x00000008;
        frees_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 frees = 4;</code>
       *
       * <pre>
       *  Number of frees
       * </pre>
       */
      public Builder clearFrees() {
        bitField0_ = (bitField0_ & ~0x00000008);
        frees_ = 0L;
        onChanged();
        return this;
      }

      private long allocationsFailed_ ;
      /**
       * <code>optional uint64 allocations_failed = 5;</code>
       *
       * <pre>
       * Number of allocations failed
       * </pre>
       */
      public boolean hasAllocationsFailed() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint64 allocations_failed = 5;</code>
       *
       * <pre>
       * Number of allocations failed
       * </pre>
       */
      public long getAllocationsFailed() {
        return allocationsFailed_;
      }
      /**
       * <code>optional uint64 allocations_failed = 5;</code>
       *
       * <pre>
       * Number of allocations failed
       * </pre>
       */
      public Builder setAllocationsFailed(long value) {
        bitField0_ |= 0x00000010;
        allocationsFailed_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 allocations_failed = 5;</code>
       *
       * <pre>
       * Number of allocations failed
       * </pre>
       */
      public Builder clearAllocationsFailed() {
        bitField0_ = (bitField0_ & ~0x00000010);
        allocationsFailed_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:CpuMemoryUtilizationPerApplication)
    }

    static {
      defaultInstance = new CpuMemoryUtilizationPerApplication(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:CpuMemoryUtilizationPerApplication)
  }

  public static final int CPU_MEMORY_UTIL_EXT_FIELD_NUMBER = 1;
  /**
   * <code>extend .JuniperNetworksSensors { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      TelemetryTop.JuniperNetworksSensors,
      CpuMemoryUtilizationOuterClass.CpuMemoryUtilization> cpuMemoryUtilExt = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.class,
        CpuMemoryUtilizationOuterClass.CpuMemoryUtilization.getDefaultInstance());
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_CpuMemoryUtilization_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CpuMemoryUtilization_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_CpuMemoryUtilizationSummary_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CpuMemoryUtilizationSummary_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_CpuMemoryUtilizationPerApplication_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CpuMemoryUtilizationPerApplication_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\034cpu_memory_utilization.proto\032\023telemetr" +
      "y_top.proto\"I\n\024CpuMemoryUtilization\0221\n\013u" +
      "tilization\030\001 \003(\0132\034.CpuMemoryUtilizationS" +
      "ummary\"\255\001\n\033CpuMemoryUtilizationSummary\022\014" +
      "\n\004name\030\001 \001(\t\022\014\n\004size\030\002 \001(\004\022\027\n\017bytes_allo" +
      "cated\030\003 \001(\004\022\023\n\013utilization\030\004 \001(\005\022D\n\027appl" +
      "ication_utilization\030\005 \003(\0132#.CpuMemoryUti" +
      "lizationPerApplication\"\213\001\n\"CpuMemoryUtil" +
      "izationPerApplication\022\014\n\004name\030\001 \001(\t\022\027\n\017b" +
      "ytes_allocated\030\002 \001(\004\022\023\n\013allocations\030\003 \001(",
      "\004\022\r\n\005frees\030\004 \001(\004\022\032\n\022allocations_failed\030\005" +
      " \001(\004:K\n\023cpu_memory_util_ext\022\027.JuniperNet" +
      "worksSensors\030\001 \001(\0132\025.CpuMemoryUtilizatio" +
      "n"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          TelemetryTop.getDescriptor(),
        }, assigner);
    internal_static_CpuMemoryUtilization_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_CpuMemoryUtilization_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CpuMemoryUtilization_descriptor,
        new java.lang.String[] { "Utilization", });
    internal_static_CpuMemoryUtilizationSummary_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_CpuMemoryUtilizationSummary_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CpuMemoryUtilizationSummary_descriptor,
        new java.lang.String[] { "Name", "Size", "BytesAllocated", "Utilization", "ApplicationUtilization", });
    internal_static_CpuMemoryUtilizationPerApplication_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_CpuMemoryUtilizationPerApplication_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CpuMemoryUtilizationPerApplication_descriptor,
        new java.lang.String[] { "Name", "BytesAllocated", "Allocations", "Frees", "AllocationsFailed", });
    cpuMemoryUtilExt.internalInit(descriptor.getExtensions().get(0));
    TelemetryTop.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
