/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.protocols.jti.adapter.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: telemetry_top.proto

public final class TelemetryTop {
  private TelemetryTop() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.juniperNetworks);
  }
  public interface TelemetryFieldOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:TelemetryFieldOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional bool is_key = 1;</code>
     */
    boolean hasIsKey();
    /**
     * <code>optional bool is_key = 1;</code>
     */
    boolean getIsKey();

    /**
     * <code>optional bool is_timestamp = 2;</code>
     */
    boolean hasIsTimestamp();
    /**
     * <code>optional bool is_timestamp = 2;</code>
     */
    boolean getIsTimestamp();

    /**
     * <code>optional bool is_counter = 3;</code>
     */
    boolean hasIsCounter();
    /**
     * <code>optional bool is_counter = 3;</code>
     */
    boolean getIsCounter();

    /**
     * <code>optional bool is_gauge = 4;</code>
     */
    boolean hasIsGauge();
    /**
     * <code>optional bool is_gauge = 4;</code>
     */
    boolean getIsGauge();
  }
  /**
   * Protobuf type {@code TelemetryFieldOptions}
   */
  public static final class TelemetryFieldOptions extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:TelemetryFieldOptions)
      TelemetryFieldOptionsOrBuilder {
    // Use TelemetryFieldOptions.newBuilder() to construct.
    private TelemetryFieldOptions(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private TelemetryFieldOptions(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final TelemetryFieldOptions defaultInstance;
    public static TelemetryFieldOptions getDefaultInstance() {
      return defaultInstance;
    }

    public TelemetryFieldOptions getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private TelemetryFieldOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              isKey_ = input.readBool();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              isTimestamp_ = input.readBool();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              isCounter_ = input.readBool();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              isGauge_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return TelemetryTop.internal_static_TelemetryFieldOptions_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return TelemetryTop.internal_static_TelemetryFieldOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              TelemetryTop.TelemetryFieldOptions.class, TelemetryTop.TelemetryFieldOptions.Builder.class);
    }

    public static com.google.protobuf.Parser<TelemetryFieldOptions> PARSER =
        new com.google.protobuf.AbstractParser<TelemetryFieldOptions>() {
      public TelemetryFieldOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TelemetryFieldOptions(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<TelemetryFieldOptions> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int IS_KEY_FIELD_NUMBER = 1;
    private boolean isKey_;
    /**
     * <code>optional bool is_key = 1;</code>
     */
    public boolean hasIsKey() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional bool is_key = 1;</code>
     */
    public boolean getIsKey() {
      return isKey_;
    }

    public static final int IS_TIMESTAMP_FIELD_NUMBER = 2;
    private boolean isTimestamp_;
    /**
     * <code>optional bool is_timestamp = 2;</code>
     */
    public boolean hasIsTimestamp() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool is_timestamp = 2;</code>
     */
    public boolean getIsTimestamp() {
      return isTimestamp_;
    }

    public static final int IS_COUNTER_FIELD_NUMBER = 3;
    private boolean isCounter_;
    /**
     * <code>optional bool is_counter = 3;</code>
     */
    public boolean hasIsCounter() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bool is_counter = 3;</code>
     */
    public boolean getIsCounter() {
      return isCounter_;
    }

    public static final int IS_GAUGE_FIELD_NUMBER = 4;
    private boolean isGauge_;
    /**
     * <code>optional bool is_gauge = 4;</code>
     */
    public boolean hasIsGauge() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional bool is_gauge = 4;</code>
     */
    public boolean getIsGauge() {
      return isGauge_;
    }

    private void initFields() {
      isKey_ = false;
      isTimestamp_ = false;
      isCounter_ = false;
      isGauge_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBool(1, isKey_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBool(2, isTimestamp_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBool(3, isCounter_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBool(4, isGauge_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, isKey_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, isTimestamp_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, isCounter_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, isGauge_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static TelemetryTop.TelemetryFieldOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static TelemetryTop.TelemetryFieldOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static TelemetryTop.TelemetryFieldOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.TelemetryFieldOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(TelemetryTop.TelemetryFieldOptions prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code TelemetryFieldOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:TelemetryFieldOptions)
        TelemetryTop.TelemetryFieldOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return TelemetryTop.internal_static_TelemetryFieldOptions_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return TelemetryTop.internal_static_TelemetryFieldOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                TelemetryTop.TelemetryFieldOptions.class, TelemetryTop.TelemetryFieldOptions.Builder.class);
      }

      // Construct using TelemetryTop.TelemetryFieldOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        isKey_ = false;
        bitField0_ = (bitField0_ & ~0x00000001);
        isTimestamp_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        isCounter_ = false;
        bitField0_ = (bitField0_ & ~0x00000004);
        isGauge_ = false;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return TelemetryTop.internal_static_TelemetryFieldOptions_descriptor;
      }

      public TelemetryTop.TelemetryFieldOptions getDefaultInstanceForType() {
        return TelemetryTop.TelemetryFieldOptions.getDefaultInstance();
      }

      public TelemetryTop.TelemetryFieldOptions build() {
        TelemetryTop.TelemetryFieldOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public TelemetryTop.TelemetryFieldOptions buildPartial() {
        TelemetryTop.TelemetryFieldOptions result = new TelemetryTop.TelemetryFieldOptions(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.isKey_ = isKey_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.isTimestamp_ = isTimestamp_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.isCounter_ = isCounter_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.isGauge_ = isGauge_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof TelemetryTop.TelemetryFieldOptions) {
          return mergeFrom((TelemetryTop.TelemetryFieldOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(TelemetryTop.TelemetryFieldOptions other) {
        if (other == TelemetryTop.TelemetryFieldOptions.getDefaultInstance()) return this;
        if (other.hasIsKey()) {
          setIsKey(other.getIsKey());
        }
        if (other.hasIsTimestamp()) {
          setIsTimestamp(other.getIsTimestamp());
        }
        if (other.hasIsCounter()) {
          setIsCounter(other.getIsCounter());
        }
        if (other.hasIsGauge()) {
          setIsGauge(other.getIsGauge());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        TelemetryTop.TelemetryFieldOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (TelemetryTop.TelemetryFieldOptions) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private boolean isKey_ ;
      /**
       * <code>optional bool is_key = 1;</code>
       */
      public boolean hasIsKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional bool is_key = 1;</code>
       */
      public boolean getIsKey() {
        return isKey_;
      }
      /**
       * <code>optional bool is_key = 1;</code>
       */
      public Builder setIsKey(boolean value) {
        bitField0_ |= 0x00000001;
        isKey_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_key = 1;</code>
       */
      public Builder clearIsKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        isKey_ = false;
        onChanged();
        return this;
      }

      private boolean isTimestamp_ ;
      /**
       * <code>optional bool is_timestamp = 2;</code>
       */
      public boolean hasIsTimestamp() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bool is_timestamp = 2;</code>
       */
      public boolean getIsTimestamp() {
        return isTimestamp_;
      }
      /**
       * <code>optional bool is_timestamp = 2;</code>
       */
      public Builder setIsTimestamp(boolean value) {
        bitField0_ |= 0x00000002;
        isTimestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_timestamp = 2;</code>
       */
      public Builder clearIsTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000002);
        isTimestamp_ = false;
        onChanged();
        return this;
      }

      private boolean isCounter_ ;
      /**
       * <code>optional bool is_counter = 3;</code>
       */
      public boolean hasIsCounter() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bool is_counter = 3;</code>
       */
      public boolean getIsCounter() {
        return isCounter_;
      }
      /**
       * <code>optional bool is_counter = 3;</code>
       */
      public Builder setIsCounter(boolean value) {
        bitField0_ |= 0x00000004;
        isCounter_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_counter = 3;</code>
       */
      public Builder clearIsCounter() {
        bitField0_ = (bitField0_ & ~0x00000004);
        isCounter_ = false;
        onChanged();
        return this;
      }

      private boolean isGauge_ ;
      /**
       * <code>optional bool is_gauge = 4;</code>
       */
      public boolean hasIsGauge() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional bool is_gauge = 4;</code>
       */
      public boolean getIsGauge() {
        return isGauge_;
      }
      /**
       * <code>optional bool is_gauge = 4;</code>
       */
      public Builder setIsGauge(boolean value) {
        bitField0_ |= 0x00000008;
        isGauge_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_gauge = 4;</code>
       */
      public Builder clearIsGauge() {
        bitField0_ = (bitField0_ & ~0x00000008);
        isGauge_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:TelemetryFieldOptions)
    }

    static {
      defaultInstance = new TelemetryFieldOptions(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:TelemetryFieldOptions)
  }

  public interface TelemetryStreamOrBuilder extends
      // @@protoc_insertion_point(interface_extends:TelemetryStream)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string system_id = 1;</code>
     *
     * <pre>
     * router name or export IP address
     * </pre>
     */
    boolean hasSystemId();
    /**
     * <code>required string system_id = 1;</code>
     *
     * <pre>
     * router name or export IP address
     * </pre>
     */
    java.lang.String getSystemId();
    /**
     * <code>required string system_id = 1;</code>
     *
     * <pre>
     * router name or export IP address
     * </pre>
     */
    com.google.protobuf.ByteString
        getSystemIdBytes();

    /**
     * <code>optional uint32 component_id = 2;</code>
     *
     * <pre>
     * line card / RE (slot number)
     * </pre>
     */
    boolean hasComponentId();
    /**
     * <code>optional uint32 component_id = 2;</code>
     *
     * <pre>
     * line card / RE (slot number)
     * </pre>
     */
    int getComponentId();

    /**
     * <code>optional uint32 sub_component_id = 3;</code>
     *
     * <pre>
     * PFE (if applicable)
     * </pre>
     */
    boolean hasSubComponentId();
    /**
     * <code>optional uint32 sub_component_id = 3;</code>
     *
     * <pre>
     * PFE (if applicable)
     * </pre>
     */
    int getSubComponentId();

    /**
     * <code>optional string sensor_name = 4;</code>
     *
     * <pre>
     * configured sensor name
     * </pre>
     */
    boolean hasSensorName();
    /**
     * <code>optional string sensor_name = 4;</code>
     *
     * <pre>
     * configured sensor name
     * </pre>
     */
    java.lang.String getSensorName();
    /**
     * <code>optional string sensor_name = 4;</code>
     *
     * <pre>
     * configured sensor name
     * </pre>
     */
    com.google.protobuf.ByteString
        getSensorNameBytes();

    /**
     * <code>optional uint32 sequence_number = 5;</code>
     *
     * <pre>
     * sequence number, monotonically increasesing for each
     * system_id, component_id, sub_component_id + sensor_name.
     * </pre>
     */
    boolean hasSequenceNumber();
    /**
     * <code>optional uint32 sequence_number = 5;</code>
     *
     * <pre>
     * sequence number, monotonically increasesing for each
     * system_id, component_id, sub_component_id + sensor_name.
     * </pre>
     */
    int getSequenceNumber();

    /**
     * <code>optional uint64 timestamp = 6;</code>
     *
     * <pre>
     * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
     * </pre>
     */
    boolean hasTimestamp();
    /**
     * <code>optional uint64 timestamp = 6;</code>
     *
     * <pre>
     * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
     * </pre>
     */
    long getTimestamp();

    /**
     * <code>optional uint32 version_major = 7;</code>
     *
     * <pre>
     * major version
     * </pre>
     */
    boolean hasVersionMajor();
    /**
     * <code>optional uint32 version_major = 7;</code>
     *
     * <pre>
     * major version
     * </pre>
     */
    int getVersionMajor();

    /**
     * <code>optional uint32 version_minor = 8;</code>
     *
     * <pre>
     * minor version
     * </pre>
     */
    boolean hasVersionMinor();
    /**
     * <code>optional uint32 version_minor = 8;</code>
     *
     * <pre>
     * minor version
     * </pre>
     */
    int getVersionMinor();

    /**
     * <code>optional .IETFSensors ietf = 100;</code>
     */
    boolean hasIetf();
    /**
     * <code>optional .IETFSensors ietf = 100;</code>
     */
    TelemetryTop.IETFSensors getIetf();
    /**
     * <code>optional .IETFSensors ietf = 100;</code>
     */
    TelemetryTop.IETFSensorsOrBuilder getIetfOrBuilder();

    /**
     * <code>optional .EnterpriseSensors enterprise = 101;</code>
     */
    boolean hasEnterprise();
    /**
     * <code>optional .EnterpriseSensors enterprise = 101;</code>
     */
    TelemetryTop.EnterpriseSensors getEnterprise();
    /**
     * <code>optional .EnterpriseSensors enterprise = 101;</code>
     */
    TelemetryTop.EnterpriseSensorsOrBuilder getEnterpriseOrBuilder();
  }
  /**
   * Protobuf type {@code TelemetryStream}
   */
  public static final class TelemetryStream extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:TelemetryStream)
      TelemetryStreamOrBuilder {
    // Use TelemetryStream.newBuilder() to construct.
    private TelemetryStream(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private TelemetryStream(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final TelemetryStream defaultInstance;
    public static TelemetryStream getDefaultInstance() {
      return defaultInstance;
    }

    public TelemetryStream getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private TelemetryStream(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              systemId_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              componentId_ = input.readUInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              subComponentId_ = input.readUInt32();
              break;
            }
            case 34: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000008;
              sensorName_ = bs;
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              sequenceNumber_ = input.readUInt32();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              timestamp_ = input.readUInt64();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              versionMajor_ = input.readUInt32();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000080;
              versionMinor_ = input.readUInt32();
              break;
            }
            case 802: {
              TelemetryTop.IETFSensors.Builder subBuilder = null;
              if (((bitField0_ & 0x00000100) == 0x00000100)) {
                subBuilder = ietf_.toBuilder();
              }
              ietf_ = input.readMessage(TelemetryTop.IETFSensors.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ietf_);
                ietf_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000100;
              break;
            }
            case 810: {
              TelemetryTop.EnterpriseSensors.Builder subBuilder = null;
              if (((bitField0_ & 0x00000200) == 0x00000200)) {
                subBuilder = enterprise_.toBuilder();
              }
              enterprise_ = input.readMessage(TelemetryTop.EnterpriseSensors.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(enterprise_);
                enterprise_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000200;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return TelemetryTop.internal_static_TelemetryStream_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return TelemetryTop.internal_static_TelemetryStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              TelemetryTop.TelemetryStream.class, TelemetryTop.TelemetryStream.Builder.class);
    }

    public static com.google.protobuf.Parser<TelemetryStream> PARSER =
        new com.google.protobuf.AbstractParser<TelemetryStream>() {
      public TelemetryStream parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TelemetryStream(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<TelemetryStream> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int SYSTEM_ID_FIELD_NUMBER = 1;
    private java.lang.Object systemId_;
    /**
     * <code>required string system_id = 1;</code>
     *
     * <pre>
     * router name or export IP address
     * </pre>
     */
    public boolean hasSystemId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string system_id = 1;</code>
     *
     * <pre>
     * router name or export IP address
     * </pre>
     */
    public java.lang.String getSystemId() {
      java.lang.Object ref = systemId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          systemId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string system_id = 1;</code>
     *
     * <pre>
     * router name or export IP address
     * </pre>
     */
    public com.google.protobuf.ByteString
        getSystemIdBytes() {
      java.lang.Object ref = systemId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        systemId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMPONENT_ID_FIELD_NUMBER = 2;
    private int componentId_;
    /**
     * <code>optional uint32 component_id = 2;</code>
     *
     * <pre>
     * line card / RE (slot number)
     * </pre>
     */
    public boolean hasComponentId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint32 component_id = 2;</code>
     *
     * <pre>
     * line card / RE (slot number)
     * </pre>
     */
    public int getComponentId() {
      return componentId_;
    }

    public static final int SUB_COMPONENT_ID_FIELD_NUMBER = 3;
    private int subComponentId_;
    /**
     * <code>optional uint32 sub_component_id = 3;</code>
     *
     * <pre>
     * PFE (if applicable)
     * </pre>
     */
    public boolean hasSubComponentId() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint32 sub_component_id = 3;</code>
     *
     * <pre>
     * PFE (if applicable)
     * </pre>
     */
    public int getSubComponentId() {
      return subComponentId_;
    }

    public static final int SENSOR_NAME_FIELD_NUMBER = 4;
    private java.lang.Object sensorName_;
    /**
     * <code>optional string sensor_name = 4;</code>
     *
     * <pre>
     * configured sensor name
     * </pre>
     */
    public boolean hasSensorName() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string sensor_name = 4;</code>
     *
     * <pre>
     * configured sensor name
     * </pre>
     */
    public java.lang.String getSensorName() {
      java.lang.Object ref = sensorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          sensorName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string sensor_name = 4;</code>
     *
     * <pre>
     * configured sensor name
     * </pre>
     */
    public com.google.protobuf.ByteString
        getSensorNameBytes() {
      java.lang.Object ref = sensorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sensorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SEQUENCE_NUMBER_FIELD_NUMBER = 5;
    private int sequenceNumber_;
    /**
     * <code>optional uint32 sequence_number = 5;</code>
     *
     * <pre>
     * sequence number, monotonically increasesing for each
     * system_id, component_id, sub_component_id + sensor_name.
     * </pre>
     */
    public boolean hasSequenceNumber() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint32 sequence_number = 5;</code>
     *
     * <pre>
     * sequence number, monotonically increasesing for each
     * system_id, component_id, sub_component_id + sensor_name.
     * </pre>
     */
    public int getSequenceNumber() {
      return sequenceNumber_;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 6;
    private long timestamp_;
    /**
     * <code>optional uint64 timestamp = 6;</code>
     *
     * <pre>
     * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
     * </pre>
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional uint64 timestamp = 6;</code>
     *
     * <pre>
     * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
     * </pre>
     */
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int VERSION_MAJOR_FIELD_NUMBER = 7;
    private int versionMajor_;
    /**
     * <code>optional uint32 version_major = 7;</code>
     *
     * <pre>
     * major version
     * </pre>
     */
    public boolean hasVersionMajor() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint32 version_major = 7;</code>
     *
     * <pre>
     * major version
     * </pre>
     */
    public int getVersionMajor() {
      return versionMajor_;
    }

    public static final int VERSION_MINOR_FIELD_NUMBER = 8;
    private int versionMinor_;
    /**
     * <code>optional uint32 version_minor = 8;</code>
     *
     * <pre>
     * minor version
     * </pre>
     */
    public boolean hasVersionMinor() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional uint32 version_minor = 8;</code>
     *
     * <pre>
     * minor version
     * </pre>
     */
    public int getVersionMinor() {
      return versionMinor_;
    }

    public static final int IETF_FIELD_NUMBER = 100;
    private TelemetryTop.IETFSensors ietf_;
    /**
     * <code>optional .IETFSensors ietf = 100;</code>
     */
    public boolean hasIetf() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional .IETFSensors ietf = 100;</code>
     */
    public TelemetryTop.IETFSensors getIetf() {
      return ietf_;
    }
    /**
     * <code>optional .IETFSensors ietf = 100;</code>
     */
    public TelemetryTop.IETFSensorsOrBuilder getIetfOrBuilder() {
      return ietf_;
    }

    public static final int ENTERPRISE_FIELD_NUMBER = 101;
    private TelemetryTop.EnterpriseSensors enterprise_;
    /**
     * <code>optional .EnterpriseSensors enterprise = 101;</code>
     */
    public boolean hasEnterprise() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional .EnterpriseSensors enterprise = 101;</code>
     */
    public TelemetryTop.EnterpriseSensors getEnterprise() {
      return enterprise_;
    }
    /**
     * <code>optional .EnterpriseSensors enterprise = 101;</code>
     */
    public TelemetryTop.EnterpriseSensorsOrBuilder getEnterpriseOrBuilder() {
      return enterprise_;
    }

    private void initFields() {
      systemId_ = "";
      componentId_ = 0;
      subComponentId_ = 0;
      sensorName_ = "";
      sequenceNumber_ = 0;
      timestamp_ = 0L;
      versionMajor_ = 0;
      versionMinor_ = 0;
      ietf_ = TelemetryTop.IETFSensors.getDefaultInstance();
      enterprise_ = TelemetryTop.EnterpriseSensors.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasSystemId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasIetf()) {
        if (!getIetf().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasEnterprise()) {
        if (!getEnterprise().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getSystemIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, componentId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt32(3, subComponentId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getSensorNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt32(5, sequenceNumber_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt64(6, timestamp_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt32(7, versionMajor_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeUInt32(8, versionMinor_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeMessage(100, ietf_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeMessage(101, enterprise_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getSystemIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, componentId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, subComponentId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getSensorNameBytes());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(5, sequenceNumber_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, timestamp_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, versionMajor_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(8, versionMinor_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(100, ietf_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(101, enterprise_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static TelemetryTop.TelemetryStream parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.TelemetryStream parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.TelemetryStream parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.TelemetryStream parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.TelemetryStream parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.TelemetryStream parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static TelemetryTop.TelemetryStream parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static TelemetryTop.TelemetryStream parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static TelemetryTop.TelemetryStream parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.TelemetryStream parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(TelemetryTop.TelemetryStream prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code TelemetryStream}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:TelemetryStream)
        TelemetryTop.TelemetryStreamOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return TelemetryTop.internal_static_TelemetryStream_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return TelemetryTop.internal_static_TelemetryStream_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                TelemetryTop.TelemetryStream.class, TelemetryTop.TelemetryStream.Builder.class);
      }

      // Construct using TelemetryTop.TelemetryStream.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getIetfFieldBuilder();
          getEnterpriseFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        systemId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        componentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        subComponentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        sensorName_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        sequenceNumber_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        timestamp_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000020);
        versionMajor_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        versionMinor_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        if (ietfBuilder_ == null) {
          ietf_ = TelemetryTop.IETFSensors.getDefaultInstance();
        } else {
          ietfBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        if (enterpriseBuilder_ == null) {
          enterprise_ = TelemetryTop.EnterpriseSensors.getDefaultInstance();
        } else {
          enterpriseBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000200);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return TelemetryTop.internal_static_TelemetryStream_descriptor;
      }

      public TelemetryTop.TelemetryStream getDefaultInstanceForType() {
        return TelemetryTop.TelemetryStream.getDefaultInstance();
      }

      public TelemetryTop.TelemetryStream build() {
        TelemetryTop.TelemetryStream result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public TelemetryTop.TelemetryStream buildPartial() {
        TelemetryTop.TelemetryStream result = new TelemetryTop.TelemetryStream(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.systemId_ = systemId_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.componentId_ = componentId_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.subComponentId_ = subComponentId_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.sensorName_ = sensorName_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.sequenceNumber_ = sequenceNumber_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.timestamp_ = timestamp_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.versionMajor_ = versionMajor_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.versionMinor_ = versionMinor_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        if (ietfBuilder_ == null) {
          result.ietf_ = ietf_;
        } else {
          result.ietf_ = ietfBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        if (enterpriseBuilder_ == null) {
          result.enterprise_ = enterprise_;
        } else {
          result.enterprise_ = enterpriseBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof TelemetryTop.TelemetryStream) {
          return mergeFrom((TelemetryTop.TelemetryStream)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(TelemetryTop.TelemetryStream other) {
        if (other == TelemetryTop.TelemetryStream.getDefaultInstance()) return this;
        if (other.hasSystemId()) {
          bitField0_ |= 0x00000001;
          systemId_ = other.systemId_;
          onChanged();
        }
        if (other.hasComponentId()) {
          setComponentId(other.getComponentId());
        }
        if (other.hasSubComponentId()) {
          setSubComponentId(other.getSubComponentId());
        }
        if (other.hasSensorName()) {
          bitField0_ |= 0x00000008;
          sensorName_ = other.sensorName_;
          onChanged();
        }
        if (other.hasSequenceNumber()) {
          setSequenceNumber(other.getSequenceNumber());
        }
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasVersionMajor()) {
          setVersionMajor(other.getVersionMajor());
        }
        if (other.hasVersionMinor()) {
          setVersionMinor(other.getVersionMinor());
        }
        if (other.hasIetf()) {
          mergeIetf(other.getIetf());
        }
        if (other.hasEnterprise()) {
          mergeEnterprise(other.getEnterprise());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasSystemId()) {
          
          return false;
        }
        if (hasIetf()) {
          if (!getIetf().isInitialized()) {
            
            return false;
          }
        }
        if (hasEnterprise()) {
          if (!getEnterprise().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        TelemetryTop.TelemetryStream parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (TelemetryTop.TelemetryStream) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object systemId_ = "";
      /**
       * <code>required string system_id = 1;</code>
       *
       * <pre>
       * router name or export IP address
       * </pre>
       */
      public boolean hasSystemId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string system_id = 1;</code>
       *
       * <pre>
       * router name or export IP address
       * </pre>
       */
      public java.lang.String getSystemId() {
        java.lang.Object ref = systemId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            systemId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string system_id = 1;</code>
       *
       * <pre>
       * router name or export IP address
       * </pre>
       */
      public com.google.protobuf.ByteString
          getSystemIdBytes() {
        java.lang.Object ref = systemId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          systemId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string system_id = 1;</code>
       *
       * <pre>
       * router name or export IP address
       * </pre>
       */
      public Builder setSystemId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        systemId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string system_id = 1;</code>
       *
       * <pre>
       * router name or export IP address
       * </pre>
       */
      public Builder clearSystemId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        systemId_ = getDefaultInstance().getSystemId();
        onChanged();
        return this;
      }
      /**
       * <code>required string system_id = 1;</code>
       *
       * <pre>
       * router name or export IP address
       * </pre>
       */
      public Builder setSystemIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        systemId_ = value;
        onChanged();
        return this;
      }

      private int componentId_ ;
      /**
       * <code>optional uint32 component_id = 2;</code>
       *
       * <pre>
       * line card / RE (slot number)
       * </pre>
       */
      public boolean hasComponentId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint32 component_id = 2;</code>
       *
       * <pre>
       * line card / RE (slot number)
       * </pre>
       */
      public int getComponentId() {
        return componentId_;
      }
      /**
       * <code>optional uint32 component_id = 2;</code>
       *
       * <pre>
       * line card / RE (slot number)
       * </pre>
       */
      public Builder setComponentId(int value) {
        bitField0_ |= 0x00000002;
        componentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 component_id = 2;</code>
       *
       * <pre>
       * line card / RE (slot number)
       * </pre>
       */
      public Builder clearComponentId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        componentId_ = 0;
        onChanged();
        return this;
      }

      private int subComponentId_ ;
      /**
       * <code>optional uint32 sub_component_id = 3;</code>
       *
       * <pre>
       * PFE (if applicable)
       * </pre>
       */
      public boolean hasSubComponentId() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint32 sub_component_id = 3;</code>
       *
       * <pre>
       * PFE (if applicable)
       * </pre>
       */
      public int getSubComponentId() {
        return subComponentId_;
      }
      /**
       * <code>optional uint32 sub_component_id = 3;</code>
       *
       * <pre>
       * PFE (if applicable)
       * </pre>
       */
      public Builder setSubComponentId(int value) {
        bitField0_ |= 0x00000004;
        subComponentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 sub_component_id = 3;</code>
       *
       * <pre>
       * PFE (if applicable)
       * </pre>
       */
      public Builder clearSubComponentId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        subComponentId_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object sensorName_ = "";
      /**
       * <code>optional string sensor_name = 4;</code>
       *
       * <pre>
       * configured sensor name
       * </pre>
       */
      public boolean hasSensorName() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string sensor_name = 4;</code>
       *
       * <pre>
       * configured sensor name
       * </pre>
       */
      public java.lang.String getSensorName() {
        java.lang.Object ref = sensorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            sensorName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sensor_name = 4;</code>
       *
       * <pre>
       * configured sensor name
       * </pre>
       */
      public com.google.protobuf.ByteString
          getSensorNameBytes() {
        java.lang.Object ref = sensorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sensorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string sensor_name = 4;</code>
       *
       * <pre>
       * configured sensor name
       * </pre>
       */
      public Builder setSensorName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        sensorName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sensor_name = 4;</code>
       *
       * <pre>
       * configured sensor name
       * </pre>
       */
      public Builder clearSensorName() {
        bitField0_ = (bitField0_ & ~0x00000008);
        sensorName_ = getDefaultInstance().getSensorName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sensor_name = 4;</code>
       *
       * <pre>
       * configured sensor name
       * </pre>
       */
      public Builder setSensorNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        sensorName_ = value;
        onChanged();
        return this;
      }

      private int sequenceNumber_ ;
      /**
       * <code>optional uint32 sequence_number = 5;</code>
       *
       * <pre>
       * sequence number, monotonically increasesing for each
       * system_id, component_id, sub_component_id + sensor_name.
       * </pre>
       */
      public boolean hasSequenceNumber() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint32 sequence_number = 5;</code>
       *
       * <pre>
       * sequence number, monotonically increasesing for each
       * system_id, component_id, sub_component_id + sensor_name.
       * </pre>
       */
      public int getSequenceNumber() {
        return sequenceNumber_;
      }
      /**
       * <code>optional uint32 sequence_number = 5;</code>
       *
       * <pre>
       * sequence number, monotonically increasesing for each
       * system_id, component_id, sub_component_id + sensor_name.
       * </pre>
       */
      public Builder setSequenceNumber(int value) {
        bitField0_ |= 0x00000010;
        sequenceNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 sequence_number = 5;</code>
       *
       * <pre>
       * sequence number, monotonically increasesing for each
       * system_id, component_id, sub_component_id + sensor_name.
       * </pre>
       */
      public Builder clearSequenceNumber() {
        bitField0_ = (bitField0_ & ~0x00000010);
        sequenceNumber_ = 0;
        onChanged();
        return this;
      }

      private long timestamp_ ;
      /**
       * <code>optional uint64 timestamp = 6;</code>
       *
       * <pre>
       * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
       * </pre>
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional uint64 timestamp = 6;</code>
       *
       * <pre>
       * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
       * </pre>
       */
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <code>optional uint64 timestamp = 6;</code>
       *
       * <pre>
       * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
       * </pre>
       */
      public Builder setTimestamp(long value) {
        bitField0_ |= 0x00000020;
        timestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 timestamp = 6;</code>
       *
       * <pre>
       * timestamp (milliseconds since 00:00:00 UTC 1/1/1970)
       * </pre>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000020);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private int versionMajor_ ;
      /**
       * <code>optional uint32 version_major = 7;</code>
       *
       * <pre>
       * major version
       * </pre>
       */
      public boolean hasVersionMajor() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint32 version_major = 7;</code>
       *
       * <pre>
       * major version
       * </pre>
       */
      public int getVersionMajor() {
        return versionMajor_;
      }
      /**
       * <code>optional uint32 version_major = 7;</code>
       *
       * <pre>
       * major version
       * </pre>
       */
      public Builder setVersionMajor(int value) {
        bitField0_ |= 0x00000040;
        versionMajor_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 version_major = 7;</code>
       *
       * <pre>
       * major version
       * </pre>
       */
      public Builder clearVersionMajor() {
        bitField0_ = (bitField0_ & ~0x00000040);
        versionMajor_ = 0;
        onChanged();
        return this;
      }

      private int versionMinor_ ;
      /**
       * <code>optional uint32 version_minor = 8;</code>
       *
       * <pre>
       * minor version
       * </pre>
       */
      public boolean hasVersionMinor() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional uint32 version_minor = 8;</code>
       *
       * <pre>
       * minor version
       * </pre>
       */
      public int getVersionMinor() {
        return versionMinor_;
      }
      /**
       * <code>optional uint32 version_minor = 8;</code>
       *
       * <pre>
       * minor version
       * </pre>
       */
      public Builder setVersionMinor(int value) {
        bitField0_ |= 0x00000080;
        versionMinor_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 version_minor = 8;</code>
       *
       * <pre>
       * minor version
       * </pre>
       */
      public Builder clearVersionMinor() {
        bitField0_ = (bitField0_ & ~0x00000080);
        versionMinor_ = 0;
        onChanged();
        return this;
      }

      private TelemetryTop.IETFSensors ietf_ = TelemetryTop.IETFSensors.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          TelemetryTop.IETFSensors, TelemetryTop.IETFSensors.Builder, TelemetryTop.IETFSensorsOrBuilder> ietfBuilder_;
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public boolean hasIetf() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public TelemetryTop.IETFSensors getIetf() {
        if (ietfBuilder_ == null) {
          return ietf_;
        } else {
          return ietfBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public Builder setIetf(TelemetryTop.IETFSensors value) {
        if (ietfBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ietf_ = value;
          onChanged();
        } else {
          ietfBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public Builder setIetf(
          TelemetryTop.IETFSensors.Builder builderForValue) {
        if (ietfBuilder_ == null) {
          ietf_ = builderForValue.build();
          onChanged();
        } else {
          ietfBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public Builder mergeIetf(TelemetryTop.IETFSensors value) {
        if (ietfBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100) &&
              ietf_ != TelemetryTop.IETFSensors.getDefaultInstance()) {
            ietf_ =
              TelemetryTop.IETFSensors.newBuilder(ietf_).mergeFrom(value).buildPartial();
          } else {
            ietf_ = value;
          }
          onChanged();
        } else {
          ietfBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public Builder clearIetf() {
        if (ietfBuilder_ == null) {
          ietf_ = TelemetryTop.IETFSensors.getDefaultInstance();
          onChanged();
        } else {
          ietfBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public TelemetryTop.IETFSensors.Builder getIetfBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getIetfFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      public TelemetryTop.IETFSensorsOrBuilder getIetfOrBuilder() {
        if (ietfBuilder_ != null) {
          return ietfBuilder_.getMessageOrBuilder();
        } else {
          return ietf_;
        }
      }
      /**
       * <code>optional .IETFSensors ietf = 100;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          TelemetryTop.IETFSensors, TelemetryTop.IETFSensors.Builder, TelemetryTop.IETFSensorsOrBuilder> 
          getIetfFieldBuilder() {
        if (ietfBuilder_ == null) {
          ietfBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              TelemetryTop.IETFSensors, TelemetryTop.IETFSensors.Builder, TelemetryTop.IETFSensorsOrBuilder>(
                  getIetf(),
                  getParentForChildren(),
                  isClean());
          ietf_ = null;
        }
        return ietfBuilder_;
      }

      private TelemetryTop.EnterpriseSensors enterprise_ = TelemetryTop.EnterpriseSensors.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          TelemetryTop.EnterpriseSensors, TelemetryTop.EnterpriseSensors.Builder, TelemetryTop.EnterpriseSensorsOrBuilder> enterpriseBuilder_;
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public boolean hasEnterprise() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public TelemetryTop.EnterpriseSensors getEnterprise() {
        if (enterpriseBuilder_ == null) {
          return enterprise_;
        } else {
          return enterpriseBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public Builder setEnterprise(TelemetryTop.EnterpriseSensors value) {
        if (enterpriseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          enterprise_ = value;
          onChanged();
        } else {
          enterpriseBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        return this;
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public Builder setEnterprise(
          TelemetryTop.EnterpriseSensors.Builder builderForValue) {
        if (enterpriseBuilder_ == null) {
          enterprise_ = builderForValue.build();
          onChanged();
        } else {
          enterpriseBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        return this;
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public Builder mergeEnterprise(TelemetryTop.EnterpriseSensors value) {
        if (enterpriseBuilder_ == null) {
          if (((bitField0_ & 0x00000200) == 0x00000200) &&
              enterprise_ != TelemetryTop.EnterpriseSensors.getDefaultInstance()) {
            enterprise_ =
              TelemetryTop.EnterpriseSensors.newBuilder(enterprise_).mergeFrom(value).buildPartial();
          } else {
            enterprise_ = value;
          }
          onChanged();
        } else {
          enterpriseBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000200;
        return this;
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public Builder clearEnterprise() {
        if (enterpriseBuilder_ == null) {
          enterprise_ = TelemetryTop.EnterpriseSensors.getDefaultInstance();
          onChanged();
        } else {
          enterpriseBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000200);
        return this;
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public TelemetryTop.EnterpriseSensors.Builder getEnterpriseBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getEnterpriseFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      public TelemetryTop.EnterpriseSensorsOrBuilder getEnterpriseOrBuilder() {
        if (enterpriseBuilder_ != null) {
          return enterpriseBuilder_.getMessageOrBuilder();
        } else {
          return enterprise_;
        }
      }
      /**
       * <code>optional .EnterpriseSensors enterprise = 101;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          TelemetryTop.EnterpriseSensors, TelemetryTop.EnterpriseSensors.Builder, TelemetryTop.EnterpriseSensorsOrBuilder> 
          getEnterpriseFieldBuilder() {
        if (enterpriseBuilder_ == null) {
          enterpriseBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              TelemetryTop.EnterpriseSensors, TelemetryTop.EnterpriseSensors.Builder, TelemetryTop.EnterpriseSensorsOrBuilder>(
                  getEnterprise(),
                  getParentForChildren(),
                  isClean());
          enterprise_ = null;
        }
        return enterpriseBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:TelemetryStream)
    }

    static {
      defaultInstance = new TelemetryStream(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:TelemetryStream)
  }

  public interface IETFSensorsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:IETFSensors)
      com.google.protobuf.GeneratedMessage.
          ExtendableMessageOrBuilder<IETFSensors> {
  }
  /**
   * Protobuf type {@code IETFSensors}
   */
  public static final class IETFSensors extends
      com.google.protobuf.GeneratedMessage.ExtendableMessage<
        IETFSensors> implements
      // @@protoc_insertion_point(message_implements:IETFSensors)
      IETFSensorsOrBuilder {
    // Use IETFSensors.newBuilder() to construct.
    private IETFSensors(com.google.protobuf.GeneratedMessage.ExtendableBuilder<TelemetryTop.IETFSensors, ?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private IETFSensors(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final IETFSensors defaultInstance;
    public static IETFSensors getDefaultInstance() {
      return defaultInstance;
    }

    public IETFSensors getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private IETFSensors(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return TelemetryTop.internal_static_IETFSensors_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return TelemetryTop.internal_static_IETFSensors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              TelemetryTop.IETFSensors.class, TelemetryTop.IETFSensors.Builder.class);
    }

    public static com.google.protobuf.Parser<IETFSensors> PARSER =
        new com.google.protobuf.AbstractParser<IETFSensors>() {
      public IETFSensors parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new IETFSensors(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<IETFSensors> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      com.google.protobuf.GeneratedMessage
        .ExtendableMessage<TelemetryTop.IETFSensors>.ExtensionWriter extensionWriter =
          newExtensionWriter();
      extensionWriter.writeUntil(536870912, output);
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += extensionsSerializedSize();
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static TelemetryTop.IETFSensors parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.IETFSensors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.IETFSensors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.IETFSensors parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.IETFSensors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.IETFSensors parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static TelemetryTop.IETFSensors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static TelemetryTop.IETFSensors parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static TelemetryTop.IETFSensors parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.IETFSensors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(TelemetryTop.IETFSensors prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code IETFSensors}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.ExtendableBuilder<
          TelemetryTop.IETFSensors, Builder> implements
        // @@protoc_insertion_point(builder_implements:IETFSensors)
        TelemetryTop.IETFSensorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return TelemetryTop.internal_static_IETFSensors_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return TelemetryTop.internal_static_IETFSensors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                TelemetryTop.IETFSensors.class, TelemetryTop.IETFSensors.Builder.class);
      }

      // Construct using TelemetryTop.IETFSensors.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return TelemetryTop.internal_static_IETFSensors_descriptor;
      }

      public TelemetryTop.IETFSensors getDefaultInstanceForType() {
        return TelemetryTop.IETFSensors.getDefaultInstance();
      }

      public TelemetryTop.IETFSensors build() {
        TelemetryTop.IETFSensors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public TelemetryTop.IETFSensors buildPartial() {
        TelemetryTop.IETFSensors result = new TelemetryTop.IETFSensors(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof TelemetryTop.IETFSensors) {
          return mergeFrom((TelemetryTop.IETFSensors)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(TelemetryTop.IETFSensors other) {
        if (other == TelemetryTop.IETFSensors.getDefaultInstance()) return this;
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!extensionsAreInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        TelemetryTop.IETFSensors parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (TelemetryTop.IETFSensors) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:IETFSensors)
    }

    static {
      defaultInstance = new IETFSensors(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:IETFSensors)
  }

  public interface EnterpriseSensorsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:EnterpriseSensors)
      com.google.protobuf.GeneratedMessage.
          ExtendableMessageOrBuilder<EnterpriseSensors> {
  }
  /**
   * Protobuf type {@code EnterpriseSensors}
   */
  public static final class EnterpriseSensors extends
      com.google.protobuf.GeneratedMessage.ExtendableMessage<
        EnterpriseSensors> implements
      // @@protoc_insertion_point(message_implements:EnterpriseSensors)
      EnterpriseSensorsOrBuilder {
    // Use EnterpriseSensors.newBuilder() to construct.
    private EnterpriseSensors(com.google.protobuf.GeneratedMessage.ExtendableBuilder<TelemetryTop.EnterpriseSensors, ?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private EnterpriseSensors(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final EnterpriseSensors defaultInstance;
    public static EnterpriseSensors getDefaultInstance() {
      return defaultInstance;
    }

    public EnterpriseSensors getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private EnterpriseSensors(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return TelemetryTop.internal_static_EnterpriseSensors_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return TelemetryTop.internal_static_EnterpriseSensors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              TelemetryTop.EnterpriseSensors.class, TelemetryTop.EnterpriseSensors.Builder.class);
    }

    public static com.google.protobuf.Parser<EnterpriseSensors> PARSER =
        new com.google.protobuf.AbstractParser<EnterpriseSensors>() {
      public EnterpriseSensors parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EnterpriseSensors(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<EnterpriseSensors> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      com.google.protobuf.GeneratedMessage
        .ExtendableMessage<TelemetryTop.EnterpriseSensors>.ExtensionWriter extensionWriter =
          newExtensionWriter();
      extensionWriter.writeUntil(536870912, output);
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += extensionsSerializedSize();
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static TelemetryTop.EnterpriseSensors parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static TelemetryTop.EnterpriseSensors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static TelemetryTop.EnterpriseSensors parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.EnterpriseSensors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(TelemetryTop.EnterpriseSensors prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code EnterpriseSensors}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.ExtendableBuilder<
          TelemetryTop.EnterpriseSensors, Builder> implements
        // @@protoc_insertion_point(builder_implements:EnterpriseSensors)
        TelemetryTop.EnterpriseSensorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return TelemetryTop.internal_static_EnterpriseSensors_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return TelemetryTop.internal_static_EnterpriseSensors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                TelemetryTop.EnterpriseSensors.class, TelemetryTop.EnterpriseSensors.Builder.class);
      }

      // Construct using TelemetryTop.EnterpriseSensors.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return TelemetryTop.internal_static_EnterpriseSensors_descriptor;
      }

      public TelemetryTop.EnterpriseSensors getDefaultInstanceForType() {
        return TelemetryTop.EnterpriseSensors.getDefaultInstance();
      }

      public TelemetryTop.EnterpriseSensors build() {
        TelemetryTop.EnterpriseSensors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public TelemetryTop.EnterpriseSensors buildPartial() {
        TelemetryTop.EnterpriseSensors result = new TelemetryTop.EnterpriseSensors(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof TelemetryTop.EnterpriseSensors) {
          return mergeFrom((TelemetryTop.EnterpriseSensors)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(TelemetryTop.EnterpriseSensors other) {
        if (other == TelemetryTop.EnterpriseSensors.getDefaultInstance()) return this;
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!extensionsAreInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        TelemetryTop.EnterpriseSensors parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (TelemetryTop.EnterpriseSensors) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:EnterpriseSensors)
    }

    static {
      defaultInstance = new EnterpriseSensors(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:EnterpriseSensors)
  }

  public interface JuniperNetworksSensorsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:JuniperNetworksSensors)
      com.google.protobuf.GeneratedMessage.
          ExtendableMessageOrBuilder<JuniperNetworksSensors> {
  }
  /**
   * Protobuf type {@code JuniperNetworksSensors}
   */
  public static final class JuniperNetworksSensors extends
      com.google.protobuf.GeneratedMessage.ExtendableMessage<
        JuniperNetworksSensors> implements
      // @@protoc_insertion_point(message_implements:JuniperNetworksSensors)
      JuniperNetworksSensorsOrBuilder {
    // Use JuniperNetworksSensors.newBuilder() to construct.
    private JuniperNetworksSensors(com.google.protobuf.GeneratedMessage.ExtendableBuilder<TelemetryTop.JuniperNetworksSensors, ?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private JuniperNetworksSensors(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final JuniperNetworksSensors defaultInstance;
    public static JuniperNetworksSensors getDefaultInstance() {
      return defaultInstance;
    }

    public JuniperNetworksSensors getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private JuniperNetworksSensors(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return TelemetryTop.internal_static_JuniperNetworksSensors_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return TelemetryTop.internal_static_JuniperNetworksSensors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              TelemetryTop.JuniperNetworksSensors.class, TelemetryTop.JuniperNetworksSensors.Builder.class);
    }

    public static com.google.protobuf.Parser<JuniperNetworksSensors> PARSER =
        new com.google.protobuf.AbstractParser<JuniperNetworksSensors>() {
      public JuniperNetworksSensors parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new JuniperNetworksSensors(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<JuniperNetworksSensors> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      com.google.protobuf.GeneratedMessage
        .ExtendableMessage<TelemetryTop.JuniperNetworksSensors>.ExtensionWriter extensionWriter =
          newExtensionWriter();
      extensionWriter.writeUntil(536870912, output);
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += extensionsSerializedSize();
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static TelemetryTop.JuniperNetworksSensors parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static TelemetryTop.JuniperNetworksSensors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static TelemetryTop.JuniperNetworksSensors parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static TelemetryTop.JuniperNetworksSensors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(TelemetryTop.JuniperNetworksSensors prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code JuniperNetworksSensors}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.ExtendableBuilder<
          TelemetryTop.JuniperNetworksSensors, Builder> implements
        // @@protoc_insertion_point(builder_implements:JuniperNetworksSensors)
        TelemetryTop.JuniperNetworksSensorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return TelemetryTop.internal_static_JuniperNetworksSensors_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return TelemetryTop.internal_static_JuniperNetworksSensors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                TelemetryTop.JuniperNetworksSensors.class, TelemetryTop.JuniperNetworksSensors.Builder.class);
      }

      // Construct using TelemetryTop.JuniperNetworksSensors.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return TelemetryTop.internal_static_JuniperNetworksSensors_descriptor;
      }

      public TelemetryTop.JuniperNetworksSensors getDefaultInstanceForType() {
        return TelemetryTop.JuniperNetworksSensors.getDefaultInstance();
      }

      public TelemetryTop.JuniperNetworksSensors build() {
        TelemetryTop.JuniperNetworksSensors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public TelemetryTop.JuniperNetworksSensors buildPartial() {
        TelemetryTop.JuniperNetworksSensors result = new TelemetryTop.JuniperNetworksSensors(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof TelemetryTop.JuniperNetworksSensors) {
          return mergeFrom((TelemetryTop.JuniperNetworksSensors)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(TelemetryTop.JuniperNetworksSensors other) {
        if (other == TelemetryTop.JuniperNetworksSensors.getDefaultInstance()) return this;
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!extensionsAreInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        TelemetryTop.JuniperNetworksSensors parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (TelemetryTop.JuniperNetworksSensors) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:JuniperNetworksSensors)
    }

    static {
      defaultInstance = new JuniperNetworksSensors(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:JuniperNetworksSensors)
  }

  public static final int TELEMETRY_OPTIONS_FIELD_NUMBER = 1024;
  /**
   * <code>extend .google.protobuf.FieldOptions { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      com.google.protobuf.DescriptorProtos.FieldOptions,
      TelemetryTop.TelemetryFieldOptions> telemetryOptions = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        TelemetryTop.TelemetryFieldOptions.class,
        TelemetryTop.TelemetryFieldOptions.getDefaultInstance());
  public static final int JUNIPERNETWORKS_FIELD_NUMBER = 2636;
  /**
   * <code>extend .EnterpriseSensors { ... }</code>
   *
   * <pre>
   * re-use IANA assigned numbers
   * </pre>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      TelemetryTop.EnterpriseSensors,
      TelemetryTop.JuniperNetworksSensors> juniperNetworks = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        TelemetryTop.JuniperNetworksSensors.class,
        TelemetryTop.JuniperNetworksSensors.getDefaultInstance());
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_TelemetryFieldOptions_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_TelemetryFieldOptions_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_TelemetryStream_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_TelemetryStream_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_IETFSensors_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_IETFSensors_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_EnterpriseSensors_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_EnterpriseSensors_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_JuniperNetworksSensors_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_JuniperNetworksSensors_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\023telemetry_top.proto\032 google/protobuf/d" +
      "escriptor.proto\"c\n\025TelemetryFieldOptions" +
      "\022\016\n\006is_key\030\001 \001(\010\022\024\n\014is_timestamp\030\002 \001(\010\022\022" +
      "\n\nis_counter\030\003 \001(\010\022\020\n\010is_gauge\030\004 \001(\010\"\252\002\n" +
      "\017TelemetryStream\022\030\n\tsystem_id\030\001 \002(\tB\005\202@\002" +
      "\010\001\022\033\n\014component_id\030\002 \001(\rB\005\202@\002\010\001\022\037\n\020sub_c" +
      "omponent_id\030\003 \001(\rB\005\202@\002\010\001\022\032\n\013sensor_name\030" +
      "\004 \001(\tB\005\202@\002\010\001\022\027\n\017sequence_number\030\005 \001(\r\022\030\n" +
      "\ttimestamp\030\006 \001(\004B\005\202@\002\020\001\022\025\n\rversion_major" +
      "\030\007 \001(\r\022\025\n\rversion_minor\030\010 \001(\r\022\032\n\004ietf\030d ",
      "\001(\0132\014.IETFSensors\022&\n\nenterprise\030e \001(\0132\022." +
      "EnterpriseSensors\"\027\n\013IETFSensors*\010\010\001\020\200\200\200" +
      "\200\002\"\035\n\021EnterpriseSensors*\010\010\001\020\200\200\200\200\002\"\"\n\026Jun" +
      "iperNetworksSensors*\010\010\001\020\200\200\200\200\002:Q\n\021telemet" +
      "ry_options\022\035.google.protobuf.FieldOption" +
      "s\030\200\010 \001(\0132\026.TelemetryFieldOptions:E\n\017juni" +
      "perNetworks\022\022.EnterpriseSensors\030\314\024 \001(\0132\027" +
      ".JuniperNetworksSensors"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.google.protobuf.DescriptorProtos.getDescriptor(),
        }, assigner);
    internal_static_TelemetryFieldOptions_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_TelemetryFieldOptions_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_TelemetryFieldOptions_descriptor,
        new java.lang.String[] { "IsKey", "IsTimestamp", "IsCounter", "IsGauge", });
    internal_static_TelemetryStream_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_TelemetryStream_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_TelemetryStream_descriptor,
        new java.lang.String[] { "SystemId", "ComponentId", "SubComponentId", "SensorName", "SequenceNumber", "Timestamp", "VersionMajor", "VersionMinor", "Ietf", "Enterprise", });
    internal_static_IETFSensors_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_IETFSensors_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_IETFSensors_descriptor,
        new java.lang.String[] { });
    internal_static_EnterpriseSensors_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_EnterpriseSensors_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_EnterpriseSensors_descriptor,
        new java.lang.String[] { });
    internal_static_JuniperNetworksSensors_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_JuniperNetworksSensors_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_JuniperNetworksSensors_descriptor,
        new java.lang.String[] { });
    telemetryOptions.internalInit(descriptor.getExtensions().get(0));
    juniperNetworks.internalInit(descriptor.getExtensions().get(1));
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    com.google.protobuf.DescriptorProtos.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
