/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.protocols.jti.adapter.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: firewall.proto

public final class FirewallOuterClass {
  private FirewallOuterClass() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(FirewallOuterClass.jnprFirewallExt);
  }
  public interface FirewallOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Firewall)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    java.util.List<FirewallOuterClass.FirewallStats> 
        getFirewallStatsList();
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    FirewallOuterClass.FirewallStats getFirewallStats(int index);
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    int getFirewallStatsCount();
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    java.util.List<? extends FirewallOuterClass.FirewallStatsOrBuilder> 
        getFirewallStatsOrBuilderList();
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    FirewallOuterClass.FirewallStatsOrBuilder getFirewallStatsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Firewall}
   *
   * <pre>
   * Top-level message
   * </pre>
   */
  public static final class Firewall extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Firewall)
      FirewallOrBuilder {
    // Use Firewall.newBuilder() to construct.
    private Firewall(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Firewall(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Firewall defaultInstance;
    public static Firewall getDefaultInstance() {
      return defaultInstance;
    }

    public Firewall getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Firewall(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                firewallStats_ = new java.util.ArrayList<FirewallOuterClass.FirewallStats>();
                mutable_bitField0_ |= 0x00000001;
              }
              firewallStats_.add(input.readMessage(FirewallOuterClass.FirewallStats.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          firewallStats_ = java.util.Collections.unmodifiableList(firewallStats_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_Firewall_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_Firewall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.Firewall.class, FirewallOuterClass.Firewall.Builder.class);
    }

    public static com.google.protobuf.Parser<Firewall> PARSER =
        new com.google.protobuf.AbstractParser<Firewall>() {
      public Firewall parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Firewall(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Firewall> getParserForType() {
      return PARSER;
    }

    public static final int FIREWALL_STATS_FIELD_NUMBER = 1;
    private java.util.List<FirewallOuterClass.FirewallStats> firewallStats_;
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    public java.util.List<FirewallOuterClass.FirewallStats> getFirewallStatsList() {
      return firewallStats_;
    }
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    public java.util.List<? extends FirewallOuterClass.FirewallStatsOrBuilder> 
        getFirewallStatsOrBuilderList() {
      return firewallStats_;
    }
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    public int getFirewallStatsCount() {
      return firewallStats_.size();
    }
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    public FirewallOuterClass.FirewallStats getFirewallStats(int index) {
      return firewallStats_.get(index);
    }
    /**
     * <code>repeated .FirewallStats firewall_stats = 1;</code>
     */
    public FirewallOuterClass.FirewallStatsOrBuilder getFirewallStatsOrBuilder(
        int index) {
      return firewallStats_.get(index);
    }

    private void initFields() {
      firewallStats_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getFirewallStatsCount(); i++) {
        if (!getFirewallStats(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < firewallStats_.size(); i++) {
        output.writeMessage(1, firewallStats_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < firewallStats_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, firewallStats_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.Firewall parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.Firewall parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.Firewall parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.Firewall parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.Firewall parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.Firewall parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.Firewall parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.Firewall parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.Firewall parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.Firewall parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.Firewall prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Firewall}
     *
     * <pre>
     * Top-level message
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Firewall)
        FirewallOuterClass.FirewallOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_Firewall_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_Firewall_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.Firewall.class, FirewallOuterClass.Firewall.Builder.class);
      }

      // Construct using FirewallOuterClass.Firewall.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getFirewallStatsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (firewallStatsBuilder_ == null) {
          firewallStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          firewallStatsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_Firewall_descriptor;
      }

      public FirewallOuterClass.Firewall getDefaultInstanceForType() {
        return FirewallOuterClass.Firewall.getDefaultInstance();
      }

      public FirewallOuterClass.Firewall build() {
        FirewallOuterClass.Firewall result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.Firewall buildPartial() {
        FirewallOuterClass.Firewall result = new FirewallOuterClass.Firewall(this);
        int from_bitField0_ = bitField0_;
        if (firewallStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            firewallStats_ = java.util.Collections.unmodifiableList(firewallStats_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.firewallStats_ = firewallStats_;
        } else {
          result.firewallStats_ = firewallStatsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.Firewall) {
          return mergeFrom((FirewallOuterClass.Firewall)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.Firewall other) {
        if (other == FirewallOuterClass.Firewall.getDefaultInstance()) return this;
        if (firewallStatsBuilder_ == null) {
          if (!other.firewallStats_.isEmpty()) {
            if (firewallStats_.isEmpty()) {
              firewallStats_ = other.firewallStats_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFirewallStatsIsMutable();
              firewallStats_.addAll(other.firewallStats_);
            }
            onChanged();
          }
        } else {
          if (!other.firewallStats_.isEmpty()) {
            if (firewallStatsBuilder_.isEmpty()) {
              firewallStatsBuilder_.dispose();
              firewallStatsBuilder_ = null;
              firewallStats_ = other.firewallStats_;
              bitField0_ = (bitField0_ & ~0x00000001);
              firewallStatsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFirewallStatsFieldBuilder() : null;
            } else {
              firewallStatsBuilder_.addAllMessages(other.firewallStats_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getFirewallStatsCount(); i++) {
          if (!getFirewallStats(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.Firewall parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.Firewall) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<FirewallOuterClass.FirewallStats> firewallStats_ =
        java.util.Collections.emptyList();
      private void ensureFirewallStatsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          firewallStats_ = new java.util.ArrayList<FirewallOuterClass.FirewallStats>(firewallStats_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.FirewallStats, FirewallOuterClass.FirewallStats.Builder, FirewallOuterClass.FirewallStatsOrBuilder> firewallStatsBuilder_;

      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public java.util.List<FirewallOuterClass.FirewallStats> getFirewallStatsList() {
        if (firewallStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(firewallStats_);
        } else {
          return firewallStatsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public int getFirewallStatsCount() {
        if (firewallStatsBuilder_ == null) {
          return firewallStats_.size();
        } else {
          return firewallStatsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public FirewallOuterClass.FirewallStats getFirewallStats(int index) {
        if (firewallStatsBuilder_ == null) {
          return firewallStats_.get(index);
        } else {
          return firewallStatsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder setFirewallStats(
          int index, FirewallOuterClass.FirewallStats value) {
        if (firewallStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFirewallStatsIsMutable();
          firewallStats_.set(index, value);
          onChanged();
        } else {
          firewallStatsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder setFirewallStats(
          int index, FirewallOuterClass.FirewallStats.Builder builderForValue) {
        if (firewallStatsBuilder_ == null) {
          ensureFirewallStatsIsMutable();
          firewallStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          firewallStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder addFirewallStats(FirewallOuterClass.FirewallStats value) {
        if (firewallStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFirewallStatsIsMutable();
          firewallStats_.add(value);
          onChanged();
        } else {
          firewallStatsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder addFirewallStats(
          int index, FirewallOuterClass.FirewallStats value) {
        if (firewallStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFirewallStatsIsMutable();
          firewallStats_.add(index, value);
          onChanged();
        } else {
          firewallStatsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder addFirewallStats(
          FirewallOuterClass.FirewallStats.Builder builderForValue) {
        if (firewallStatsBuilder_ == null) {
          ensureFirewallStatsIsMutable();
          firewallStats_.add(builderForValue.build());
          onChanged();
        } else {
          firewallStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder addFirewallStats(
          int index, FirewallOuterClass.FirewallStats.Builder builderForValue) {
        if (firewallStatsBuilder_ == null) {
          ensureFirewallStatsIsMutable();
          firewallStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          firewallStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder addAllFirewallStats(
          java.lang.Iterable<? extends FirewallOuterClass.FirewallStats> values) {
        if (firewallStatsBuilder_ == null) {
          ensureFirewallStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, firewallStats_);
          onChanged();
        } else {
          firewallStatsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder clearFirewallStats() {
        if (firewallStatsBuilder_ == null) {
          firewallStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          firewallStatsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public Builder removeFirewallStats(int index) {
        if (firewallStatsBuilder_ == null) {
          ensureFirewallStatsIsMutable();
          firewallStats_.remove(index);
          onChanged();
        } else {
          firewallStatsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public FirewallOuterClass.FirewallStats.Builder getFirewallStatsBuilder(
          int index) {
        return getFirewallStatsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public FirewallOuterClass.FirewallStatsOrBuilder getFirewallStatsOrBuilder(
          int index) {
        if (firewallStatsBuilder_ == null) {
          return firewallStats_.get(index);  } else {
          return firewallStatsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public java.util.List<? extends FirewallOuterClass.FirewallStatsOrBuilder> 
           getFirewallStatsOrBuilderList() {
        if (firewallStatsBuilder_ != null) {
          return firewallStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(firewallStats_);
        }
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public FirewallOuterClass.FirewallStats.Builder addFirewallStatsBuilder() {
        return getFirewallStatsFieldBuilder().addBuilder(
            FirewallOuterClass.FirewallStats.getDefaultInstance());
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public FirewallOuterClass.FirewallStats.Builder addFirewallStatsBuilder(
          int index) {
        return getFirewallStatsFieldBuilder().addBuilder(
            index, FirewallOuterClass.FirewallStats.getDefaultInstance());
      }
      /**
       * <code>repeated .FirewallStats firewall_stats = 1;</code>
       */
      public java.util.List<FirewallOuterClass.FirewallStats.Builder> 
           getFirewallStatsBuilderList() {
        return getFirewallStatsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.FirewallStats, FirewallOuterClass.FirewallStats.Builder, FirewallOuterClass.FirewallStatsOrBuilder> 
          getFirewallStatsFieldBuilder() {
        if (firewallStatsBuilder_ == null) {
          firewallStatsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              FirewallOuterClass.FirewallStats, FirewallOuterClass.FirewallStats.Builder, FirewallOuterClass.FirewallStatsOrBuilder>(
                  firewallStats_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          firewallStats_ = null;
        }
        return firewallStatsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Firewall)
    }

    static {
      defaultInstance = new Firewall(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Firewall)
  }

  public interface FirewallStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:FirewallStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string filter_name = 1;</code>
     */
    boolean hasFilterName();
    /**
     * <code>required string filter_name = 1;</code>
     */
    java.lang.String getFilterName();
    /**
     * <code>required string filter_name = 1;</code>
     */
    com.google.protobuf.ByteString
        getFilterNameBytes();

    /**
     * <code>optional uint64 timestamp = 2;</code>
     *
     * <pre>
     * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
     * last filter state change event such as filter add, filter change,
     * or counter clear.
     * </pre>
     */
    boolean hasTimestamp();
    /**
     * <code>optional uint64 timestamp = 2;</code>
     *
     * <pre>
     * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
     * last filter state change event such as filter add, filter change,
     * or counter clear.
     * </pre>
     */
    long getTimestamp();

    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    java.util.List<FirewallOuterClass.MemoryUsage> 
        getMemoryUsageList();
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    FirewallOuterClass.MemoryUsage getMemoryUsage(int index);
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    int getMemoryUsageCount();
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    java.util.List<? extends FirewallOuterClass.MemoryUsageOrBuilder> 
        getMemoryUsageOrBuilderList();
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    FirewallOuterClass.MemoryUsageOrBuilder getMemoryUsageOrBuilder(
        int index);

    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    java.util.List<FirewallOuterClass.CounterStats> 
        getCounterStatsList();
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    FirewallOuterClass.CounterStats getCounterStats(int index);
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    int getCounterStatsCount();
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    java.util.List<? extends FirewallOuterClass.CounterStatsOrBuilder> 
        getCounterStatsOrBuilderList();
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    FirewallOuterClass.CounterStatsOrBuilder getCounterStatsOrBuilder(
        int index);

    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    java.util.List<FirewallOuterClass.PolicerStats> 
        getPolicerStatsList();
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    FirewallOuterClass.PolicerStats getPolicerStats(int index);
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    int getPolicerStatsCount();
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    java.util.List<? extends FirewallOuterClass.PolicerStatsOrBuilder> 
        getPolicerStatsOrBuilderList();
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    FirewallOuterClass.PolicerStatsOrBuilder getPolicerStatsOrBuilder(
        int index);

    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    java.util.List<FirewallOuterClass.HierarchicalPolicerStats> 
        getHierarchicalPolicerStatsList();
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    FirewallOuterClass.HierarchicalPolicerStats getHierarchicalPolicerStats(int index);
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    int getHierarchicalPolicerStatsCount();
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    java.util.List<? extends FirewallOuterClass.HierarchicalPolicerStatsOrBuilder> 
        getHierarchicalPolicerStatsOrBuilderList();
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    FirewallOuterClass.HierarchicalPolicerStatsOrBuilder getHierarchicalPolicerStatsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code FirewallStats}
   *
   * <pre>
   * Firewall filter statistics
   * </pre>
   */
  public static final class FirewallStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:FirewallStats)
      FirewallStatsOrBuilder {
    // Use FirewallStats.newBuilder() to construct.
    private FirewallStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FirewallStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FirewallStats defaultInstance;
    public static FirewallStats getDefaultInstance() {
      return defaultInstance;
    }

    public FirewallStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FirewallStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              filterName_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              timestamp_ = input.readUInt64();
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                memoryUsage_ = new java.util.ArrayList<FirewallOuterClass.MemoryUsage>();
                mutable_bitField0_ |= 0x00000004;
              }
              memoryUsage_.add(input.readMessage(FirewallOuterClass.MemoryUsage.PARSER, extensionRegistry));
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                counterStats_ = new java.util.ArrayList<FirewallOuterClass.CounterStats>();
                mutable_bitField0_ |= 0x00000008;
              }
              counterStats_.add(input.readMessage(FirewallOuterClass.CounterStats.PARSER, extensionRegistry));
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                policerStats_ = new java.util.ArrayList<FirewallOuterClass.PolicerStats>();
                mutable_bitField0_ |= 0x00000010;
              }
              policerStats_.add(input.readMessage(FirewallOuterClass.PolicerStats.PARSER, extensionRegistry));
              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                hierarchicalPolicerStats_ = new java.util.ArrayList<FirewallOuterClass.HierarchicalPolicerStats>();
                mutable_bitField0_ |= 0x00000020;
              }
              hierarchicalPolicerStats_.add(input.readMessage(FirewallOuterClass.HierarchicalPolicerStats.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          memoryUsage_ = java.util.Collections.unmodifiableList(memoryUsage_);
        }
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          counterStats_ = java.util.Collections.unmodifiableList(counterStats_);
        }
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          policerStats_ = java.util.Collections.unmodifiableList(policerStats_);
        }
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          hierarchicalPolicerStats_ = java.util.Collections.unmodifiableList(hierarchicalPolicerStats_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_FirewallStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_FirewallStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.FirewallStats.class, FirewallOuterClass.FirewallStats.Builder.class);
    }

    public static com.google.protobuf.Parser<FirewallStats> PARSER =
        new com.google.protobuf.AbstractParser<FirewallStats>() {
      public FirewallStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FirewallStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FirewallStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int FILTER_NAME_FIELD_NUMBER = 1;
    private java.lang.Object filterName_;
    /**
     * <code>required string filter_name = 1;</code>
     */
    public boolean hasFilterName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string filter_name = 1;</code>
     */
    public java.lang.String getFilterName() {
      java.lang.Object ref = filterName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          filterName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string filter_name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getFilterNameBytes() {
      java.lang.Object ref = filterName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        filterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 2;
    private long timestamp_;
    /**
     * <code>optional uint64 timestamp = 2;</code>
     *
     * <pre>
     * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
     * last filter state change event such as filter add, filter change,
     * or counter clear.
     * </pre>
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 timestamp = 2;</code>
     *
     * <pre>
     * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
     * last filter state change event such as filter add, filter change,
     * or counter clear.
     * </pre>
     */
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int MEMORY_USAGE_FIELD_NUMBER = 3;
    private java.util.List<FirewallOuterClass.MemoryUsage> memoryUsage_;
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    public java.util.List<FirewallOuterClass.MemoryUsage> getMemoryUsageList() {
      return memoryUsage_;
    }
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    public java.util.List<? extends FirewallOuterClass.MemoryUsageOrBuilder> 
        getMemoryUsageOrBuilderList() {
      return memoryUsage_;
    }
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    public int getMemoryUsageCount() {
      return memoryUsage_.size();
    }
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    public FirewallOuterClass.MemoryUsage getMemoryUsage(int index) {
      return memoryUsage_.get(index);
    }
    /**
     * <code>repeated .MemoryUsage memory_usage = 3;</code>
     */
    public FirewallOuterClass.MemoryUsageOrBuilder getMemoryUsageOrBuilder(
        int index) {
      return memoryUsage_.get(index);
    }

    public static final int COUNTER_STATS_FIELD_NUMBER = 4;
    private java.util.List<FirewallOuterClass.CounterStats> counterStats_;
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    public java.util.List<FirewallOuterClass.CounterStats> getCounterStatsList() {
      return counterStats_;
    }
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    public java.util.List<? extends FirewallOuterClass.CounterStatsOrBuilder> 
        getCounterStatsOrBuilderList() {
      return counterStats_;
    }
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    public int getCounterStatsCount() {
      return counterStats_.size();
    }
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    public FirewallOuterClass.CounterStats getCounterStats(int index) {
      return counterStats_.get(index);
    }
    /**
     * <code>repeated .CounterStats counter_stats = 4;</code>
     */
    public FirewallOuterClass.CounterStatsOrBuilder getCounterStatsOrBuilder(
        int index) {
      return counterStats_.get(index);
    }

    public static final int POLICER_STATS_FIELD_NUMBER = 5;
    private java.util.List<FirewallOuterClass.PolicerStats> policerStats_;
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    public java.util.List<FirewallOuterClass.PolicerStats> getPolicerStatsList() {
      return policerStats_;
    }
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    public java.util.List<? extends FirewallOuterClass.PolicerStatsOrBuilder> 
        getPolicerStatsOrBuilderList() {
      return policerStats_;
    }
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    public int getPolicerStatsCount() {
      return policerStats_.size();
    }
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    public FirewallOuterClass.PolicerStats getPolicerStats(int index) {
      return policerStats_.get(index);
    }
    /**
     * <code>repeated .PolicerStats policer_stats = 5;</code>
     */
    public FirewallOuterClass.PolicerStatsOrBuilder getPolicerStatsOrBuilder(
        int index) {
      return policerStats_.get(index);
    }

    public static final int HIERARCHICAL_POLICER_STATS_FIELD_NUMBER = 6;
    private java.util.List<FirewallOuterClass.HierarchicalPolicerStats> hierarchicalPolicerStats_;
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    public java.util.List<FirewallOuterClass.HierarchicalPolicerStats> getHierarchicalPolicerStatsList() {
      return hierarchicalPolicerStats_;
    }
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    public java.util.List<? extends FirewallOuterClass.HierarchicalPolicerStatsOrBuilder> 
        getHierarchicalPolicerStatsOrBuilderList() {
      return hierarchicalPolicerStats_;
    }
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    public int getHierarchicalPolicerStatsCount() {
      return hierarchicalPolicerStats_.size();
    }
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    public FirewallOuterClass.HierarchicalPolicerStats getHierarchicalPolicerStats(int index) {
      return hierarchicalPolicerStats_.get(index);
    }
    /**
     * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
     */
    public FirewallOuterClass.HierarchicalPolicerStatsOrBuilder getHierarchicalPolicerStatsOrBuilder(
        int index) {
      return hierarchicalPolicerStats_.get(index);
    }

    private void initFields() {
      filterName_ = "";
      timestamp_ = 0L;
      memoryUsage_ = java.util.Collections.emptyList();
      counterStats_ = java.util.Collections.emptyList();
      policerStats_ = java.util.Collections.emptyList();
      hierarchicalPolicerStats_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasFilterName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getMemoryUsageCount(); i++) {
        if (!getMemoryUsage(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getCounterStatsCount(); i++) {
        if (!getCounterStats(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getPolicerStatsCount(); i++) {
        if (!getPolicerStats(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getHierarchicalPolicerStatsCount(); i++) {
        if (!getHierarchicalPolicerStats(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getFilterNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, timestamp_);
      }
      for (int i = 0; i < memoryUsage_.size(); i++) {
        output.writeMessage(3, memoryUsage_.get(i));
      }
      for (int i = 0; i < counterStats_.size(); i++) {
        output.writeMessage(4, counterStats_.get(i));
      }
      for (int i = 0; i < policerStats_.size(); i++) {
        output.writeMessage(5, policerStats_.get(i));
      }
      for (int i = 0; i < hierarchicalPolicerStats_.size(); i++) {
        output.writeMessage(6, hierarchicalPolicerStats_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getFilterNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, timestamp_);
      }
      for (int i = 0; i < memoryUsage_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, memoryUsage_.get(i));
      }
      for (int i = 0; i < counterStats_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, counterStats_.get(i));
      }
      for (int i = 0; i < policerStats_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, policerStats_.get(i));
      }
      for (int i = 0; i < hierarchicalPolicerStats_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, hierarchicalPolicerStats_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.FirewallStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.FirewallStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.FirewallStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.FirewallStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.FirewallStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code FirewallStats}
     *
     * <pre>
     * Firewall filter statistics
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:FirewallStats)
        FirewallOuterClass.FirewallStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_FirewallStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_FirewallStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.FirewallStats.class, FirewallOuterClass.FirewallStats.Builder.class);
      }

      // Construct using FirewallOuterClass.FirewallStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getMemoryUsageFieldBuilder();
          getCounterStatsFieldBuilder();
          getPolicerStatsFieldBuilder();
          getHierarchicalPolicerStatsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        filterName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        timestamp_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (memoryUsageBuilder_ == null) {
          memoryUsage_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          memoryUsageBuilder_.clear();
        }
        if (counterStatsBuilder_ == null) {
          counterStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          counterStatsBuilder_.clear();
        }
        if (policerStatsBuilder_ == null) {
          policerStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          policerStatsBuilder_.clear();
        }
        if (hierarchicalPolicerStatsBuilder_ == null) {
          hierarchicalPolicerStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          hierarchicalPolicerStatsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_FirewallStats_descriptor;
      }

      public FirewallOuterClass.FirewallStats getDefaultInstanceForType() {
        return FirewallOuterClass.FirewallStats.getDefaultInstance();
      }

      public FirewallOuterClass.FirewallStats build() {
        FirewallOuterClass.FirewallStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.FirewallStats buildPartial() {
        FirewallOuterClass.FirewallStats result = new FirewallOuterClass.FirewallStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.filterName_ = filterName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.timestamp_ = timestamp_;
        if (memoryUsageBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            memoryUsage_ = java.util.Collections.unmodifiableList(memoryUsage_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.memoryUsage_ = memoryUsage_;
        } else {
          result.memoryUsage_ = memoryUsageBuilder_.build();
        }
        if (counterStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            counterStats_ = java.util.Collections.unmodifiableList(counterStats_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.counterStats_ = counterStats_;
        } else {
          result.counterStats_ = counterStatsBuilder_.build();
        }
        if (policerStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            policerStats_ = java.util.Collections.unmodifiableList(policerStats_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.policerStats_ = policerStats_;
        } else {
          result.policerStats_ = policerStatsBuilder_.build();
        }
        if (hierarchicalPolicerStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            hierarchicalPolicerStats_ = java.util.Collections.unmodifiableList(hierarchicalPolicerStats_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.hierarchicalPolicerStats_ = hierarchicalPolicerStats_;
        } else {
          result.hierarchicalPolicerStats_ = hierarchicalPolicerStatsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.FirewallStats) {
          return mergeFrom((FirewallOuterClass.FirewallStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.FirewallStats other) {
        if (other == FirewallOuterClass.FirewallStats.getDefaultInstance()) return this;
        if (other.hasFilterName()) {
          bitField0_ |= 0x00000001;
          filterName_ = other.filterName_;
          onChanged();
        }
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        if (memoryUsageBuilder_ == null) {
          if (!other.memoryUsage_.isEmpty()) {
            if (memoryUsage_.isEmpty()) {
              memoryUsage_ = other.memoryUsage_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureMemoryUsageIsMutable();
              memoryUsage_.addAll(other.memoryUsage_);
            }
            onChanged();
          }
        } else {
          if (!other.memoryUsage_.isEmpty()) {
            if (memoryUsageBuilder_.isEmpty()) {
              memoryUsageBuilder_.dispose();
              memoryUsageBuilder_ = null;
              memoryUsage_ = other.memoryUsage_;
              bitField0_ = (bitField0_ & ~0x00000004);
              memoryUsageBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getMemoryUsageFieldBuilder() : null;
            } else {
              memoryUsageBuilder_.addAllMessages(other.memoryUsage_);
            }
          }
        }
        if (counterStatsBuilder_ == null) {
          if (!other.counterStats_.isEmpty()) {
            if (counterStats_.isEmpty()) {
              counterStats_ = other.counterStats_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureCounterStatsIsMutable();
              counterStats_.addAll(other.counterStats_);
            }
            onChanged();
          }
        } else {
          if (!other.counterStats_.isEmpty()) {
            if (counterStatsBuilder_.isEmpty()) {
              counterStatsBuilder_.dispose();
              counterStatsBuilder_ = null;
              counterStats_ = other.counterStats_;
              bitField0_ = (bitField0_ & ~0x00000008);
              counterStatsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getCounterStatsFieldBuilder() : null;
            } else {
              counterStatsBuilder_.addAllMessages(other.counterStats_);
            }
          }
        }
        if (policerStatsBuilder_ == null) {
          if (!other.policerStats_.isEmpty()) {
            if (policerStats_.isEmpty()) {
              policerStats_ = other.policerStats_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensurePolicerStatsIsMutable();
              policerStats_.addAll(other.policerStats_);
            }
            onChanged();
          }
        } else {
          if (!other.policerStats_.isEmpty()) {
            if (policerStatsBuilder_.isEmpty()) {
              policerStatsBuilder_.dispose();
              policerStatsBuilder_ = null;
              policerStats_ = other.policerStats_;
              bitField0_ = (bitField0_ & ~0x00000010);
              policerStatsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getPolicerStatsFieldBuilder() : null;
            } else {
              policerStatsBuilder_.addAllMessages(other.policerStats_);
            }
          }
        }
        if (hierarchicalPolicerStatsBuilder_ == null) {
          if (!other.hierarchicalPolicerStats_.isEmpty()) {
            if (hierarchicalPolicerStats_.isEmpty()) {
              hierarchicalPolicerStats_ = other.hierarchicalPolicerStats_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureHierarchicalPolicerStatsIsMutable();
              hierarchicalPolicerStats_.addAll(other.hierarchicalPolicerStats_);
            }
            onChanged();
          }
        } else {
          if (!other.hierarchicalPolicerStats_.isEmpty()) {
            if (hierarchicalPolicerStatsBuilder_.isEmpty()) {
              hierarchicalPolicerStatsBuilder_.dispose();
              hierarchicalPolicerStatsBuilder_ = null;
              hierarchicalPolicerStats_ = other.hierarchicalPolicerStats_;
              bitField0_ = (bitField0_ & ~0x00000020);
              hierarchicalPolicerStatsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getHierarchicalPolicerStatsFieldBuilder() : null;
            } else {
              hierarchicalPolicerStatsBuilder_.addAllMessages(other.hierarchicalPolicerStats_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasFilterName()) {
          
          return false;
        }
        for (int i = 0; i < getMemoryUsageCount(); i++) {
          if (!getMemoryUsage(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getCounterStatsCount(); i++) {
          if (!getCounterStats(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getPolicerStatsCount(); i++) {
          if (!getPolicerStats(i).isInitialized()) {
            
            return false;
          }
        }
        for (int i = 0; i < getHierarchicalPolicerStatsCount(); i++) {
          if (!getHierarchicalPolicerStats(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.FirewallStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.FirewallStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object filterName_ = "";
      /**
       * <code>required string filter_name = 1;</code>
       */
      public boolean hasFilterName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string filter_name = 1;</code>
       */
      public java.lang.String getFilterName() {
        java.lang.Object ref = filterName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            filterName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string filter_name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getFilterNameBytes() {
        java.lang.Object ref = filterName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          filterName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string filter_name = 1;</code>
       */
      public Builder setFilterName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        filterName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string filter_name = 1;</code>
       */
      public Builder clearFilterName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        filterName_ = getDefaultInstance().getFilterName();
        onChanged();
        return this;
      }
      /**
       * <code>required string filter_name = 1;</code>
       */
      public Builder setFilterNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        filterName_ = value;
        onChanged();
        return this;
      }

      private long timestamp_ ;
      /**
       * <code>optional uint64 timestamp = 2;</code>
       *
       * <pre>
       * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
       * last filter state change event such as filter add, filter change,
       * or counter clear.
       * </pre>
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 timestamp = 2;</code>
       *
       * <pre>
       * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
       * last filter state change event such as filter add, filter change,
       * or counter clear.
       * </pre>
       */
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <code>optional uint64 timestamp = 2;</code>
       *
       * <pre>
       * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
       * last filter state change event such as filter add, filter change,
       * or counter clear.
       * </pre>
       */
      public Builder setTimestamp(long value) {
        bitField0_ |= 0x00000002;
        timestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 timestamp = 2;</code>
       *
       * <pre>
       * The Unix timestamp (seconds since 00:00:00 UTC 1970-01-01) of
       * last filter state change event such as filter add, filter change,
       * or counter clear.
       * </pre>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000002);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<FirewallOuterClass.MemoryUsage> memoryUsage_ =
        java.util.Collections.emptyList();
      private void ensureMemoryUsageIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          memoryUsage_ = new java.util.ArrayList<FirewallOuterClass.MemoryUsage>(memoryUsage_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.MemoryUsage, FirewallOuterClass.MemoryUsage.Builder, FirewallOuterClass.MemoryUsageOrBuilder> memoryUsageBuilder_;

      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public java.util.List<FirewallOuterClass.MemoryUsage> getMemoryUsageList() {
        if (memoryUsageBuilder_ == null) {
          return java.util.Collections.unmodifiableList(memoryUsage_);
        } else {
          return memoryUsageBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public int getMemoryUsageCount() {
        if (memoryUsageBuilder_ == null) {
          return memoryUsage_.size();
        } else {
          return memoryUsageBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public FirewallOuterClass.MemoryUsage getMemoryUsage(int index) {
        if (memoryUsageBuilder_ == null) {
          return memoryUsage_.get(index);
        } else {
          return memoryUsageBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder setMemoryUsage(
          int index, FirewallOuterClass.MemoryUsage value) {
        if (memoryUsageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMemoryUsageIsMutable();
          memoryUsage_.set(index, value);
          onChanged();
        } else {
          memoryUsageBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder setMemoryUsage(
          int index, FirewallOuterClass.MemoryUsage.Builder builderForValue) {
        if (memoryUsageBuilder_ == null) {
          ensureMemoryUsageIsMutable();
          memoryUsage_.set(index, builderForValue.build());
          onChanged();
        } else {
          memoryUsageBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder addMemoryUsage(FirewallOuterClass.MemoryUsage value) {
        if (memoryUsageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMemoryUsageIsMutable();
          memoryUsage_.add(value);
          onChanged();
        } else {
          memoryUsageBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder addMemoryUsage(
          int index, FirewallOuterClass.MemoryUsage value) {
        if (memoryUsageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMemoryUsageIsMutable();
          memoryUsage_.add(index, value);
          onChanged();
        } else {
          memoryUsageBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder addMemoryUsage(
          FirewallOuterClass.MemoryUsage.Builder builderForValue) {
        if (memoryUsageBuilder_ == null) {
          ensureMemoryUsageIsMutable();
          memoryUsage_.add(builderForValue.build());
          onChanged();
        } else {
          memoryUsageBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder addMemoryUsage(
          int index, FirewallOuterClass.MemoryUsage.Builder builderForValue) {
        if (memoryUsageBuilder_ == null) {
          ensureMemoryUsageIsMutable();
          memoryUsage_.add(index, builderForValue.build());
          onChanged();
        } else {
          memoryUsageBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder addAllMemoryUsage(
          java.lang.Iterable<? extends FirewallOuterClass.MemoryUsage> values) {
        if (memoryUsageBuilder_ == null) {
          ensureMemoryUsageIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, memoryUsage_);
          onChanged();
        } else {
          memoryUsageBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder clearMemoryUsage() {
        if (memoryUsageBuilder_ == null) {
          memoryUsage_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          memoryUsageBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public Builder removeMemoryUsage(int index) {
        if (memoryUsageBuilder_ == null) {
          ensureMemoryUsageIsMutable();
          memoryUsage_.remove(index);
          onChanged();
        } else {
          memoryUsageBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public FirewallOuterClass.MemoryUsage.Builder getMemoryUsageBuilder(
          int index) {
        return getMemoryUsageFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public FirewallOuterClass.MemoryUsageOrBuilder getMemoryUsageOrBuilder(
          int index) {
        if (memoryUsageBuilder_ == null) {
          return memoryUsage_.get(index);  } else {
          return memoryUsageBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public java.util.List<? extends FirewallOuterClass.MemoryUsageOrBuilder> 
           getMemoryUsageOrBuilderList() {
        if (memoryUsageBuilder_ != null) {
          return memoryUsageBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(memoryUsage_);
        }
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public FirewallOuterClass.MemoryUsage.Builder addMemoryUsageBuilder() {
        return getMemoryUsageFieldBuilder().addBuilder(
            FirewallOuterClass.MemoryUsage.getDefaultInstance());
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public FirewallOuterClass.MemoryUsage.Builder addMemoryUsageBuilder(
          int index) {
        return getMemoryUsageFieldBuilder().addBuilder(
            index, FirewallOuterClass.MemoryUsage.getDefaultInstance());
      }
      /**
       * <code>repeated .MemoryUsage memory_usage = 3;</code>
       */
      public java.util.List<FirewallOuterClass.MemoryUsage.Builder> 
           getMemoryUsageBuilderList() {
        return getMemoryUsageFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.MemoryUsage, FirewallOuterClass.MemoryUsage.Builder, FirewallOuterClass.MemoryUsageOrBuilder> 
          getMemoryUsageFieldBuilder() {
        if (memoryUsageBuilder_ == null) {
          memoryUsageBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              FirewallOuterClass.MemoryUsage, FirewallOuterClass.MemoryUsage.Builder, FirewallOuterClass.MemoryUsageOrBuilder>(
                  memoryUsage_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          memoryUsage_ = null;
        }
        return memoryUsageBuilder_;
      }

      private java.util.List<FirewallOuterClass.CounterStats> counterStats_ =
        java.util.Collections.emptyList();
      private void ensureCounterStatsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          counterStats_ = new java.util.ArrayList<FirewallOuterClass.CounterStats>(counterStats_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.CounterStats, FirewallOuterClass.CounterStats.Builder, FirewallOuterClass.CounterStatsOrBuilder> counterStatsBuilder_;

      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public java.util.List<FirewallOuterClass.CounterStats> getCounterStatsList() {
        if (counterStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(counterStats_);
        } else {
          return counterStatsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public int getCounterStatsCount() {
        if (counterStatsBuilder_ == null) {
          return counterStats_.size();
        } else {
          return counterStatsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public FirewallOuterClass.CounterStats getCounterStats(int index) {
        if (counterStatsBuilder_ == null) {
          return counterStats_.get(index);
        } else {
          return counterStatsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder setCounterStats(
          int index, FirewallOuterClass.CounterStats value) {
        if (counterStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCounterStatsIsMutable();
          counterStats_.set(index, value);
          onChanged();
        } else {
          counterStatsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder setCounterStats(
          int index, FirewallOuterClass.CounterStats.Builder builderForValue) {
        if (counterStatsBuilder_ == null) {
          ensureCounterStatsIsMutable();
          counterStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          counterStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder addCounterStats(FirewallOuterClass.CounterStats value) {
        if (counterStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCounterStatsIsMutable();
          counterStats_.add(value);
          onChanged();
        } else {
          counterStatsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder addCounterStats(
          int index, FirewallOuterClass.CounterStats value) {
        if (counterStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCounterStatsIsMutable();
          counterStats_.add(index, value);
          onChanged();
        } else {
          counterStatsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder addCounterStats(
          FirewallOuterClass.CounterStats.Builder builderForValue) {
        if (counterStatsBuilder_ == null) {
          ensureCounterStatsIsMutable();
          counterStats_.add(builderForValue.build());
          onChanged();
        } else {
          counterStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder addCounterStats(
          int index, FirewallOuterClass.CounterStats.Builder builderForValue) {
        if (counterStatsBuilder_ == null) {
          ensureCounterStatsIsMutable();
          counterStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          counterStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder addAllCounterStats(
          java.lang.Iterable<? extends FirewallOuterClass.CounterStats> values) {
        if (counterStatsBuilder_ == null) {
          ensureCounterStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, counterStats_);
          onChanged();
        } else {
          counterStatsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder clearCounterStats() {
        if (counterStatsBuilder_ == null) {
          counterStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          counterStatsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public Builder removeCounterStats(int index) {
        if (counterStatsBuilder_ == null) {
          ensureCounterStatsIsMutable();
          counterStats_.remove(index);
          onChanged();
        } else {
          counterStatsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public FirewallOuterClass.CounterStats.Builder getCounterStatsBuilder(
          int index) {
        return getCounterStatsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public FirewallOuterClass.CounterStatsOrBuilder getCounterStatsOrBuilder(
          int index) {
        if (counterStatsBuilder_ == null) {
          return counterStats_.get(index);  } else {
          return counterStatsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public java.util.List<? extends FirewallOuterClass.CounterStatsOrBuilder> 
           getCounterStatsOrBuilderList() {
        if (counterStatsBuilder_ != null) {
          return counterStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(counterStats_);
        }
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public FirewallOuterClass.CounterStats.Builder addCounterStatsBuilder() {
        return getCounterStatsFieldBuilder().addBuilder(
            FirewallOuterClass.CounterStats.getDefaultInstance());
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public FirewallOuterClass.CounterStats.Builder addCounterStatsBuilder(
          int index) {
        return getCounterStatsFieldBuilder().addBuilder(
            index, FirewallOuterClass.CounterStats.getDefaultInstance());
      }
      /**
       * <code>repeated .CounterStats counter_stats = 4;</code>
       */
      public java.util.List<FirewallOuterClass.CounterStats.Builder> 
           getCounterStatsBuilderList() {
        return getCounterStatsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.CounterStats, FirewallOuterClass.CounterStats.Builder, FirewallOuterClass.CounterStatsOrBuilder> 
          getCounterStatsFieldBuilder() {
        if (counterStatsBuilder_ == null) {
          counterStatsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              FirewallOuterClass.CounterStats, FirewallOuterClass.CounterStats.Builder, FirewallOuterClass.CounterStatsOrBuilder>(
                  counterStats_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          counterStats_ = null;
        }
        return counterStatsBuilder_;
      }

      private java.util.List<FirewallOuterClass.PolicerStats> policerStats_ =
        java.util.Collections.emptyList();
      private void ensurePolicerStatsIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          policerStats_ = new java.util.ArrayList<FirewallOuterClass.PolicerStats>(policerStats_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.PolicerStats, FirewallOuterClass.PolicerStats.Builder, FirewallOuterClass.PolicerStatsOrBuilder> policerStatsBuilder_;

      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public java.util.List<FirewallOuterClass.PolicerStats> getPolicerStatsList() {
        if (policerStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(policerStats_);
        } else {
          return policerStatsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public int getPolicerStatsCount() {
        if (policerStatsBuilder_ == null) {
          return policerStats_.size();
        } else {
          return policerStatsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public FirewallOuterClass.PolicerStats getPolicerStats(int index) {
        if (policerStatsBuilder_ == null) {
          return policerStats_.get(index);
        } else {
          return policerStatsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder setPolicerStats(
          int index, FirewallOuterClass.PolicerStats value) {
        if (policerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePolicerStatsIsMutable();
          policerStats_.set(index, value);
          onChanged();
        } else {
          policerStatsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder setPolicerStats(
          int index, FirewallOuterClass.PolicerStats.Builder builderForValue) {
        if (policerStatsBuilder_ == null) {
          ensurePolicerStatsIsMutable();
          policerStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          policerStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder addPolicerStats(FirewallOuterClass.PolicerStats value) {
        if (policerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePolicerStatsIsMutable();
          policerStats_.add(value);
          onChanged();
        } else {
          policerStatsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder addPolicerStats(
          int index, FirewallOuterClass.PolicerStats value) {
        if (policerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePolicerStatsIsMutable();
          policerStats_.add(index, value);
          onChanged();
        } else {
          policerStatsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder addPolicerStats(
          FirewallOuterClass.PolicerStats.Builder builderForValue) {
        if (policerStatsBuilder_ == null) {
          ensurePolicerStatsIsMutable();
          policerStats_.add(builderForValue.build());
          onChanged();
        } else {
          policerStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder addPolicerStats(
          int index, FirewallOuterClass.PolicerStats.Builder builderForValue) {
        if (policerStatsBuilder_ == null) {
          ensurePolicerStatsIsMutable();
          policerStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          policerStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder addAllPolicerStats(
          java.lang.Iterable<? extends FirewallOuterClass.PolicerStats> values) {
        if (policerStatsBuilder_ == null) {
          ensurePolicerStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, policerStats_);
          onChanged();
        } else {
          policerStatsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder clearPolicerStats() {
        if (policerStatsBuilder_ == null) {
          policerStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          policerStatsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public Builder removePolicerStats(int index) {
        if (policerStatsBuilder_ == null) {
          ensurePolicerStatsIsMutable();
          policerStats_.remove(index);
          onChanged();
        } else {
          policerStatsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public FirewallOuterClass.PolicerStats.Builder getPolicerStatsBuilder(
          int index) {
        return getPolicerStatsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public FirewallOuterClass.PolicerStatsOrBuilder getPolicerStatsOrBuilder(
          int index) {
        if (policerStatsBuilder_ == null) {
          return policerStats_.get(index);  } else {
          return policerStatsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public java.util.List<? extends FirewallOuterClass.PolicerStatsOrBuilder> 
           getPolicerStatsOrBuilderList() {
        if (policerStatsBuilder_ != null) {
          return policerStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(policerStats_);
        }
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public FirewallOuterClass.PolicerStats.Builder addPolicerStatsBuilder() {
        return getPolicerStatsFieldBuilder().addBuilder(
            FirewallOuterClass.PolicerStats.getDefaultInstance());
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public FirewallOuterClass.PolicerStats.Builder addPolicerStatsBuilder(
          int index) {
        return getPolicerStatsFieldBuilder().addBuilder(
            index, FirewallOuterClass.PolicerStats.getDefaultInstance());
      }
      /**
       * <code>repeated .PolicerStats policer_stats = 5;</code>
       */
      public java.util.List<FirewallOuterClass.PolicerStats.Builder> 
           getPolicerStatsBuilderList() {
        return getPolicerStatsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.PolicerStats, FirewallOuterClass.PolicerStats.Builder, FirewallOuterClass.PolicerStatsOrBuilder> 
          getPolicerStatsFieldBuilder() {
        if (policerStatsBuilder_ == null) {
          policerStatsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              FirewallOuterClass.PolicerStats, FirewallOuterClass.PolicerStats.Builder, FirewallOuterClass.PolicerStatsOrBuilder>(
                  policerStats_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          policerStats_ = null;
        }
        return policerStatsBuilder_;
      }

      private java.util.List<FirewallOuterClass.HierarchicalPolicerStats> hierarchicalPolicerStats_ =
        java.util.Collections.emptyList();
      private void ensureHierarchicalPolicerStatsIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          hierarchicalPolicerStats_ = new java.util.ArrayList<FirewallOuterClass.HierarchicalPolicerStats>(hierarchicalPolicerStats_);
          bitField0_ |= 0x00000020;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.HierarchicalPolicerStats, FirewallOuterClass.HierarchicalPolicerStats.Builder, FirewallOuterClass.HierarchicalPolicerStatsOrBuilder> hierarchicalPolicerStatsBuilder_;

      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public java.util.List<FirewallOuterClass.HierarchicalPolicerStats> getHierarchicalPolicerStatsList() {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(hierarchicalPolicerStats_);
        } else {
          return hierarchicalPolicerStatsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public int getHierarchicalPolicerStatsCount() {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          return hierarchicalPolicerStats_.size();
        } else {
          return hierarchicalPolicerStatsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public FirewallOuterClass.HierarchicalPolicerStats getHierarchicalPolicerStats(int index) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          return hierarchicalPolicerStats_.get(index);
        } else {
          return hierarchicalPolicerStatsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder setHierarchicalPolicerStats(
          int index, FirewallOuterClass.HierarchicalPolicerStats value) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.set(index, value);
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder setHierarchicalPolicerStats(
          int index, FirewallOuterClass.HierarchicalPolicerStats.Builder builderForValue) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.set(index, builderForValue.build());
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder addHierarchicalPolicerStats(FirewallOuterClass.HierarchicalPolicerStats value) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.add(value);
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder addHierarchicalPolicerStats(
          int index, FirewallOuterClass.HierarchicalPolicerStats value) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.add(index, value);
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder addHierarchicalPolicerStats(
          FirewallOuterClass.HierarchicalPolicerStats.Builder builderForValue) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.add(builderForValue.build());
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder addHierarchicalPolicerStats(
          int index, FirewallOuterClass.HierarchicalPolicerStats.Builder builderForValue) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.add(index, builderForValue.build());
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder addAllHierarchicalPolicerStats(
          java.lang.Iterable<? extends FirewallOuterClass.HierarchicalPolicerStats> values) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          ensureHierarchicalPolicerStatsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, hierarchicalPolicerStats_);
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder clearHierarchicalPolicerStats() {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          hierarchicalPolicerStats_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public Builder removeHierarchicalPolicerStats(int index) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          ensureHierarchicalPolicerStatsIsMutable();
          hierarchicalPolicerStats_.remove(index);
          onChanged();
        } else {
          hierarchicalPolicerStatsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public FirewallOuterClass.HierarchicalPolicerStats.Builder getHierarchicalPolicerStatsBuilder(
          int index) {
        return getHierarchicalPolicerStatsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public FirewallOuterClass.HierarchicalPolicerStatsOrBuilder getHierarchicalPolicerStatsOrBuilder(
          int index) {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          return hierarchicalPolicerStats_.get(index);  } else {
          return hierarchicalPolicerStatsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public java.util.List<? extends FirewallOuterClass.HierarchicalPolicerStatsOrBuilder> 
           getHierarchicalPolicerStatsOrBuilderList() {
        if (hierarchicalPolicerStatsBuilder_ != null) {
          return hierarchicalPolicerStatsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(hierarchicalPolicerStats_);
        }
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public FirewallOuterClass.HierarchicalPolicerStats.Builder addHierarchicalPolicerStatsBuilder() {
        return getHierarchicalPolicerStatsFieldBuilder().addBuilder(
            FirewallOuterClass.HierarchicalPolicerStats.getDefaultInstance());
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public FirewallOuterClass.HierarchicalPolicerStats.Builder addHierarchicalPolicerStatsBuilder(
          int index) {
        return getHierarchicalPolicerStatsFieldBuilder().addBuilder(
            index, FirewallOuterClass.HierarchicalPolicerStats.getDefaultInstance());
      }
      /**
       * <code>repeated .HierarchicalPolicerStats hierarchical_policer_stats = 6;</code>
       */
      public java.util.List<FirewallOuterClass.HierarchicalPolicerStats.Builder> 
           getHierarchicalPolicerStatsBuilderList() {
        return getHierarchicalPolicerStatsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          FirewallOuterClass.HierarchicalPolicerStats, FirewallOuterClass.HierarchicalPolicerStats.Builder, FirewallOuterClass.HierarchicalPolicerStatsOrBuilder> 
          getHierarchicalPolicerStatsFieldBuilder() {
        if (hierarchicalPolicerStatsBuilder_ == null) {
          hierarchicalPolicerStatsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              FirewallOuterClass.HierarchicalPolicerStats, FirewallOuterClass.HierarchicalPolicerStats.Builder, FirewallOuterClass.HierarchicalPolicerStatsOrBuilder>(
                  hierarchicalPolicerStats_,
                  ((bitField0_ & 0x00000020) == 0x00000020),
                  getParentForChildren(),
                  isClean());
          hierarchicalPolicerStats_ = null;
        }
        return hierarchicalPolicerStatsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:FirewallStats)
    }

    static {
      defaultInstance = new FirewallStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:FirewallStats)
  }

  public interface MemoryUsageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:MemoryUsage)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * The router has typically several types of memories (e.g. CPU's memory,
     * ASIC's forwarding memories) in which the firewall object is written.
     * This field indicates the name of the memory subsystem whose utilization
     * is being reported.
     * </pre>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * The router has typically several types of memories (e.g. CPU's memory,
     * ASIC's forwarding memories) in which the firewall object is written.
     * This field indicates the name of the memory subsystem whose utilization
     * is being reported.
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * The router has typically several types of memories (e.g. CPU's memory,
     * ASIC's forwarding memories) in which the firewall object is written.
     * This field indicates the name of the memory subsystem whose utilization
     * is being reported.
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional uint64 allocated = 2;</code>
     *
     * <pre>
     * The amount of the memory allocated in bytes to the filter
     * </pre>
     */
    boolean hasAllocated();
    /**
     * <code>optional uint64 allocated = 2;</code>
     *
     * <pre>
     * The amount of the memory allocated in bytes to the filter
     * </pre>
     */
    long getAllocated();
  }
  /**
   * Protobuf type {@code MemoryUsage}
   *
   * <pre>
   * Memory usage
   * </pre>
   */
  public static final class MemoryUsage extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:MemoryUsage)
      MemoryUsageOrBuilder {
    // Use MemoryUsage.newBuilder() to construct.
    private MemoryUsage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private MemoryUsage(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final MemoryUsage defaultInstance;
    public static MemoryUsage getDefaultInstance() {
      return defaultInstance;
    }

    public MemoryUsage getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private MemoryUsage(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              allocated_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_MemoryUsage_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_MemoryUsage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.MemoryUsage.class, FirewallOuterClass.MemoryUsage.Builder.class);
    }

    public static com.google.protobuf.Parser<MemoryUsage> PARSER =
        new com.google.protobuf.AbstractParser<MemoryUsage>() {
      public MemoryUsage parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new MemoryUsage(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<MemoryUsage> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * The router has typically several types of memories (e.g. CPU's memory,
     * ASIC's forwarding memories) in which the firewall object is written.
     * This field indicates the name of the memory subsystem whose utilization
     * is being reported.
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * The router has typically several types of memories (e.g. CPU's memory,
     * ASIC's forwarding memories) in which the firewall object is written.
     * This field indicates the name of the memory subsystem whose utilization
     * is being reported.
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * The router has typically several types of memories (e.g. CPU's memory,
     * ASIC's forwarding memories) in which the firewall object is written.
     * This field indicates the name of the memory subsystem whose utilization
     * is being reported.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOCATED_FIELD_NUMBER = 2;
    private long allocated_;
    /**
     * <code>optional uint64 allocated = 2;</code>
     *
     * <pre>
     * The amount of the memory allocated in bytes to the filter
     * </pre>
     */
    public boolean hasAllocated() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 allocated = 2;</code>
     *
     * <pre>
     * The amount of the memory allocated in bytes to the filter
     * </pre>
     */
    public long getAllocated() {
      return allocated_;
    }

    private void initFields() {
      name_ = "";
      allocated_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, allocated_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, allocated_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.MemoryUsage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.MemoryUsage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.MemoryUsage parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.MemoryUsage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.MemoryUsage prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code MemoryUsage}
     *
     * <pre>
     * Memory usage
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:MemoryUsage)
        FirewallOuterClass.MemoryUsageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_MemoryUsage_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_MemoryUsage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.MemoryUsage.class, FirewallOuterClass.MemoryUsage.Builder.class);
      }

      // Construct using FirewallOuterClass.MemoryUsage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        allocated_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_MemoryUsage_descriptor;
      }

      public FirewallOuterClass.MemoryUsage getDefaultInstanceForType() {
        return FirewallOuterClass.MemoryUsage.getDefaultInstance();
      }

      public FirewallOuterClass.MemoryUsage build() {
        FirewallOuterClass.MemoryUsage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.MemoryUsage buildPartial() {
        FirewallOuterClass.MemoryUsage result = new FirewallOuterClass.MemoryUsage(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.allocated_ = allocated_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.MemoryUsage) {
          return mergeFrom((FirewallOuterClass.MemoryUsage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.MemoryUsage other) {
        if (other == FirewallOuterClass.MemoryUsage.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasAllocated()) {
          setAllocated(other.getAllocated());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.MemoryUsage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.MemoryUsage) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * The router has typically several types of memories (e.g. CPU's memory,
       * ASIC's forwarding memories) in which the firewall object is written.
       * This field indicates the name of the memory subsystem whose utilization
       * is being reported.
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * The router has typically several types of memories (e.g. CPU's memory,
       * ASIC's forwarding memories) in which the firewall object is written.
       * This field indicates the name of the memory subsystem whose utilization
       * is being reported.
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * The router has typically several types of memories (e.g. CPU's memory,
       * ASIC's forwarding memories) in which the firewall object is written.
       * This field indicates the name of the memory subsystem whose utilization
       * is being reported.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * The router has typically several types of memories (e.g. CPU's memory,
       * ASIC's forwarding memories) in which the firewall object is written.
       * This field indicates the name of the memory subsystem whose utilization
       * is being reported.
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * The router has typically several types of memories (e.g. CPU's memory,
       * ASIC's forwarding memories) in which the firewall object is written.
       * This field indicates the name of the memory subsystem whose utilization
       * is being reported.
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * The router has typically several types of memories (e.g. CPU's memory,
       * ASIC's forwarding memories) in which the firewall object is written.
       * This field indicates the name of the memory subsystem whose utilization
       * is being reported.
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private long allocated_ ;
      /**
       * <code>optional uint64 allocated = 2;</code>
       *
       * <pre>
       * The amount of the memory allocated in bytes to the filter
       * </pre>
       */
      public boolean hasAllocated() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 allocated = 2;</code>
       *
       * <pre>
       * The amount of the memory allocated in bytes to the filter
       * </pre>
       */
      public long getAllocated() {
        return allocated_;
      }
      /**
       * <code>optional uint64 allocated = 2;</code>
       *
       * <pre>
       * The amount of the memory allocated in bytes to the filter
       * </pre>
       */
      public Builder setAllocated(long value) {
        bitField0_ |= 0x00000002;
        allocated_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 allocated = 2;</code>
       *
       * <pre>
       * The amount of the memory allocated in bytes to the filter
       * </pre>
       */
      public Builder clearAllocated() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allocated_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:MemoryUsage)
    }

    static {
      defaultInstance = new MemoryUsage(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:MemoryUsage)
  }

  public interface CounterStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CounterStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Counter name
     * </pre>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Counter name
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Counter name
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * The total number of packets seen by the counter
     * </pre>
     */
    boolean hasPackets();
    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * The total number of packets seen by the counter
     * </pre>
     */
    long getPackets();

    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes seen by the counter
     * </pre>
     */
    boolean hasBytes();
    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes seen by the counter
     * </pre>
     */
    long getBytes();
  }
  /**
   * Protobuf type {@code CounterStats}
   *
   * <pre>
   * Counter statistics
   * </pre>
   */
  public static final class CounterStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CounterStats)
      CounterStatsOrBuilder {
    // Use CounterStats.newBuilder() to construct.
    private CounterStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CounterStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CounterStats defaultInstance;
    public static CounterStats getDefaultInstance() {
      return defaultInstance;
    }

    public CounterStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CounterStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              packets_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              bytes_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_CounterStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_CounterStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.CounterStats.class, FirewallOuterClass.CounterStats.Builder.class);
    }

    public static com.google.protobuf.Parser<CounterStats> PARSER =
        new com.google.protobuf.AbstractParser<CounterStats>() {
      public CounterStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CounterStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CounterStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Counter name
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Counter name
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Counter name
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PACKETS_FIELD_NUMBER = 2;
    private long packets_;
    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * The total number of packets seen by the counter
     * </pre>
     */
    public boolean hasPackets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 packets = 2;</code>
     *
     * <pre>
     * The total number of packets seen by the counter
     * </pre>
     */
    public long getPackets() {
      return packets_;
    }

    public static final int BYTES_FIELD_NUMBER = 3;
    private long bytes_;
    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes seen by the counter
     * </pre>
     */
    public boolean hasBytes() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes seen by the counter
     * </pre>
     */
    public long getBytes() {
      return bytes_;
    }

    private void initFields() {
      name_ = "";
      packets_ = 0L;
      bytes_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, packets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, bytes_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, packets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, bytes_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.CounterStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.CounterStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.CounterStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.CounterStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.CounterStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.CounterStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.CounterStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.CounterStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.CounterStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.CounterStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.CounterStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CounterStats}
     *
     * <pre>
     * Counter statistics
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CounterStats)
        FirewallOuterClass.CounterStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_CounterStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_CounterStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.CounterStats.class, FirewallOuterClass.CounterStats.Builder.class);
      }

      // Construct using FirewallOuterClass.CounterStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        packets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        bytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_CounterStats_descriptor;
      }

      public FirewallOuterClass.CounterStats getDefaultInstanceForType() {
        return FirewallOuterClass.CounterStats.getDefaultInstance();
      }

      public FirewallOuterClass.CounterStats build() {
        FirewallOuterClass.CounterStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.CounterStats buildPartial() {
        FirewallOuterClass.CounterStats result = new FirewallOuterClass.CounterStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.packets_ = packets_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.bytes_ = bytes_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.CounterStats) {
          return mergeFrom((FirewallOuterClass.CounterStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.CounterStats other) {
        if (other == FirewallOuterClass.CounterStats.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasPackets()) {
          setPackets(other.getPackets());
        }
        if (other.hasBytes()) {
          setBytes(other.getBytes());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.CounterStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.CounterStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Counter name
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Counter name
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Counter name
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Counter name
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Counter name
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Counter name
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private long packets_ ;
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * The total number of packets seen by the counter
       * </pre>
       */
      public boolean hasPackets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * The total number of packets seen by the counter
       * </pre>
       */
      public long getPackets() {
        return packets_;
      }
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * The total number of packets seen by the counter
       * </pre>
       */
      public Builder setPackets(long value) {
        bitField0_ |= 0x00000002;
        packets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 packets = 2;</code>
       *
       * <pre>
       * The total number of packets seen by the counter
       * </pre>
       */
      public Builder clearPackets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        packets_ = 0L;
        onChanged();
        return this;
      }

      private long bytes_ ;
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes seen by the counter
       * </pre>
       */
      public boolean hasBytes() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes seen by the counter
       * </pre>
       */
      public long getBytes() {
        return bytes_;
      }
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes seen by the counter
       * </pre>
       */
      public Builder setBytes(long value) {
        bitField0_ |= 0x00000004;
        bytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes seen by the counter
       * </pre>
       */
      public Builder clearBytes() {
        bitField0_ = (bitField0_ & ~0x00000004);
        bytes_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:CounterStats)
    }

    static {
      defaultInstance = new CounterStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:CounterStats)
  }

  public interface PolicerStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PolicerStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Policer instance name
     * </pre>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Policer instance name
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Policer instance name
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional uint64 out_of_spec_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by the policer
     * </pre>
     */
    boolean hasOutOfSpecPackets();
    /**
     * <code>optional uint64 out_of_spec_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by the policer
     * </pre>
     */
    long getOutOfSpecPackets();

    /**
     * <code>optional uint64 out_of_spec_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by the policer
     * </pre>
     */
    boolean hasOutOfSpecBytes();
    /**
     * <code>optional uint64 out_of_spec_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by the policer
     * </pre>
     */
    long getOutOfSpecBytes();

    /**
     * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
     *
     * <pre>
     * Additional statistics when enhanced policer statistics are available
     * </pre>
     */
    boolean hasExtendedPolicerStats();
    /**
     * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
     *
     * <pre>
     * Additional statistics when enhanced policer statistics are available
     * </pre>
     */
    FirewallOuterClass.ExtendedPolicerStats getExtendedPolicerStats();
    /**
     * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
     *
     * <pre>
     * Additional statistics when enhanced policer statistics are available
     * </pre>
     */
    FirewallOuterClass.ExtendedPolicerStatsOrBuilder getExtendedPolicerStatsOrBuilder();
  }
  /**
   * Protobuf type {@code PolicerStats}
   *
   * <pre>
   * Policer statistics
   * </pre>
   */
  public static final class PolicerStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:PolicerStats)
      PolicerStatsOrBuilder {
    // Use PolicerStats.newBuilder() to construct.
    private PolicerStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private PolicerStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final PolicerStats defaultInstance;
    public static PolicerStats getDefaultInstance() {
      return defaultInstance;
    }

    public PolicerStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private PolicerStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              outOfSpecPackets_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              outOfSpecBytes_ = input.readUInt64();
              break;
            }
            case 34: {
              FirewallOuterClass.ExtendedPolicerStats.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = extendedPolicerStats_.toBuilder();
              }
              extendedPolicerStats_ = input.readMessage(FirewallOuterClass.ExtendedPolicerStats.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(extendedPolicerStats_);
                extendedPolicerStats_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_PolicerStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_PolicerStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.PolicerStats.class, FirewallOuterClass.PolicerStats.Builder.class);
    }

    public static com.google.protobuf.Parser<PolicerStats> PARSER =
        new com.google.protobuf.AbstractParser<PolicerStats>() {
      public PolicerStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PolicerStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<PolicerStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Policer instance name
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Policer instance name
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Policer instance name
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OUT_OF_SPEC_PACKETS_FIELD_NUMBER = 2;
    private long outOfSpecPackets_;
    /**
     * <code>optional uint64 out_of_spec_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by the policer
     * </pre>
     */
    public boolean hasOutOfSpecPackets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 out_of_spec_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by the policer
     * </pre>
     */
    public long getOutOfSpecPackets() {
      return outOfSpecPackets_;
    }

    public static final int OUT_OF_SPEC_BYTES_FIELD_NUMBER = 3;
    private long outOfSpecBytes_;
    /**
     * <code>optional uint64 out_of_spec_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by the policer
     * </pre>
     */
    public boolean hasOutOfSpecBytes() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 out_of_spec_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by the policer
     * </pre>
     */
    public long getOutOfSpecBytes() {
      return outOfSpecBytes_;
    }

    public static final int EXTENDED_POLICER_STATS_FIELD_NUMBER = 4;
    private FirewallOuterClass.ExtendedPolicerStats extendedPolicerStats_;
    /**
     * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
     *
     * <pre>
     * Additional statistics when enhanced policer statistics are available
     * </pre>
     */
    public boolean hasExtendedPolicerStats() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
     *
     * <pre>
     * Additional statistics when enhanced policer statistics are available
     * </pre>
     */
    public FirewallOuterClass.ExtendedPolicerStats getExtendedPolicerStats() {
      return extendedPolicerStats_;
    }
    /**
     * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
     *
     * <pre>
     * Additional statistics when enhanced policer statistics are available
     * </pre>
     */
    public FirewallOuterClass.ExtendedPolicerStatsOrBuilder getExtendedPolicerStatsOrBuilder() {
      return extendedPolicerStats_;
    }

    private void initFields() {
      name_ = "";
      outOfSpecPackets_ = 0L;
      outOfSpecBytes_ = 0L;
      extendedPolicerStats_ = FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, outOfSpecPackets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, outOfSpecBytes_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, extendedPolicerStats_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, outOfSpecPackets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, outOfSpecBytes_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, extendedPolicerStats_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.PolicerStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.PolicerStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.PolicerStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.PolicerStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.PolicerStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PolicerStats}
     *
     * <pre>
     * Policer statistics
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PolicerStats)
        FirewallOuterClass.PolicerStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_PolicerStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_PolicerStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.PolicerStats.class, FirewallOuterClass.PolicerStats.Builder.class);
      }

      // Construct using FirewallOuterClass.PolicerStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getExtendedPolicerStatsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        outOfSpecPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        outOfSpecBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        if (extendedPolicerStatsBuilder_ == null) {
          extendedPolicerStats_ = FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance();
        } else {
          extendedPolicerStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_PolicerStats_descriptor;
      }

      public FirewallOuterClass.PolicerStats getDefaultInstanceForType() {
        return FirewallOuterClass.PolicerStats.getDefaultInstance();
      }

      public FirewallOuterClass.PolicerStats build() {
        FirewallOuterClass.PolicerStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.PolicerStats buildPartial() {
        FirewallOuterClass.PolicerStats result = new FirewallOuterClass.PolicerStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.outOfSpecPackets_ = outOfSpecPackets_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.outOfSpecBytes_ = outOfSpecBytes_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (extendedPolicerStatsBuilder_ == null) {
          result.extendedPolicerStats_ = extendedPolicerStats_;
        } else {
          result.extendedPolicerStats_ = extendedPolicerStatsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.PolicerStats) {
          return mergeFrom((FirewallOuterClass.PolicerStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.PolicerStats other) {
        if (other == FirewallOuterClass.PolicerStats.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasOutOfSpecPackets()) {
          setOutOfSpecPackets(other.getOutOfSpecPackets());
        }
        if (other.hasOutOfSpecBytes()) {
          setOutOfSpecBytes(other.getOutOfSpecBytes());
        }
        if (other.hasExtendedPolicerStats()) {
          mergeExtendedPolicerStats(other.getExtendedPolicerStats());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.PolicerStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.PolicerStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Policer instance name
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Policer instance name
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Policer instance name
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Policer instance name
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Policer instance name
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Policer instance name
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private long outOfSpecPackets_ ;
      /**
       * <code>optional uint64 out_of_spec_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by the policer
       * </pre>
       */
      public boolean hasOutOfSpecPackets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 out_of_spec_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by the policer
       * </pre>
       */
      public long getOutOfSpecPackets() {
        return outOfSpecPackets_;
      }
      /**
       * <code>optional uint64 out_of_spec_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by the policer
       * </pre>
       */
      public Builder setOutOfSpecPackets(long value) {
        bitField0_ |= 0x00000002;
        outOfSpecPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 out_of_spec_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by the policer
       * </pre>
       */
      public Builder clearOutOfSpecPackets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        outOfSpecPackets_ = 0L;
        onChanged();
        return this;
      }

      private long outOfSpecBytes_ ;
      /**
       * <code>optional uint64 out_of_spec_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by the policer
       * </pre>
       */
      public boolean hasOutOfSpecBytes() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 out_of_spec_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by the policer
       * </pre>
       */
      public long getOutOfSpecBytes() {
        return outOfSpecBytes_;
      }
      /**
       * <code>optional uint64 out_of_spec_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by the policer
       * </pre>
       */
      public Builder setOutOfSpecBytes(long value) {
        bitField0_ |= 0x00000004;
        outOfSpecBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 out_of_spec_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by the policer
       * </pre>
       */
      public Builder clearOutOfSpecBytes() {
        bitField0_ = (bitField0_ & ~0x00000004);
        outOfSpecBytes_ = 0L;
        onChanged();
        return this;
      }

      private FirewallOuterClass.ExtendedPolicerStats extendedPolicerStats_ = FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          FirewallOuterClass.ExtendedPolicerStats, FirewallOuterClass.ExtendedPolicerStats.Builder, FirewallOuterClass.ExtendedPolicerStatsOrBuilder> extendedPolicerStatsBuilder_;
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public boolean hasExtendedPolicerStats() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public FirewallOuterClass.ExtendedPolicerStats getExtendedPolicerStats() {
        if (extendedPolicerStatsBuilder_ == null) {
          return extendedPolicerStats_;
        } else {
          return extendedPolicerStatsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public Builder setExtendedPolicerStats(FirewallOuterClass.ExtendedPolicerStats value) {
        if (extendedPolicerStatsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          extendedPolicerStats_ = value;
          onChanged();
        } else {
          extendedPolicerStatsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public Builder setExtendedPolicerStats(
          FirewallOuterClass.ExtendedPolicerStats.Builder builderForValue) {
        if (extendedPolicerStatsBuilder_ == null) {
          extendedPolicerStats_ = builderForValue.build();
          onChanged();
        } else {
          extendedPolicerStatsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public Builder mergeExtendedPolicerStats(FirewallOuterClass.ExtendedPolicerStats value) {
        if (extendedPolicerStatsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              extendedPolicerStats_ != FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance()) {
            extendedPolicerStats_ =
              FirewallOuterClass.ExtendedPolicerStats.newBuilder(extendedPolicerStats_).mergeFrom(value).buildPartial();
          } else {
            extendedPolicerStats_ = value;
          }
          onChanged();
        } else {
          extendedPolicerStatsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public Builder clearExtendedPolicerStats() {
        if (extendedPolicerStatsBuilder_ == null) {
          extendedPolicerStats_ = FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance();
          onChanged();
        } else {
          extendedPolicerStatsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public FirewallOuterClass.ExtendedPolicerStats.Builder getExtendedPolicerStatsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getExtendedPolicerStatsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      public FirewallOuterClass.ExtendedPolicerStatsOrBuilder getExtendedPolicerStatsOrBuilder() {
        if (extendedPolicerStatsBuilder_ != null) {
          return extendedPolicerStatsBuilder_.getMessageOrBuilder();
        } else {
          return extendedPolicerStats_;
        }
      }
      /**
       * <code>optional .ExtendedPolicerStats extended_policer_stats = 4;</code>
       *
       * <pre>
       * Additional statistics when enhanced policer statistics are available
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          FirewallOuterClass.ExtendedPolicerStats, FirewallOuterClass.ExtendedPolicerStats.Builder, FirewallOuterClass.ExtendedPolicerStatsOrBuilder> 
          getExtendedPolicerStatsFieldBuilder() {
        if (extendedPolicerStatsBuilder_ == null) {
          extendedPolicerStatsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              FirewallOuterClass.ExtendedPolicerStats, FirewallOuterClass.ExtendedPolicerStats.Builder, FirewallOuterClass.ExtendedPolicerStatsOrBuilder>(
                  getExtendedPolicerStats(),
                  getParentForChildren(),
                  isClean());
          extendedPolicerStats_ = null;
        }
        return extendedPolicerStatsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:PolicerStats)
    }

    static {
      defaultInstance = new PolicerStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:PolicerStats)
  }

  public interface ExtendedPolicerStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ExtendedPolicerStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional uint64 offered_packets = 1;</code>
     *
     * <pre>
     * The total number of packets subjected to policing
     * </pre>
     */
    boolean hasOfferedPackets();
    /**
     * <code>optional uint64 offered_packets = 1;</code>
     *
     * <pre>
     * The total number of packets subjected to policing
     * </pre>
     */
    long getOfferedPackets();

    /**
     * <code>optional uint64 offered_bytes = 2;</code>
     *
     * <pre>
     * The total number of bytes subjected to policing
     * </pre>
     */
    boolean hasOfferedBytes();
    /**
     * <code>optional uint64 offered_bytes = 2;</code>
     *
     * <pre>
     * The total number of bytes subjected to policing
     * </pre>
     */
    long getOfferedBytes();

    /**
     * <code>optional uint64 transmitted_packets = 3;</code>
     *
     * <pre>
     * The total number of packets not discarded by the policer
     * </pre>
     */
    boolean hasTransmittedPackets();
    /**
     * <code>optional uint64 transmitted_packets = 3;</code>
     *
     * <pre>
     * The total number of packets not discarded by the policer
     * </pre>
     */
    long getTransmittedPackets();

    /**
     * <code>optional uint64 transmitted_bytes = 4;</code>
     *
     * <pre>
     * The total number of bytes not discarded by the policer
     * </pre>
     */
    boolean hasTransmittedBytes();
    /**
     * <code>optional uint64 transmitted_bytes = 4;</code>
     *
     * <pre>
     * The total number of bytes not discarded by the policer
     * </pre>
     */
    long getTransmittedBytes();
  }
  /**
   * Protobuf type {@code ExtendedPolicerStats}
   *
   * <pre>
   * Extended policer statistics when enhanced policer statistics are available
   * </pre>
   */
  public static final class ExtendedPolicerStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ExtendedPolicerStats)
      ExtendedPolicerStatsOrBuilder {
    // Use ExtendedPolicerStats.newBuilder() to construct.
    private ExtendedPolicerStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ExtendedPolicerStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ExtendedPolicerStats defaultInstance;
    public static ExtendedPolicerStats getDefaultInstance() {
      return defaultInstance;
    }

    public ExtendedPolicerStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ExtendedPolicerStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              offeredPackets_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              offeredBytes_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              transmittedPackets_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              transmittedBytes_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_ExtendedPolicerStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_ExtendedPolicerStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.ExtendedPolicerStats.class, FirewallOuterClass.ExtendedPolicerStats.Builder.class);
    }

    public static com.google.protobuf.Parser<ExtendedPolicerStats> PARSER =
        new com.google.protobuf.AbstractParser<ExtendedPolicerStats>() {
      public ExtendedPolicerStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ExtendedPolicerStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ExtendedPolicerStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int OFFERED_PACKETS_FIELD_NUMBER = 1;
    private long offeredPackets_;
    /**
     * <code>optional uint64 offered_packets = 1;</code>
     *
     * <pre>
     * The total number of packets subjected to policing
     * </pre>
     */
    public boolean hasOfferedPackets() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional uint64 offered_packets = 1;</code>
     *
     * <pre>
     * The total number of packets subjected to policing
     * </pre>
     */
    public long getOfferedPackets() {
      return offeredPackets_;
    }

    public static final int OFFERED_BYTES_FIELD_NUMBER = 2;
    private long offeredBytes_;
    /**
     * <code>optional uint64 offered_bytes = 2;</code>
     *
     * <pre>
     * The total number of bytes subjected to policing
     * </pre>
     */
    public boolean hasOfferedBytes() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 offered_bytes = 2;</code>
     *
     * <pre>
     * The total number of bytes subjected to policing
     * </pre>
     */
    public long getOfferedBytes() {
      return offeredBytes_;
    }

    public static final int TRANSMITTED_PACKETS_FIELD_NUMBER = 3;
    private long transmittedPackets_;
    /**
     * <code>optional uint64 transmitted_packets = 3;</code>
     *
     * <pre>
     * The total number of packets not discarded by the policer
     * </pre>
     */
    public boolean hasTransmittedPackets() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 transmitted_packets = 3;</code>
     *
     * <pre>
     * The total number of packets not discarded by the policer
     * </pre>
     */
    public long getTransmittedPackets() {
      return transmittedPackets_;
    }

    public static final int TRANSMITTED_BYTES_FIELD_NUMBER = 4;
    private long transmittedBytes_;
    /**
     * <code>optional uint64 transmitted_bytes = 4;</code>
     *
     * <pre>
     * The total number of bytes not discarded by the policer
     * </pre>
     */
    public boolean hasTransmittedBytes() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 transmitted_bytes = 4;</code>
     *
     * <pre>
     * The total number of bytes not discarded by the policer
     * </pre>
     */
    public long getTransmittedBytes() {
      return transmittedBytes_;
    }

    private void initFields() {
      offeredPackets_ = 0L;
      offeredBytes_ = 0L;
      transmittedPackets_ = 0L;
      transmittedBytes_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, offeredPackets_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, offeredBytes_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, transmittedPackets_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, transmittedBytes_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, offeredPackets_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, offeredBytes_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, transmittedPackets_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, transmittedBytes_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.ExtendedPolicerStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.ExtendedPolicerStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ExtendedPolicerStats}
     *
     * <pre>
     * Extended policer statistics when enhanced policer statistics are available
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ExtendedPolicerStats)
        FirewallOuterClass.ExtendedPolicerStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_ExtendedPolicerStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_ExtendedPolicerStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.ExtendedPolicerStats.class, FirewallOuterClass.ExtendedPolicerStats.Builder.class);
      }

      // Construct using FirewallOuterClass.ExtendedPolicerStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        offeredPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        offeredBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        transmittedPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        transmittedBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_ExtendedPolicerStats_descriptor;
      }

      public FirewallOuterClass.ExtendedPolicerStats getDefaultInstanceForType() {
        return FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance();
      }

      public FirewallOuterClass.ExtendedPolicerStats build() {
        FirewallOuterClass.ExtendedPolicerStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.ExtendedPolicerStats buildPartial() {
        FirewallOuterClass.ExtendedPolicerStats result = new FirewallOuterClass.ExtendedPolicerStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.offeredPackets_ = offeredPackets_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.offeredBytes_ = offeredBytes_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.transmittedPackets_ = transmittedPackets_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.transmittedBytes_ = transmittedBytes_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.ExtendedPolicerStats) {
          return mergeFrom((FirewallOuterClass.ExtendedPolicerStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.ExtendedPolicerStats other) {
        if (other == FirewallOuterClass.ExtendedPolicerStats.getDefaultInstance()) return this;
        if (other.hasOfferedPackets()) {
          setOfferedPackets(other.getOfferedPackets());
        }
        if (other.hasOfferedBytes()) {
          setOfferedBytes(other.getOfferedBytes());
        }
        if (other.hasTransmittedPackets()) {
          setTransmittedPackets(other.getTransmittedPackets());
        }
        if (other.hasTransmittedBytes()) {
          setTransmittedBytes(other.getTransmittedBytes());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.ExtendedPolicerStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.ExtendedPolicerStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long offeredPackets_ ;
      /**
       * <code>optional uint64 offered_packets = 1;</code>
       *
       * <pre>
       * The total number of packets subjected to policing
       * </pre>
       */
      public boolean hasOfferedPackets() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional uint64 offered_packets = 1;</code>
       *
       * <pre>
       * The total number of packets subjected to policing
       * </pre>
       */
      public long getOfferedPackets() {
        return offeredPackets_;
      }
      /**
       * <code>optional uint64 offered_packets = 1;</code>
       *
       * <pre>
       * The total number of packets subjected to policing
       * </pre>
       */
      public Builder setOfferedPackets(long value) {
        bitField0_ |= 0x00000001;
        offeredPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 offered_packets = 1;</code>
       *
       * <pre>
       * The total number of packets subjected to policing
       * </pre>
       */
      public Builder clearOfferedPackets() {
        bitField0_ = (bitField0_ & ~0x00000001);
        offeredPackets_ = 0L;
        onChanged();
        return this;
      }

      private long offeredBytes_ ;
      /**
       * <code>optional uint64 offered_bytes = 2;</code>
       *
       * <pre>
       * The total number of bytes subjected to policing
       * </pre>
       */
      public boolean hasOfferedBytes() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 offered_bytes = 2;</code>
       *
       * <pre>
       * The total number of bytes subjected to policing
       * </pre>
       */
      public long getOfferedBytes() {
        return offeredBytes_;
      }
      /**
       * <code>optional uint64 offered_bytes = 2;</code>
       *
       * <pre>
       * The total number of bytes subjected to policing
       * </pre>
       */
      public Builder setOfferedBytes(long value) {
        bitField0_ |= 0x00000002;
        offeredBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 offered_bytes = 2;</code>
       *
       * <pre>
       * The total number of bytes subjected to policing
       * </pre>
       */
      public Builder clearOfferedBytes() {
        bitField0_ = (bitField0_ & ~0x00000002);
        offeredBytes_ = 0L;
        onChanged();
        return this;
      }

      private long transmittedPackets_ ;
      /**
       * <code>optional uint64 transmitted_packets = 3;</code>
       *
       * <pre>
       * The total number of packets not discarded by the policer
       * </pre>
       */
      public boolean hasTransmittedPackets() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 transmitted_packets = 3;</code>
       *
       * <pre>
       * The total number of packets not discarded by the policer
       * </pre>
       */
      public long getTransmittedPackets() {
        return transmittedPackets_;
      }
      /**
       * <code>optional uint64 transmitted_packets = 3;</code>
       *
       * <pre>
       * The total number of packets not discarded by the policer
       * </pre>
       */
      public Builder setTransmittedPackets(long value) {
        bitField0_ |= 0x00000004;
        transmittedPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 transmitted_packets = 3;</code>
       *
       * <pre>
       * The total number of packets not discarded by the policer
       * </pre>
       */
      public Builder clearTransmittedPackets() {
        bitField0_ = (bitField0_ & ~0x00000004);
        transmittedPackets_ = 0L;
        onChanged();
        return this;
      }

      private long transmittedBytes_ ;
      /**
       * <code>optional uint64 transmitted_bytes = 4;</code>
       *
       * <pre>
       * The total number of bytes not discarded by the policer
       * </pre>
       */
      public boolean hasTransmittedBytes() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 transmitted_bytes = 4;</code>
       *
       * <pre>
       * The total number of bytes not discarded by the policer
       * </pre>
       */
      public long getTransmittedBytes() {
        return transmittedBytes_;
      }
      /**
       * <code>optional uint64 transmitted_bytes = 4;</code>
       *
       * <pre>
       * The total number of bytes not discarded by the policer
       * </pre>
       */
      public Builder setTransmittedBytes(long value) {
        bitField0_ |= 0x00000008;
        transmittedBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 transmitted_bytes = 4;</code>
       *
       * <pre>
       * The total number of bytes not discarded by the policer
       * </pre>
       */
      public Builder clearTransmittedBytes() {
        bitField0_ = (bitField0_ & ~0x00000008);
        transmittedBytes_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:ExtendedPolicerStats)
    }

    static {
      defaultInstance = new ExtendedPolicerStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:ExtendedPolicerStats)
  }

  public interface HierarchicalPolicerStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:HierarchicalPolicerStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Hierarchical policer instance name
     * </pre>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Hierarchical policer instance name
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Hierarchical policer instance name
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional uint64 premium_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the premium policer
     * </pre>
     */
    boolean hasPremiumPackets();
    /**
     * <code>optional uint64 premium_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the premium policer
     * </pre>
     */
    long getPremiumPackets();

    /**
     * <code>optional uint64 premium_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the premium policer
     * </pre>
     */
    boolean hasPremiumBytes();
    /**
     * <code>optional uint64 premium_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the premium policer
     * </pre>
     */
    long getPremiumBytes();

    /**
     * <code>optional uint64 aggregate_packets = 4;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    boolean hasAggregatePackets();
    /**
     * <code>optional uint64 aggregate_packets = 4;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    long getAggregatePackets();

    /**
     * <code>optional uint64 aggregate_bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    boolean hasAggregateBytes();
    /**
     * <code>optional uint64 aggregate_bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    long getAggregateBytes();
  }
  /**
   * Protobuf type {@code HierarchicalPolicerStats}
   *
   * <pre>
   * Hierarchical policer statistics
   * </pre>
   */
  public static final class HierarchicalPolicerStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:HierarchicalPolicerStats)
      HierarchicalPolicerStatsOrBuilder {
    // Use HierarchicalPolicerStats.newBuilder() to construct.
    private HierarchicalPolicerStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private HierarchicalPolicerStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final HierarchicalPolicerStats defaultInstance;
    public static HierarchicalPolicerStats getDefaultInstance() {
      return defaultInstance;
    }

    public HierarchicalPolicerStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private HierarchicalPolicerStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              premiumPackets_ = input.readUInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              premiumBytes_ = input.readUInt64();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              aggregatePackets_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              aggregateBytes_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return FirewallOuterClass.internal_static_HierarchicalPolicerStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return FirewallOuterClass.internal_static_HierarchicalPolicerStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              FirewallOuterClass.HierarchicalPolicerStats.class, FirewallOuterClass.HierarchicalPolicerStats.Builder.class);
    }

    public static com.google.protobuf.Parser<HierarchicalPolicerStats> PARSER =
        new com.google.protobuf.AbstractParser<HierarchicalPolicerStats>() {
      public HierarchicalPolicerStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new HierarchicalPolicerStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<HierarchicalPolicerStats> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Hierarchical policer instance name
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Hierarchical policer instance name
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Hierarchical policer instance name
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PREMIUM_PACKETS_FIELD_NUMBER = 2;
    private long premiumPackets_;
    /**
     * <code>optional uint64 premium_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the premium policer
     * </pre>
     */
    public boolean hasPremiumPackets() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 premium_packets = 2;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the premium policer
     * </pre>
     */
    public long getPremiumPackets() {
      return premiumPackets_;
    }

    public static final int PREMIUM_BYTES_FIELD_NUMBER = 3;
    private long premiumBytes_;
    /**
     * <code>optional uint64 premium_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the premium policer
     * </pre>
     */
    public boolean hasPremiumBytes() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 premium_bytes = 3;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the premium policer
     * </pre>
     */
    public long getPremiumBytes() {
      return premiumBytes_;
    }

    public static final int AGGREGATE_PACKETS_FIELD_NUMBER = 4;
    private long aggregatePackets_;
    /**
     * <code>optional uint64 aggregate_packets = 4;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    public boolean hasAggregatePackets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 aggregate_packets = 4;</code>
     *
     * <pre>
     * The total number of packets marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    public long getAggregatePackets() {
      return aggregatePackets_;
    }

    public static final int AGGREGATE_BYTES_FIELD_NUMBER = 5;
    private long aggregateBytes_;
    /**
     * <code>optional uint64 aggregate_bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    public boolean hasAggregateBytes() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint64 aggregate_bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes marked out-of-specification by
     * the aggregate policer
     * </pre>
     */
    public long getAggregateBytes() {
      return aggregateBytes_;
    }

    private void initFields() {
      name_ = "";
      premiumPackets_ = 0L;
      premiumBytes_ = 0L;
      aggregatePackets_ = 0L;
      aggregateBytes_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, premiumPackets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, premiumBytes_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, aggregatePackets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(5, aggregateBytes_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, premiumPackets_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, premiumBytes_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, aggregatePackets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, aggregateBytes_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static FirewallOuterClass.HierarchicalPolicerStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(FirewallOuterClass.HierarchicalPolicerStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code HierarchicalPolicerStats}
     *
     * <pre>
     * Hierarchical policer statistics
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:HierarchicalPolicerStats)
        FirewallOuterClass.HierarchicalPolicerStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return FirewallOuterClass.internal_static_HierarchicalPolicerStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return FirewallOuterClass.internal_static_HierarchicalPolicerStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                FirewallOuterClass.HierarchicalPolicerStats.class, FirewallOuterClass.HierarchicalPolicerStats.Builder.class);
      }

      // Construct using FirewallOuterClass.HierarchicalPolicerStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        premiumPackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        premiumBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        aggregatePackets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        aggregateBytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return FirewallOuterClass.internal_static_HierarchicalPolicerStats_descriptor;
      }

      public FirewallOuterClass.HierarchicalPolicerStats getDefaultInstanceForType() {
        return FirewallOuterClass.HierarchicalPolicerStats.getDefaultInstance();
      }

      public FirewallOuterClass.HierarchicalPolicerStats build() {
        FirewallOuterClass.HierarchicalPolicerStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public FirewallOuterClass.HierarchicalPolicerStats buildPartial() {
        FirewallOuterClass.HierarchicalPolicerStats result = new FirewallOuterClass.HierarchicalPolicerStats(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.premiumPackets_ = premiumPackets_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.premiumBytes_ = premiumBytes_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.aggregatePackets_ = aggregatePackets_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.aggregateBytes_ = aggregateBytes_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof FirewallOuterClass.HierarchicalPolicerStats) {
          return mergeFrom((FirewallOuterClass.HierarchicalPolicerStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(FirewallOuterClass.HierarchicalPolicerStats other) {
        if (other == FirewallOuterClass.HierarchicalPolicerStats.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasPremiumPackets()) {
          setPremiumPackets(other.getPremiumPackets());
        }
        if (other.hasPremiumBytes()) {
          setPremiumBytes(other.getPremiumBytes());
        }
        if (other.hasAggregatePackets()) {
          setAggregatePackets(other.getAggregatePackets());
        }
        if (other.hasAggregateBytes()) {
          setAggregateBytes(other.getAggregateBytes());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        FirewallOuterClass.HierarchicalPolicerStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (FirewallOuterClass.HierarchicalPolicerStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Hierarchical policer instance name
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Hierarchical policer instance name
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Hierarchical policer instance name
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Hierarchical policer instance name
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Hierarchical policer instance name
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Hierarchical policer instance name
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private long premiumPackets_ ;
      /**
       * <code>optional uint64 premium_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public boolean hasPremiumPackets() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 premium_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public long getPremiumPackets() {
        return premiumPackets_;
      }
      /**
       * <code>optional uint64 premium_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public Builder setPremiumPackets(long value) {
        bitField0_ |= 0x00000002;
        premiumPackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 premium_packets = 2;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public Builder clearPremiumPackets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        premiumPackets_ = 0L;
        onChanged();
        return this;
      }

      private long premiumBytes_ ;
      /**
       * <code>optional uint64 premium_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public boolean hasPremiumBytes() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 premium_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public long getPremiumBytes() {
        return premiumBytes_;
      }
      /**
       * <code>optional uint64 premium_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public Builder setPremiumBytes(long value) {
        bitField0_ |= 0x00000004;
        premiumBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 premium_bytes = 3;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the premium policer
       * </pre>
       */
      public Builder clearPremiumBytes() {
        bitField0_ = (bitField0_ & ~0x00000004);
        premiumBytes_ = 0L;
        onChanged();
        return this;
      }

      private long aggregatePackets_ ;
      /**
       * <code>optional uint64 aggregate_packets = 4;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public boolean hasAggregatePackets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 aggregate_packets = 4;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public long getAggregatePackets() {
        return aggregatePackets_;
      }
      /**
       * <code>optional uint64 aggregate_packets = 4;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public Builder setAggregatePackets(long value) {
        bitField0_ |= 0x00000008;
        aggregatePackets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 aggregate_packets = 4;</code>
       *
       * <pre>
       * The total number of packets marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public Builder clearAggregatePackets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        aggregatePackets_ = 0L;
        onChanged();
        return this;
      }

      private long aggregateBytes_ ;
      /**
       * <code>optional uint64 aggregate_bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public boolean hasAggregateBytes() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint64 aggregate_bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public long getAggregateBytes() {
        return aggregateBytes_;
      }
      /**
       * <code>optional uint64 aggregate_bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public Builder setAggregateBytes(long value) {
        bitField0_ |= 0x00000010;
        aggregateBytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 aggregate_bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes marked out-of-specification by
       * the aggregate policer
       * </pre>
       */
      public Builder clearAggregateBytes() {
        bitField0_ = (bitField0_ & ~0x00000010);
        aggregateBytes_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:HierarchicalPolicerStats)
    }

    static {
      defaultInstance = new HierarchicalPolicerStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:HierarchicalPolicerStats)
  }

  public static final int JNPR_FIREWALL_EXT_FIELD_NUMBER = 6;
  /**
   * <code>extend .JuniperNetworksSensors { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      TelemetryTop.JuniperNetworksSensors,
      FirewallOuterClass.Firewall> jnprFirewallExt = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        FirewallOuterClass.Firewall.class,
        FirewallOuterClass.Firewall.getDefaultInstance());
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Firewall_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Firewall_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_FirewallStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_FirewallStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_MemoryUsage_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_MemoryUsage_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_CounterStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CounterStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_PolicerStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_PolicerStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_ExtendedPolicerStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ExtendedPolicerStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_HierarchicalPolicerStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_HierarchicalPolicerStats_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\016firewall.proto\032\023telemetry_top.proto\"2\n" +
      "\010Firewall\022&\n\016firewall_stats\030\001 \003(\0132\016.Fire" +
      "wallStats\"\364\001\n\rFirewallStats\022\032\n\013filter_na" +
      "me\030\001 \002(\tB\005\202@\002\010\001\022\030\n\ttimestamp\030\002 \001(\004B\005\202@\002\020" +
      "\001\022\"\n\014memory_usage\030\003 \003(\0132\014.MemoryUsage\022$\n" +
      "\rcounter_stats\030\004 \003(\0132\r.CounterStats\022$\n\rp" +
      "olicer_stats\030\005 \003(\0132\r.PolicerStats\022=\n\032hie" +
      "rarchical_policer_stats\030\006 \003(\0132\031.Hierarch" +
      "icalPolicerStats\"<\n\013MemoryUsage\022\023\n\004name\030" +
      "\001 \002(\tB\005\202@\002\010\001\022\030\n\tallocated\030\002 \001(\004B\005\202@\002 \001\"Q",
      "\n\014CounterStats\022\023\n\004name\030\001 \002(\tB\005\202@\002\010\001\022\026\n\007p" +
      "ackets\030\002 \001(\004B\005\202@\002\030\001\022\024\n\005bytes\030\003 \001(\004B\005\202@\002\030" +
      "\001\"\240\001\n\014PolicerStats\022\023\n\004name\030\001 \002(\tB\005\202@\002\010\001\022" +
      "\"\n\023out_of_spec_packets\030\002 \001(\004B\005\202@\002\030\001\022 \n\021o" +
      "ut_of_spec_bytes\030\003 \001(\004B\005\202@\002\030\001\0225\n\026extende" +
      "d_policer_stats\030\004 \001(\0132\025.ExtendedPolicerS" +
      "tats\"\232\001\n\024ExtendedPolicerStats\022\036\n\017offered" +
      "_packets\030\001 \001(\004B\005\202@\002\030\001\022\034\n\roffered_bytes\030\002" +
      " \001(\004B\005\202@\002\030\001\022\"\n\023transmitted_packets\030\003 \001(\004" +
      "B\005\202@\002\030\001\022 \n\021transmitted_bytes\030\004 \001(\004B\005\202@\002\030",
      "\001\"\257\001\n\030HierarchicalPolicerStats\022\023\n\004name\030\001" +
      " \002(\tB\005\202@\002\010\001\022\036\n\017premium_packets\030\002 \001(\004B\005\202@" +
      "\002\030\001\022\034\n\rpremium_bytes\030\003 \001(\004B\005\202@\002\030\001\022 \n\021agg" +
      "regate_packets\030\004 \001(\004B\005\202@\002\030\001\022\036\n\017aggregate" +
      "_bytes\030\005 \001(\004B\005\202@\002\030\001:=\n\021jnpr_firewall_ext" +
      "\022\027.JuniperNetworksSensors\030\006 \001(\0132\t.Firewa" +
      "ll"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          TelemetryTop.getDescriptor(),
        }, assigner);
    internal_static_Firewall_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Firewall_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Firewall_descriptor,
        new java.lang.String[] { "FirewallStats", });
    internal_static_FirewallStats_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_FirewallStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_FirewallStats_descriptor,
        new java.lang.String[] { "FilterName", "Timestamp", "MemoryUsage", "CounterStats", "PolicerStats", "HierarchicalPolicerStats", });
    internal_static_MemoryUsage_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_MemoryUsage_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_MemoryUsage_descriptor,
        new java.lang.String[] { "Name", "Allocated", });
    internal_static_CounterStats_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_CounterStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CounterStats_descriptor,
        new java.lang.String[] { "Name", "Packets", "Bytes", });
    internal_static_PolicerStats_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_PolicerStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_PolicerStats_descriptor,
        new java.lang.String[] { "Name", "OutOfSpecPackets", "OutOfSpecBytes", "ExtendedPolicerStats", });
    internal_static_ExtendedPolicerStats_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_ExtendedPolicerStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ExtendedPolicerStats_descriptor,
        new java.lang.String[] { "OfferedPackets", "OfferedBytes", "TransmittedPackets", "TransmittedBytes", });
    internal_static_HierarchicalPolicerStats_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_HierarchicalPolicerStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_HierarchicalPolicerStats_descriptor,
        new java.lang.String[] { "Name", "PremiumPackets", "PremiumBytes", "AggregatePackets", "AggregateBytes", });
    jnprFirewallExt.internalInit(descriptor.getExtensions().get(0));
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    TelemetryTop.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
