/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.registry.impl;

import com.codahale.metrics.MetricRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.config.api.ParserDefinition;
import org.opennms.netmgt.telemetry.protocols.registry.api.TelemetryServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TelemetryRegistryImpl
implements TelemetryRegistry {
    @Autowired
    @Qualifier(value="adapterRegistry")
    private TelemetryServiceRegistry<AdapterDefinition, Adapter> adapterRegistryDelegate;
    @Autowired
    @Qualifier(value="listenerRegistry")
    private TelemetryServiceRegistry<ListenerDefinition, Listener> listenerRegistryDelegate;
    @Autowired
    @Qualifier(value="parserRegistry")
    private TelemetryServiceRegistry<ParserDefinition, Parser> parserRegistryDelegate;
    private MetricRegistry metricRegistry;
    private final Map<String, AsyncDispatcher<TelemetryMessage>> dispatchers = new HashMap<String, AsyncDispatcher<TelemetryMessage>>();

    public Adapter getAdapter(AdapterDefinition adapterDefinition) {
        return this.adapterRegistryDelegate.getService(adapterDefinition);
    }

    public Listener getListener(ListenerDefinition listenerDefinition) {
        return this.listenerRegistryDelegate.getService(listenerDefinition);
    }

    public Parser getParser(ParserDefinition parserDefinition) {
        return this.parserRegistryDelegate.getService(parserDefinition);
    }

    public void registerDispatcher(String queueName, AsyncDispatcher<TelemetryMessage> dispatcher) {
        if (this.dispatchers.containsKey(queueName)) {
            throw new IllegalArgumentException("A queue with name '" + queueName + "' is already registered");
        }
        this.dispatchers.put(queueName, dispatcher);
    }

    public void clearDispatchers() {
        this.dispatchers.clear();
    }

    public Collection<AsyncDispatcher<TelemetryMessage>> getDispatchers() {
        return this.dispatchers.values();
    }

    public AsyncDispatcher<TelemetryMessage> getDispatcher(String queueName) {
        return this.dispatchers.get(queueName);
    }

    public void removeDispatcher(String queueName) {
        this.dispatchers.remove(queueName);
    }

    public void setAdapterRegistryDelegate(TelemetryServiceRegistry<AdapterDefinition, Adapter> adapterRegistryDelegate) {
        this.adapterRegistryDelegate = adapterRegistryDelegate;
    }

    public void setListenerRegistryDelegate(TelemetryServiceRegistry<ListenerDefinition, Listener> listenerRegistryDelegate) {
        this.listenerRegistryDelegate = listenerRegistryDelegate;
    }

    public void setParserRegistryDelegate(TelemetryServiceRegistry<ParserDefinition, Parser> parserRegistryDelegate) {
        this.parserRegistryDelegate = parserRegistryDelegate;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }
}

