/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.minion;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MapUtils {
    public static Map<String, String> fromDict(Dictionary properties) {
        UnmodifiableIterator keysIter = Iterators.forEnumeration(properties.keys());
        return Maps.toMap((Iterator)keysIter, key -> (String)properties.get(key));
    }

    public static Map<String, String> filterKeysByPrefix(Map<String, String> map, String prefix) {
        return map.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toMap(k -> k.substring(prefix.length(), k.length()), k -> (String)map.get(k)));
    }

    public static String getRequiredString(String key, Map<String, String> parameters) {
        String value = parameters.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("%s must be set.", key));
        }
        return value;
    }

    public static Optional<Integer> getOptionalInteger(String key, Map<String, String> parameters) {
        String strValue = parameters.get(key);
        if (strValue == null) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(strValue));
    }
}

