/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.common.ipc.TelemetryProtos;
import org.opennms.netmgt.telemetry.common.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.opennms.netmgt.telemetry.config.model.QueueConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TelemetryMessageConsumer
implements MessageConsumer<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> {
    private final Logger LOG = LoggerFactory.getLogger(TelemetryMessageConsumer.class);
    @Autowired
    private TelemetryRegistry telemetryRegistry;
    private final QueueDefinition queueDef;
    private final TelemetrySinkModule sinkModule;
    private final List<AdapterDefinition> adapterDefs;
    private final Set<Adapter> adapters = Sets.newHashSet();

    public TelemetryMessageConsumer(QueueConfig queueConfig, TelemetrySinkModule sinkModule) throws Exception {
        this((QueueDefinition)queueConfig, queueConfig.getAdapters(), sinkModule);
    }

    public TelemetryMessageConsumer(QueueDefinition queueDef, Collection<? extends AdapterDefinition> adapterDefs, TelemetrySinkModule sinkModule) {
        this.queueDef = Objects.requireNonNull(queueDef);
        this.sinkModule = Objects.requireNonNull(sinkModule);
        this.adapterDefs = new ArrayList<AdapterDefinition>(adapterDefs);
    }

    @PostConstruct
    public void init() throws Exception {
        for (AdapterDefinition adapterDef : this.adapterDefs) {
            Adapter adapter;
            try {
                adapter = this.telemetryRegistry.getAdapter(adapterDef);
            }
            catch (Exception e) {
                throw new Exception("Failed to create adapter from definition: " + adapterDef, e);
            }
            if (adapter == null) {
                throw new Exception("No adapter found for class: " + adapterDef.getClassName());
            }
            this.adapters.add(adapter);
        }
    }

    public void handleMessage(TelemetryProtos.TelemetryMessageLog messageLog) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"telemetryd");){
            this.LOG.trace("Received message log: {}", (Object)messageLog);
            for (Adapter adapter : this.adapters) {
                try {
                    adapter.handleMessageLog((TelemetryMessageLog)messageLog);
                }
                catch (RuntimeException e) {
                    this.LOG.warn("Adapter: {} failed to handle message log: {}. Skipping.", new Object[]{adapter, messageLog, e});
                }
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.adapters.forEach(adapter -> adapter.destroy());
    }

    public SinkModule<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> getModule() {
        return this.sinkModule;
    }

    public QueueDefinition getQueue() {
        return this.queueDef;
    }

    public void setRegistry(TelemetryRegistry telemetryRegistry) {
        this.telemetryRegistry = telemetryRegistry;
    }
}

