/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.telemetry.adapters.api.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.config.model.Adapter;
import org.opennms.netmgt.telemetry.config.model.Protocol;
import org.opennms.netmgt.telemetry.ipc.TelemetryProtos;
import org.opennms.netmgt.telemetry.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class TelemetryMessageConsumer
implements MessageConsumer<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> {
    private final Logger LOG = LoggerFactory.getLogger(TelemetryMessageConsumer.class);
    private static final ServiceParameters EMPTY_SERVICE_PARAMETERS = new ServiceParameters(Collections.emptyMap());
    @Autowired
    private ApplicationContext applicationContext;
    private final Protocol protocolDef;
    private final TelemetrySinkModule sinkModule;
    private final List<org.opennms.netmgt.telemetry.adapters.api.Adapter> adapters;

    public TelemetryMessageConsumer(Protocol protocol, TelemetrySinkModule sinkModule) throws Exception {
        this.protocolDef = Objects.requireNonNull(protocol);
        this.sinkModule = Objects.requireNonNull(sinkModule);
        this.adapters = new ArrayList<org.opennms.netmgt.telemetry.adapters.api.Adapter>(protocol.getAdapters().size());
    }

    @PostConstruct
    public void init() throws Exception {
        for (Adapter adapterDef : this.protocolDef.getAdapters()) {
            try {
                this.adapters.add(this.buildAdapter(adapterDef));
            }
            catch (Exception e) {
                throw new Exception("Failed to create adapter from definition: " + adapterDef, e);
            }
        }
    }

    public void handleMessage(TelemetryProtos.TelemetryMessageLog messageLog) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"telemetryd");){
            this.LOG.trace("Received message log: {}", (Object)messageLog);
            for (org.opennms.netmgt.telemetry.adapters.api.Adapter adapter : this.adapters) {
                try {
                    adapter.handleMessageLog((TelemetryMessageLog)messageLog);
                }
                catch (RuntimeException e) {
                    this.LOG.warn("Adapter: {} failed to handle message log: {}. Skipping.", (Object)adapter, (Object)messageLog);
                }
            }
        }
    }

    private org.opennms.netmgt.telemetry.adapters.api.Adapter buildAdapter(Adapter adapterDef) throws Exception {
        Object adapterInstance;
        try {
            Class<?> clazz = Class.forName(adapterDef.getClassName());
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            adapterInstance = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to instantiate adapter with class name '%s'.", adapterDef.getClassName(), e));
        }
        if (!(adapterInstance instanceof org.opennms.netmgt.telemetry.adapters.api.Adapter)) {
            throw new IllegalArgumentException(String.format("%s must implement %s", adapterDef.getClassName(), org.opennms.netmgt.telemetry.adapters.api.Adapter.class.getCanonicalName()));
        }
        org.opennms.netmgt.telemetry.adapters.api.Adapter adapter = (org.opennms.netmgt.telemetry.adapters.api.Adapter)adapterInstance;
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)adapter);
        wrapper.setPropertyValues(adapterDef.getParameterMap());
        AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        beanFactory.autowireBean((Object)adapter);
        beanFactory.initializeBean((Object)adapter, "adapter");
        adapter.setProtocol((org.opennms.netmgt.telemetry.config.api.Protocol)this.protocolDef);
        return adapter;
    }

    public SinkModule<TelemetryMessage, TelemetryProtos.TelemetryMessageLog> getModule() {
        return this.sinkModule;
    }

    public Protocol getProtocol() {
        return this.protocolDef;
    }
}

