/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.telemetry.config.model.Adapter;
import org.opennms.netmgt.telemetry.config.model.Listener;
import org.opennms.netmgt.telemetry.config.model.Package;
import org.opennms.netmgt.telemetry.ipc.ProtocolDefinition;

@XmlRootElement(name="protocol")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Protocol
implements ProtocolDefinition {
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="description")
    private String description;
    @XmlAttribute(name="enabled")
    private Boolean enabled;
    @XmlAttribute(name="num-threads")
    private Integer numThreads;
    @XmlAttribute(name="batch-size")
    private Integer batchSize;
    @XmlAttribute(name="batch-interval-ms")
    private Integer batchIntervalMs;
    @XmlAttribute(name="queue-size")
    private Integer queueSize;
    @XmlElement(name="listener")
    private List<Listener> listeners = new ArrayList<Listener>();
    @XmlElement(name="adapter")
    private List<Adapter> adapters = new ArrayList<Adapter>();
    @XmlElement(name="package")
    private List<Package> packages = new ArrayList<Package>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return this.enabled != null ? this.enabled : true;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Optional<Integer> getNumThreads() {
        return Optional.ofNullable(this.numThreads);
    }

    public void setNumThreads(Integer numThreads) {
        this.numThreads = numThreads;
    }

    public Optional<Integer> getBatchSize() {
        return Optional.ofNullable(this.batchSize);
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Optional<Integer> getBatchIntervalMs() {
        return Optional.ofNullable(this.batchIntervalMs);
    }

    public void setBatchIntervalMs(Integer batchIntervalMs) {
        this.batchIntervalMs = batchIntervalMs;
    }

    public Optional<Integer> getQueueSize() {
        return Optional.ofNullable(this.queueSize);
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<Listener> listeners) {
        this.listeners = listeners;
    }

    public List<Adapter> getAdapters() {
        return this.adapters;
    }

    public void setAdapters(List<Adapter> adapters) {
        this.adapters = adapters;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public void setPackages(List<Package> packages) {
        this.packages = packages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return Objects.equals(this.name, protocol.name) && Objects.equals(this.description, protocol.description) && Objects.equals(this.enabled, protocol.enabled) && Objects.equals(this.numThreads, protocol.numThreads) && Objects.equals(this.batchSize, protocol.batchSize) && Objects.equals(this.batchIntervalMs, protocol.batchIntervalMs) && Objects.equals(this.queueSize, protocol.queueSize) && Objects.equals(this.listeners, protocol.listeners) && Objects.equals(this.adapters, protocol.adapters) && Objects.equals(this.packages, protocol.packages);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.enabled, this.numThreads, this.batchSize, this.batchIntervalMs, this.queueSize, this.listeners, this.adapters, this.packages);
    }

    public String toString() {
        return "Protocol{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", enabled=" + this.enabled + ", numThreads=" + this.numThreads + ", batchSize=" + this.batchSize + ", batchIntervalMs=" + this.batchIntervalMs + ", queueSize=" + this.queueSize + ", listeners=" + this.listeners + ", adapters=" + this.adapters + ", packages=" + this.packages + '}';
    }
}

