/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.utils;

import java.lang.reflect.Constructor;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.telemetry.listeners.api.Listener;
import org.opennms.netmgt.telemetry.listeners.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class ListenerFactory {
    public static Listener buildListener(ListenerDefinition listenerDef, AsyncDispatcher<TelemetryMessage> dispatcher) throws Exception {
        Object listenerInstance;
        try {
            Class<?> clazz = Class.forName(listenerDef.getClassName());
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            listenerInstance = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to instantiate listener with class name '%s'.", listenerDef.getClassName(), e));
        }
        if (!(listenerInstance instanceof Listener)) {
            throw new IllegalArgumentException(String.format("%s must implement %s", listenerDef.getClassName(), Listener.class.getCanonicalName()));
        }
        Listener listener = (Listener)listenerInstance;
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)listener);
        wrapper.setPropertyValues(listenerDef.getParameterMap());
        listener.setName(listenerDef.getName());
        listener.setDispatcher(dispatcher);
        return listener;
    }
}

