/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.ipc;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.telemetry.ipc.TelemetryMessageDTO;

@XmlRootElement(name="telemetry-message-log")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TelemetryMessageLogDTO
implements Message {
    @XmlAttribute(name="source-address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress sourceAddress;
    @XmlAttribute(name="source-port")
    private int sourcePort;
    @XmlAttribute(name="system-id")
    private String systemId;
    @XmlAttribute(name="location")
    private String location;
    @XmlElement(name="messages")
    private List<TelemetryMessageDTO> messages;

    public TelemetryMessageLogDTO() {
        this.messages = new ArrayList<TelemetryMessageDTO>(0);
    }

    public TelemetryMessageLogDTO(String location, String systemId, InetSocketAddress source) {
        this(location, systemId, source, new ArrayList<TelemetryMessageDTO>(0));
    }

    public TelemetryMessageLogDTO(String location, String systemId, InetSocketAddress source, List<TelemetryMessageDTO> messages) {
        this.location = location;
        this.systemId = systemId;
        this.sourceAddress = source.getAddress();
        this.sourcePort = source.getPort();
        this.messages = messages;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(InetAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<TelemetryMessageDTO> getMessages() {
        return this.messages;
    }

    public void setMessages(List<TelemetryMessageDTO> messages) {
        this.messages = messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryMessageLogDTO that = (TelemetryMessageLogDTO)o;
        return this.sourcePort == that.sourcePort && Objects.equals(this.sourceAddress, that.sourceAddress) && Objects.equals(this.systemId, that.systemId) && Objects.equals(this.location, that.location) && Objects.equals(this.messages, that.messages);
    }

    public int hashCode() {
        return Objects.hash(this.sourceAddress, this.sourcePort, this.systemId, this.location, this.messages);
    }

    public String toString() {
        return "TelemetryMessageLogDTO{sourceAddress=" + this.sourceAddress + ", sourcePort=" + this.sourcePort + ", systemId='" + this.systemId + '\'' + ", location='" + this.location + '\'' + ", messages=" + this.messages + '}';
    }
}

