/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import com.google.common.base.MoreObjects;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.telemetry.config.api.RrdDefinition;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PackageConfig
implements PackageDefinition {
    @XmlAttribute(name="name")
    private String name;
    @XmlElement(name="filter")
    private Filter filter;
    @XmlElement(name="rrd")
    private Rrd rrd;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getFilterRule() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getContent();
    }

    public Rrd getRrd() {
        return this.rrd;
    }

    public void setRrd(Rrd rrd) {
        this.rrd = rrd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageConfig that = (PackageConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.filter, that.filter) && Objects.equals(this.rrd, that.rrd);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.filter, this.rrd);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("filter", (Object)this.filter).add("rrd", (Object)this.rrd).toString();
    }

    @XmlRootElement(name="rrd")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Rrd
    implements RrdDefinition {
        private static final String DEFAULT_BASE_DIRECTORY = Paths.get(System.getProperty("opennms.home"), "share", "rrd", "snmp").toString();
        @XmlAttribute(name="step")
        private Integer step;
        @XmlElement(name="rra")
        private List<String> rras = new ArrayList<String>();
        @XmlAttribute(name="base-directory")
        private String baseDir;

        public Integer getStep() {
            return this.step;
        }

        public void setStep(Integer step) {
            this.step = step;
        }

        public List<String> getRras() {
            return this.rras;
        }

        public void setRras(List<String> rras) {
            this.rras = rras;
        }

        public String getBaseDir() {
            if (this.baseDir == null) {
                return DEFAULT_BASE_DIRECTORY;
            }
            return this.baseDir;
        }

        public void setBaseDir(String baseDir) {
            this.baseDir = baseDir;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rrd that = (Rrd)o;
            return Objects.equals(this.step, that.step) && Objects.equals(this.rras, that.rras) && Objects.equals(this.baseDir, that.baseDir);
        }

        public int hashCode() {
            return Objects.hash(this.step, this.rras, this.baseDir);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("step", (Object)this.step).add("rras", this.rras).add("baseDir", (Object)this.baseDir).toString();
        }
    }

    @XmlRootElement(name="filter")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Filter {
        @XmlValue
        private String content;

        public Filter() {
        }

        public Filter(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Filter that = (Filter)o;
            return Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hash(this.content);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.content).toString();
        }
    }
}

