/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.opennms.netmgt.telemetry.config.model.AdapterConfig;

@XmlRootElement(name="queue")
@XmlAccessorType(value=XmlAccessType.NONE)
public class QueueConfig
implements QueueDefinition {
    @XmlAttribute(name="name", required=true)
    @XmlID
    private String name;
    @XmlAttribute(name="threads")
    private Integer numThreads;
    @XmlAttribute(name="batch-size")
    private Integer batchSize;
    @XmlAttribute(name="batch-interval")
    private Integer batchIntervalMs;
    @XmlAttribute(name="queue-size")
    private Integer queueSize;
    @XmlElement(name="adapter")
    private List<AdapterConfig> adapters = new ArrayList<AdapterConfig>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Optional<Integer> getNumThreads() {
        return Optional.ofNullable(this.numThreads);
    }

    public void setNumThreads(Integer numThreads) {
        this.numThreads = numThreads;
    }

    public Optional<Integer> getBatchSize() {
        return Optional.ofNullable(this.batchSize);
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Optional<Integer> getBatchIntervalMs() {
        return Optional.ofNullable(this.batchIntervalMs);
    }

    public void setBatchIntervalMs(Integer batchIntervalMs) {
        this.batchIntervalMs = batchIntervalMs;
    }

    public Optional<Integer> getQueueSize() {
        return Optional.ofNullable(this.queueSize);
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public List<AdapterConfig> getAdapters() {
        return this.adapters;
    }

    public void setAdapters(List<AdapterConfig> adapters) {
        this.adapters = adapters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueConfig that = (QueueConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.numThreads, that.numThreads) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.batchIntervalMs, that.batchIntervalMs) && Objects.equals(this.queueSize, that.queueSize) && Objects.equals(this.adapters, that.adapters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.numThreads, this.batchSize, this.batchIntervalMs, this.queueSize, this.adapters);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("num-threads", (Object)this.numThreads).add("batch-size", (Object)this.batchSize).add("batch-interval-ms", (Object)this.batchIntervalMs).add("queue-size", (Object)this.queueSize).addValue(this.adapters).toString();
    }
}

